/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import com.ibm.ws.install.configmanager.utils.ValidationManager;
import com.ibm.ws.profile.utils.CommandLineArgumentsUtils;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidationManagerUtils {
    private static List m_listSortedValidationManagers = null;
    private static Hashtable m_hashtableValidationErrorMessages = null;
    private static Hashtable m_hashtableVMCache = null;
    private static final boolean F_DEFAULT_VALIDATION_VALUE = true;
    private static final String S_EMPTY = "";
    private static final Logger LOGGER = LoggerFactory.createLogger(ValidationManagerUtils.class);
    private static final String S_CLASS_NAME = ValidationManagerUtils.class.getName();

    public static boolean isArgumentValueValid(String string, String string2) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        String string3 = System.getProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR);
        try {
            if (string3 != null) {
                String[] stringArray = new String[]{"-templatePath", string3};
                ArgumentValueFetcher.setCommandLineArguments(CommandLineArgumentsUtils.convertCommandLineToHashtable(stringArray));
            }
        }
        catch (Throwable throwable) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isArgumentValueValid", "Exception caching commandline args" + throwable);
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        return ValidationManagerUtils.isArgumentValueValid(string, string2, new Hashtable());
    }

    public static boolean isArgumentValueValid(String string, String string2, Map map) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        String[] stringArray = new String[]{string};
        map.put(string, string2);
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map);
        ValidationManagerUtils.initialize();
        Hashtable hashtable = ValidationManagerUtils.matchArgumentsToValidationManagers(stringArray);
        boolean bl = ValidationManagerUtils.executeAllValidators(hashtable, map);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "isArgumentValueValid");
        return bl;
    }

    public static boolean areAllArgumentsValid(Map map) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        Properties properties = SystemPropertiesUtils.setArgumentsIntoSystemProperties(map);
        ValidationManagerUtils.initialize();
        boolean bl = ValidationManagerUtils.executeAllValidators(map);
        SystemPropertiesUtils.resetSystemProperties(properties);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "areAllArgumentsValid");
        return bl;
    }

    public static Hashtable getAllErrorMessages() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "getAllErrorMessages");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "getAllErrorMessages");
        return m_hashtableValidationErrorMessages;
    }

    public static List getErrorMessagesForArgument(String string) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "initialize");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "parseOutputForErrorMessage");
        return (List)m_hashtableValidationErrorMessages.get(string);
    }

    public static void reinitialize() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "reinitialize");
        m_listSortedValidationManagers = null;
        m_hashtableVMCache = null;
        ValidationManagerUtils.initialize();
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "reinitialize");
    }

    private static void initialize() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "initialize");
        if (m_hashtableVMCache == null) {
            m_hashtableVMCache = new Hashtable();
        }
        ValidationManagerUtils.clearErrorMessages();
        String string = ValidationManagerUtils.determineTemplatePath();
        String string2 = ValidationManagerUtils.determineCurrentMode();
        String string3 = ValidationManagerUtils.determineProfileName();
        List list = PrereqTemplateUtils.getListOfTemplatePathsForMode(string2, string3, string);
        ValidationManagerUtils.createValidationManagers(list, string2);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "initialize");
    }

    private static void clearErrorMessages() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "clearErrorMessages");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "clearErrorMessages");
        m_hashtableValidationErrorMessages = new Hashtable();
    }

    private static void createValidationManagers(List list, String string) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "createValidationManagers");
        Vector<ValidationManager> vector = new Vector<ValidationManager>();
        if (m_hashtableVMCache == null) {
            m_hashtableVMCache = new Hashtable();
        }
        for (int i = 0; i < list.size(); ++i) {
            ValidationManager validationManager;
            File file = (File)list.get(i);
            if (m_hashtableVMCache.get(file) != null) {
                validationManager = (ValidationManager)m_hashtableVMCache.get(file);
            } else {
                String string2 = file.getAbsolutePath();
                String string3 = ValidationManagerUtils.determineActionRegistryFileName();
                validationManager = new ValidationManager(string2, string2 + File.separator + string3);
                m_hashtableVMCache.put(file, validationManager);
            }
            vector.add(validationManager);
        }
        m_listSortedValidationManagers = vector;
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "createValidationManagers");
    }

    private static String determineActionRegistry() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineActionRegistry");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistry");
        return System.getProperty(ConfigManagerConstants.S_ARG_ACTION_REGISTRY);
    }

    private static Hashtable matchArgumentsToValidationManagers(String[] stringArray) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "matchArgumentsToValidationManager");
        Hashtable<ValidationManager, Vector> hashtable = new Hashtable<ValidationManager, Vector>();
        for (int i = 0; i < stringArray.length; ++i) {
            List list = ValidationManagerUtils.findValidationManagersForArgument(stringArray[i]);
            for (int j = 0; j < list.size(); ++j) {
                Vector vector;
                ValidationManager validationManager = (ValidationManager)list.get(j);
                if (hashtable.containsKey(validationManager)) {
                    vector = (Vector)hashtable.get(validationManager);
                    vector.add(stringArray[i]);
                    continue;
                }
                vector = new Vector();
                vector.add(stringArray[i]);
                hashtable.put(validationManager, vector);
            }
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "matchArgumentsToValidationManager");
        return hashtable;
    }

    private static boolean executeAllValidators(Map map, Map map2) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "executeAllValidators");
        boolean bl = true;
        ValidationManagerUtils.clearErrorMessages();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Vector vector;
            ValidationManager validationManager = (ValidationManager)iterator.next();
            if (validationManager.areAllArgumentsValid(vector = (Vector)map.get(validationManager), map2)) continue;
            Hashtable hashtable = validationManager.getAllErrorMessages();
            ValidationManagerUtils.storeErrorMessages(hashtable);
            bl = false;
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "executeAllValidators");
        return bl;
    }

    private static boolean executeAllValidators(Map map) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "executeAllValidators");
        boolean bl = true;
        ValidationManagerUtils.clearErrorMessages();
        for (int i = 0; i < m_listSortedValidationManagers.size(); ++i) {
            ValidationManager validationManager = (ValidationManager)m_listSortedValidationManagers.get(i);
            if (validationManager.areAllArgumentsValid(map)) continue;
            Hashtable hashtable = validationManager.getAllErrorMessages();
            ValidationManagerUtils.storeErrorMessages(hashtable);
            bl = false;
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "executeAllValidators");
        return bl;
    }

    private static void storeErrorMessages(Map map) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "storeErrorMessage");
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list = (List)map.get(string);
            if (m_hashtableValidationErrorMessages.containsKey(string) && m_hashtableValidationErrorMessages.get(string) != null) {
                List list2 = (List)m_hashtableValidationErrorMessages.get(string);
                list2.addAll(list);
                continue;
            }
            m_hashtableValidationErrorMessages.put(string, list);
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "storeErrorMessage");
    }

    private static List findValidationManagersForArgument(String string) {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "findValidationManagersForArgument");
        Vector<ValidationManager> vector = new Vector<ValidationManager>();
        for (int i = m_listSortedValidationManagers.size() - 1; i >= 0; --i) {
            ValidationManager validationManager = (ValidationManager)m_listSortedValidationManagers.get(i);
            if (!validationManager.isArgumentAvailableForValidating(string)) continue;
            vector.add(validationManager);
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "findValidationManagersForArgument");
        return vector;
    }

    private static String determineTemplatePath() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineTemplatePath");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineTemplatePath");
        return System.getProperty(ConfigManagerConstants.S_ARG_CONFIG_DIR);
    }

    private static String determineProfileName() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineProfileName");
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineProfileName");
        return System.getProperty("profileName");
    }

    private static String determineActionRegistryFileName() {
        LOGGER.entering(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
        String string = ValidationManagerUtils.determineActionRegistry();
        if (string != null && !string.equals(S_EMPTY)) {
            File file = new File(string);
            LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
            return file.getName();
        }
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "determineActionRegistryFileName");
        return S_EMPTY;
    }

    private static String determineCurrentMode() {
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "initialize");
        String string = System.getProperty("create");
        String string2 = System.getProperty("augment");
        String string3 = System.getProperty("unaugment");
        String string4 = System.getProperty("delete");
        String string5 = null;
        if (string == null && string2 == null && string3 == null & string4 == null) {
            string5 = null;
        } else if (string2 != null && string2.equals(S_EMPTY) && string == null && string3 == null && string4 == null) {
            string5 = "augment";
        } else if (string != null && string.equals(S_EMPTY) && string2 == null && string3 == null && string4 == null) {
            string5 = "create";
        } else if (string3 != null && string3.equals(S_EMPTY) && string == null && string2 == null && string4 == null) {
            string5 = "unaugment";
        } else if (string4 != null && string4.equals(S_EMPTY) && string == null && string2 == null && string3 == null) {
            string5 = "delete";
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "determineCurrentMode", "Mode was determined to be: " + string5);
        LOGGER.exiting(ValidationManagerUtils.class.getName(), "initialize");
        return string5;
    }
}

