/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WSProfileFilenameFilter
implements FilenameFilter {
    private String[] m_saPrefixValues = null;
    private String[] m_saFileExtensions = null;

    public WSProfileFilenameFilter(String[] stringArray, String[] stringArray2) {
        this.m_saPrefixValues = stringArray;
        this.m_saFileExtensions = stringArray2;
    }

    public boolean accept(File file, String string) {
        boolean bl = false;
        int n = 0;
        if (this.m_saPrefixValues == null || this.m_saPrefixValues.length == 0) {
            if (this.m_saFileExtensions == null || this.m_saFileExtensions.length == 0) {
                return true;
            }
            n = string.lastIndexOf(".") + 1;
            if (n <= 0 || n >= string.length()) {
                return false;
            }
            return this.doesFileMatchCriteria(this.m_saFileExtensions, string.substring(n));
        }
        bl = this.doesFileMatchCriteria(this.m_saPrefixValues, string);
        if (this.m_saFileExtensions == null || this.m_saFileExtensions.length == 0 || !bl) {
            return bl;
        }
        n = string.lastIndexOf(".") + 1;
        if (n <= 0 || n >= string.length()) {
            return false;
        }
        return bl && this.doesFileMatchCriteria(this.m_saFileExtensions, string.substring(n));
    }

    private boolean doesFileMatchCriteria(String[] stringArray, String string) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Matcher matcher = Pattern.compile(stringArray[i].replaceAll("\\.", "\\.") + ".*").matcher(string);
            if (!matcher.matches()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

