/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DirectoryValidator
extends GenericValidator {
    public final String S_INVALID_PATH_CHARS_WINDOWS_REGEX = "[{}:;\\&\\*?\"<>|%,=+'#$^`!\\[\\]]";
    public final String S_INVALID_PATH_CHARS_UNIX_REGEX = "[{}`!\\&\\*\\(\\)|;:<>?\"\\\\,=+%'$#^\\[\\]]";
    public static final String sINVALID_CHAR_COMB_REGEX = "]]>";
    public final String sCOLON = ":";
    public final String S_BACK_SLASH = "\\";
    public final String S_SPACE = " ";
    private static final Logger LOGGER = LoggerFactory.createLogger(DirectoryValidator.class);
    private static final String S_CLASS_NAME = DirectoryValidator.class.getCanonicalName();

    public boolean runValidator() {
        File file;
        LOGGER.entering(DirectoryValidator.class.getName(), "runValidator");
        boolean bl = true;
        int n = this.sValidatorArgValue.indexOf(":");
        if (n > 0 && WASUtilities.isWindows()) {
            file = new File(this.sValidatorArgValue.substring(0, n + 1));
            bl = file.exists();
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", file.getAbsolutePath() + " exists? " + bl);
            if (!bl) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
                return bl;
            }
        }
        if (!WASUtilities.isWindows()) {
            n = -1;
            if (this.sValidatorArgValue.indexOf("\\") != -1 || this.sValidatorArgValue.indexOf(" ") != -1) {
                bl = false;
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("name.error.invalidChars", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
                return bl;
            }
            if (this.evaluateRegex("[{}`!\\&\\*\\(\\)|;:<>?\"\\\\,=+%'$#^\\[\\]]", this.sValidatorArgValue) || this.evaluateRegex(sINVALID_CHAR_COMB_REGEX, this.sValidatorArgValue)) {
                bl = false;
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("name.error.invalidChars", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
                LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
                return bl;
            }
        } else if (this.evaluateRegex("[{}:;\\&\\*?\"<>|%,=+'#$^`!\\[\\]]", this.sValidatorArgValue.substring(n + 1)) || this.evaluateRegex(sINVALID_CHAR_COMB_REGEX, this.sValidatorArgValue.substring(n + 1))) {
            bl = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("name.error.invalidChars", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
            return bl;
        }
        if (!this.isValidDir(this.sValidatorArgValue, file = new File(this.sValidatorArgValue))) {
            bl = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
            LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
            return bl;
        }
        LOGGER.exiting(DirectoryValidator.class.getName(), "runValidator");
        return bl;
    }

    private boolean evaluateRegex(String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        Matcher matcher = pattern.matcher(string2);
        return matcher.find();
    }

    protected boolean isValidDir(String string, File file) {
        LOGGER.entering(DirectoryValidator.class.getName(), "isValidDir");
        boolean bl = false;
        if (!file.exists()) {
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "isValidDir", file.getAbsolutePath() + " does not exist");
            File file2 = file.getParentFile();
            LinkedList<File> linkedList = new LinkedList<File>();
            if (file2 == null) {
                bl = file.canWrite();
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "isValidDir", "Is " + file.getAbsolutePath() + " writable? " + bl);
            }
            while (file2 != null && !file2.exists()) {
                linkedList.add(file2);
                file2 = file2.getParentFile();
            }
            bl = file.mkdirs();
            if (bl) {
                file.delete();
                for (int i = 0; i < linkedList.size(); ++i) {
                    File file3 = (File)linkedList.get(i);
                    file3.delete();
                }
            }
            LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
            return bl;
        }
        if (file.isDirectory() && file.canWrite()) {
            int n = file.list().length;
            File file4 = new File(file.getAbsolutePath() + File.separatorChar + "temp");
            boolean bl2 = file4.mkdirs();
            if (bl2) {
                file4.delete();
            }
            if (n <= 0) {
                LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
                return true;
            }
        }
        LOGGER.exiting(DirectoryValidator.class.getName(), "isValidDir");
        return false;
    }
}

