/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.io.file.NativeFile;
import com.ibm.io.file.exception.AccessDeniedException;
import com.ibm.io.file.exception.NativeFileIOException;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.PrereqTemplateUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskSpaceValidator
extends GenericValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(DiskSpaceValidator.class);
    private static final String S_CLASS_NAME = DiskSpaceValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(DiskSpaceValidator.class.getName(), "runValidator");
        boolean bl = false;
        String string = System.getProperty(this.sValidatorArgKey);
        String string2 = System.getProperty("templatePath");
        String string3 = System.getProperty("profileName");
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profilePath:" + string);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "templatePath:" + string2);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "profileName:" + string3);
        String string4 = System.getProperty("create");
        String string5 = System.getProperty("augment");
        String string6 = null;
        if (string4 == null && string5 == null) {
            bl = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.error.noModeSpecified", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return false;
        }
        if (string4 == null && string5.equals("")) {
            string6 = "augment";
        } else if (string4.equals("") && string5 == null) {
            string6 = "create";
        } else if (string4.equals("") && string5.equals("")) {
            bl = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.error.tooManyModes", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return bl;
        }
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "Current mode:" + string6);
        int n = 0;
        if ((string == null || string.equals("")) && !string6.equals("augment")) {
            bl = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgKey);
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return bl;
        }
        if (string2 == null || string2.equals("")) {
            bl = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "templatePath");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return bl;
        }
        if (string6.equals("augment") && (string3 == null || string3.equals(""))) {
            bl = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "profileName");
            LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
            return bl;
        }
        try {
            if (string6.equals("create")) {
                n = PrereqTemplateUtils.getTotalTemplateSizeForStackCreation(new File(string2));
            } else if (string6.equals("augment")) {
                n = PrereqTemplateUtils.getTotalTemplateSizeForStackAugmentation(new File(string2), string3);
                string = WSProfile.getProfile(string3).getPath().getCanonicalPath();
            }
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "WSProfileException - reading requried size");
            LogUtils.logException(LOGGER, wSProfileException, Level.FINE);
            ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - reading required size");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
            ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected required space (MB): " + n);
        double d = 0.0;
        try {
            String string7 = new WSProfileProperties().getProperty("WS_NATIVE_FILE_JNI_DIRECTORY");
            NativeFile.initializeLibrary(new File(string7), null, true);
            if (!NativeFile.isNativeFileFunctionalityAvailable()) {
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFile functionality is not available");
                bl = false;
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
                return bl;
            }
            NativeFile nativeFile = new NativeFile(new File(string).getAbsolutePath());
            d = this.convertBytesToMB(nativeFile.getFreeSpace());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected free space before conversion: " + nativeFile.getFreeSpace());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "runValidator", "Detected free space (MB): " + d);
        }
        catch (AccessDeniedException accessDeniedException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "AccessDeniedException - reading free space");
            LogUtils.logException(LOGGER, accessDeniedException, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (NullPointerException nullPointerException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NullPointerException - reading free space");
            LogUtils.logException(LOGGER, nullPointerException, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (NativeFileIOException nativeFileIOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "NativeFileIOException - reading free space");
            LogUtils.logException(LOGGER, nativeFileIOException, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "FileNotFoundException - reading free space");
            LogUtils.logException(LOGGER, fileNotFoundException, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "IOException - reading free space");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.invalid.params", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        boolean bl2 = bl = d > (double)n;
        if (!bl) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("diskspace.insufficient", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
        }
        LOGGER.exiting(DiskSpaceValidator.class.getName(), "runValidator");
        return bl;
    }

    private double convertBytesToMB(long l) {
        double d = 0.0;
        d = (double)l / 1024.0 / 1024.0;
        return d;
    }
}

