/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.profile.utils.FileUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.utils.WSProfileFilenameFilter;
import com.ibm.ws.profile.validators.GenericFederateLaterValidator;
import com.ibm.ws.ssl.utils.RetrieveSigners;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DmgrConnectionValidator
extends GenericFederateLaterValidator {
    private String logfile;
    private boolean trace = true;
    private boolean replacelog = true;
    AdminClient adminClient = null;
    private static final String S_WAS_HOME = "WAS_HOME";
    private static final String S_LIB = "lib";
    private static final String S_PLUGINS = "plugins";
    private static final String S_TRUST_STORE_FILE_PREFIX = "trust";
    private static final String S_TRUST_STORE_FILE_SUFFIX = ".p12";
    private static final String S_KEY_STORE_FILE_PREFIX = "key";
    private static final String S_KEY_STORE_FILE_SUFFIX = ".p12";
    private static final String S_DMGR_CONNECTION_TMP_FILE_PREFIX = "dmgrConnection";
    private static final String S_DMGR_CONNECTION_TMP_FILE_SUFFIX = "tmp";
    private static final String S_DMGR_CONNECTION_PSSWD = "dmgrConnectionTest";
    private static final String[] ARR_DEPENDENT_JARS_PLUGINS = new String[]{"com.ibm.ws.emf_2.1", "org.eclipse.core.runtime_3.1", "org.eclipse.osgi_3.1", "com.ibm.ws.bootstrap_6.1", "com.ibm.ws.security.crypto_6.1", "org.eclipse.emf.ecore_2.2", "org.eclipse.emf.common_2.2", "org.eclipse.equinox.registry_3.2", "org.eclipse.osgi_3.2", "org.eclipse.core.runtime_3.2", "org.eclipse.equinox.common_3.2"};
    private static final String[] ARR_DEPENDENT_JARS_LIB = new String[]{"bootstrap.jar", "j2ee.jar"};
    private static final Logger LOGGER = LoggerFactory.createLogger(DmgrConnectionValidator.class);
    private static final String S_CLASS_NAME = DmgrConnectionValidator.class.getName();
    private static final String S_JAR_EXT = "jar";
    private static PrintStream m_SystemOut = System.out;
    private static PrintStream m_SystemErr = System.err;
    private File tmpFile = null;
    private File keyStoreTmpFile = null;
    private File trustStoreTmpFile = null;

    public static void main(String[] stringArray) {
        DmgrConnectionValidator dmgrConnectionValidator = new DmgrConnectionValidator();
        boolean bl = dmgrConnectionValidator.execute();
        if (bl) {
            System.out.println("[valid]");
        } else {
            System.out.println("[" + dmgrConnectionValidator.getErrorOutput() + "]");
        }
    }

    public boolean runValidator() {
        LOGGER.entering(DmgrConnectionValidator.class.getName(), "execute");
        if (!this.addJarsToRunTime()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", "Failure: Couldn't add the required jars to the classpath.");
            return false;
        }
        String string = System.getProperty("dmgrHost");
        String string2 = System.getProperty("dmgrPort");
        if (string == null && string2 == null) {
            boolean bl = true;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        if (string != null && string2 == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrPort", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean bl = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        if (string == null && string2 != null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrHost", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean bl = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        String string3 = System.getProperty("dmgrAdminUserName");
        String string4 = System.getProperty("dmgrAdminPassword");
        if (string3 == null && string4 == null) {
            boolean bl = this.checkDmgrConnection(string, string2);
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        if (string3 != null && string4 == null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrAdminPassword", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean bl = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        if (string3 == null && string4 != null) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noDmgrAdminUserName", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            boolean bl = false;
            LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
            return bl;
        }
        boolean bl = this.checkDmgrConnection(string, string2, string3, string4);
        LOGGER.exiting(DmgrConnectionValidator.class.getName(), "execute");
        return bl;
    }

    private boolean checkDmgrConnection(String string, String string2) {
        return this.checkDmgrConnection(string, string2, "", "");
    }

    private boolean checkDmgrConnection(String string, String string2, String string3, String string4) {
        Properties properties = new Properties();
        try {
            this.redirectSystemOut();
            this.doSOAP(properties, string, string2, string3, string4);
            this.adminClient = AdminClientFactory.createAdminClient(properties);
            String string5 = (String)this.adminClient.getAttribute(this.adminClient.getServerMBean(), "processType");
            String string6 = Utils.getNetmgrName(this.adminClient);
            ObjectName objectName = this.getMBeanByType("DeploymentManager", string6);
            this.removeKeyAndTrustTempFiles();
            this.restoreSystemOut();
            if (objectName != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            this.restoreSystemOut();
            this.removeKeyAndTrustTempFiles();
            if (this.isMessageInException("ADMN0022E", throwable)) {
                LogUtils.logException(LOGGER, throwable, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.badCredentials", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (this.isMessageInException("ADMC0016E", throwable) || this.isMessageInException("ADMC0018E", throwable)) {
                LogUtils.logException(LOGGER, throwable, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            if (this.isMessageInException("ADMC0053E", throwable) || this.isMessageInException("ADMC0018E", throwable)) {
                LogUtils.logException(LOGGER, throwable, Level.FINE);
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noSecureConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                return false;
            }
            LogUtils.logException(LOGGER, throwable, Level.FINE);
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("dmgrConnection.noConnection", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            return false;
        }
        return false;
    }

    private void doSOAP(Properties properties, String string, String string2, String string3, String string4) {
        properties.setProperty("type", "SOAP");
        properties.setProperty("host", string);
        properties.setProperty("port", string2);
        if (string3 != "" && string4 != "") {
            properties.setProperty("securityEnabled", "true");
            properties.setProperty("username", string3);
            properties.setProperty("password", string4);
        }
        this.doSSLConfig(string, string2, string3, string4);
    }

    private void doSSLConfig(String string, String string2, String string3, String string4) {
        Properties properties = new Properties();
        this.setupSSLProperties(properties);
        String[] stringArray = new String[]{"CellDefaultTrustStore", "ClientDefaultTrustStore", "-autoAcceptBootstrapSigner", "-host", string, "-port", string2, "-user", string3, "-password", string4, "-conntype", "SOAP"};
        JSSEHelper jSSEHelper = JSSEHelper.getInstance();
        jSSEHelper.reinitializeClientDefaultSSLProperties();
        jSSEHelper.setSSLPropertiesOnThread(properties);
        RetrieveSigners.mainForInProcess(stringArray);
    }

    private void setupSSLProperties(Properties properties) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        try {
            this.keyStoreTmpFile = File.createTempFile(S_KEY_STORE_FILE_PREFIX, ".p12");
            this.trustStoreTmpFile = File.createTempFile(S_TRUST_STORE_FILE_PREFIX, ".p12");
            string = this.keyStoreTmpFile.getAbsolutePath();
            string2 = this.keyStoreTmpFile.getName();
            string3 = S_DMGR_CONNECTION_PSSWD;
            string4 = this.trustStoreTmpFile.getAbsolutePath();
            string5 = S_DMGR_CONNECTION_PSSWD;
            this.trustStoreTmpFile.delete();
            this.keyStoreTmpFile.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setupSSLProperties", "Error writing temp files for dmgr connection");
            LogUtils.logException(LOGGER, fileNotFoundException, Level.FINE);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "setupSSLProperties", "Error writing temp files for dmgr connection");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
        }
        properties.put("com.ibm.ssl.defaultAlias", "DefaultSSLSettings");
        properties.put("com.ibm.ssl.performURLHostNameVerification", "false");
        properties.put("com.ibm.ssl.validationEnabled", "false");
        properties.put("com.ibm.ssl.alias", string2);
        properties.put("com.ibm.ssl.protocol", "SSL_TLS");
        properties.put("com.ibm.ssl.clientAuthentication", "false");
        properties.put("com.ibm.ssl.clientAuthenticationSupported", "false");
        properties.put("com.ibm.ssl.trustManager", "IbmX509");
        properties.put("com.ibm.ssl.keyManager", "IbmX509");
        properties.put("com.ibm.ssl.contextProvider", "IBMJSSE2");
        properties.put("com.ibm.ssl.enableSignerExchangePrompt", "false");
        properties.put("com.ibm.ssl.keyStoreClientAlias", "default");
        properties.put("com.ibm.ssl.keyStoreName", "ClientDefaultKeyStore");
        properties.put("com.ibm.ssl.keyStore", string);
        properties.put("com.ibm.ssl.keyStorePassword", string3);
        properties.put("com.ibm.ssl.keyStoreType", "PKCS12");
        properties.put("com.ibm.ssl.keyStoreProvider", "IBMJCE");
        properties.put("com.ibm.ssl.keyStoreFileBased", "true");
        properties.put("com.ibm.ssl.trustStoreName", "ClientDefaultTrustStore");
        properties.put("com.ibm.ssl.trustStore", string4);
        properties.put("com.ibm.ssl.trustStorePassword", string5);
        properties.put("com.ibm.ssl.trustStoreType", "PKCS12");
        properties.put("com.ibm.ssl.trustStoreProvider", "IBMJCE");
        properties.put("com.ibm.ssl.trustStoreFileBased", "true");
    }

    protected ObjectName getMBeanByType(String string, String string2) throws Exception {
        if (this.adminClient == null) {
            return null;
        }
        ObjectName objectName = null;
        try {
            String string3 = "WebSphere:*,process=" + string2 + ",type=" + string;
            ObjectName objectName2 = new ObjectName(string3);
            Set set = this.adminClient.queryNames(objectName2, null);
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                objectName = (ObjectName)iterator.next();
            }
        }
        catch (Exception exception) {
            LogUtils.logException(LOGGER, exception, Level.FINE);
            throw exception;
        }
        return objectName;
    }

    private boolean setTrace() {
        String string = null;
        string = this.trace ? "com.ibm.ws.management.*=all=enabled:com.ibm.websphere.management.*=all=enabled:com.ibm.ws.ssl.*=all=enabled:SSL=all=enabled:com.ibm.ws.security.*=all=enabled:SASRas=all=enabled" : "";
        if (this.logfile == null) {
            this.logfile = this.getDefaultTraceFile();
        }
        boolean bl = true;
        if (!ManagerAdmin.isLogFileWriteable(this.logfile)) {
            bl = false;
        }
        if (bl) {
            ManagerAdmin.configureClientTrace(string, "named file", this.logfile, this.replacelog, "basic", false);
        }
        return true;
    }

    protected String getDefaultTraceFile() {
        String string = System.getProperty("user.install.root");
        if (string == null || string.length() <= 0) {
            string = System.getProperty("was.install.root");
        }
        string = string + File.separator + "logs";
        string = string + File.separator + "trace.out";
        return string;
    }

    private boolean isMessageInException(String string, Throwable throwable) {
        if (throwable == null || throwable.getMessage() == null) {
            return false;
        }
        if (throwable.getMessage().indexOf(string) >= 0) {
            return true;
        }
        return this.isMessageInException(string, throwable.getCause());
    }

    private void redirectSystemOut() {
        FileOutputStream fileOutputStream = null;
        try {
            this.tmpFile = File.createTempFile(S_DMGR_CONNECTION_TMP_FILE_PREFIX, S_DMGR_CONNECTION_TMP_FILE_SUFFIX);
            fileOutputStream = new FileOutputStream(this.tmpFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "redirectSystemOut", "Error writing temp file for dmgr connection");
            LogUtils.logException(LOGGER, fileNotFoundException, Level.FINE);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "redirectSystemOut", "Error writing temp file for dmgr connection");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        System.setOut(printStream);
        System.setErr(printStream);
    }

    private void restoreSystemOut() {
        System.setOut(m_SystemOut);
        System.setErr(m_SystemErr);
        if (this.tmpFile != null) {
            this.logFileContents(this.tmpFile);
            this.tmpFile.delete();
        }
    }

    private void removeKeyAndTrustTempFiles() {
        if (this.keyStoreTmpFile != null && this.keyStoreTmpFile.exists()) {
            this.keyStoreTmpFile.delete();
        }
        if (this.trustStoreTmpFile != null && this.trustStoreTmpFile.exists()) {
            this.trustStoreTmpFile.delete();
        }
    }

    private void logFileContents(File file) {
        FileReader fileReader = null;
        try {
            int n;
            fileReader = new FileReader(file);
            char[] cArray = new char[1024];
            while ((n = fileReader.read(cArray)) != -1) {
                String string = null;
                for (int i = 0; i < cArray.length; ++i) {
                    string = string + Character.toString(cArray[i]);
                }
                if (string == null) continue;
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", "Error reading temp file from dmgr connection");
            LogUtils.logException(LOGGER, fileNotFoundException, Level.FINE);
        }
        catch (IOException iOException) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "logFileContents", "Error reading temp file from dmgr connection");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
        }
    }

    private boolean addJarsToRunTime() {
        LOGGER.entering(DmgrConnectionValidator.class.getName(), "addJarsToRunTime");
        String string = System.getProperty(S_WAS_HOME);
        File file = new File(string);
        if (string == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "addJarsToRunTime", "Could not located WAS_HOME when trying to add jars.");
            return false;
        }
        try {
            int n;
            String string2 = file.getAbsolutePath() + File.separator + S_LIB;
            String string3 = file.getAbsolutePath() + File.separator + S_PLUGINS;
            String[] stringArray = new File(string3).list(new WSProfileFilenameFilter(ARR_DEPENDENT_JARS_PLUGINS, new String[]{S_JAR_EXT}));
            String[] stringArray2 = FileUtils.getLatestJarFiles(ARR_DEPENDENT_JARS_PLUGINS, stringArray);
            for (n = 0; n < ARR_DEPENDENT_JARS_LIB.length; ++n) {
                ClassPathModifier.addFileToClassPath(string2 + File.separator + ARR_DEPENDENT_JARS_LIB[n]);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "addJarsToRunTime", "Added jar: " + string3 + File.separator + ARR_DEPENDENT_JARS_LIB[n]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                ClassPathModifier.addFileToClassPath(string3 + File.separator + stringArray2[n]);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "addJarsToRunTime", "Added jar: " + string3 + File.separator + stringArray2[n]);
            }
        }
        catch (IOException iOException) {
            LogUtils.logException(LOGGER, iOException, Level.FINE);
            return false;
        }
        LOGGER.exiting(DmgrConnectionValidator.class.getName(), "addJarsToRunTime");
        return true;
    }
}

