/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.ijc.IJC;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.defaulters.GenericDefaulter;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.WebServerDefinitionComboValidator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GenericValidator
implements IJC {
    protected String sErrorMessage;
    protected boolean bDoIRun;
    protected boolean bValidationResult;
    protected String sValidatorArgKey;
    protected String sValidatorArgValue;
    protected static String[] sMaskableArgsList;
    protected static final String S_EMPTY = " ";
    protected static final String S_PASSWD_PARAMETER = "winservicePassword";
    protected static final String S_PASSWD_HIDE = "**********";
    private static final Logger LOGGER;
    private static final String S_CLASS_NAME;

    public boolean execute() {
        LOGGER.entering(GenericValidator.class.getName(), "execute");
        try {
            if (this.doIRun()) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", "Executing validator:" + this.getClass().getName());
                this.sValidatorArgKey = this.getValidatorArgKey();
                if (!this.isValidatorArgKeyValidToUse(this.sValidatorArgKey)) {
                    this.bValidationResult = false;
                    this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("argkey.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                    return this.bValidationResult;
                }
                this.sValidatorArgValue = this.getValidatorArgValue();
                if (!this.isValidatorArgValueValidToUse(this.sValidatorArgValue)) {
                    this.bValidationResult = false;
                    this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                    return this.bValidationResult;
                }
                LOGGER.logp(Level.FINE, S_CLASS_NAME, "execute", "Running validation for parameter:" + this.sValidatorArgKey + " with value:" + WASUtilities.hideArgValueIfNecessary(this.sValidatorArgKey, this.sValidatorArgValue, GenericValidator.getMaskableArgs()));
                this.bValidationResult = this.runValidator();
                LOGGER.exiting(GenericValidator.class.getName(), "execute");
                return this.bValidationResult;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "execute", this.getClass().getName() + " did not run");
            LOGGER.exiting(GenericValidator.class.getName(), "execute");
            return true;
        }
        catch (Exception exception) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "An exception occurred while validating");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Exception text:\n" + exception.getMessage());
            LogUtils.logException(LOGGER, exception);
            this.sErrorMessage = exception.getMessage();
            return false;
        }
    }

    public boolean doIRun() {
        LOGGER.entering(GenericValidator.class.getName(), "doIRun");
        this.bDoIRun = true;
        LOGGER.exiting(GenericValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    public abstract boolean runValidator() throws Exception;

    public String getErrorOutput() {
        LOGGER.entering(GenericDefaulter.class.getName(), "getErrorOutput");
        if (this.sErrorMessage != null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "getErrorOutput", "Returning error message:" + this.sErrorMessage);
        }
        LOGGER.exiting(GenericDefaulter.class.getName(), "getErrorOutput");
        return "validationErrorMessage=" + this.sErrorMessage;
    }

    public String getOutput() {
        LOGGER.entering(GenericDefaulter.class.getName(), "getOutput");
        if (this.bDoIRun) {
            LOGGER.exiting(GenericDefaulter.class.getName(), "getOutput");
            if (this.bValidationResult) {
                return "validationValue=" + this.bValidationResult;
            }
            return "validationValue=" + this.bValidationResult + "\n" + "validationErrorMessage=" + this.sErrorMessage;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "getOutput", "The validator was skipped, returning true");
        LOGGER.exiting(GenericDefaulter.class.getName(), "getOutput");
        return "validationValue=true";
    }

    public boolean isValidatorArgKeyValidToUse(String string) {
        boolean bl = !this.isStringEmpty(string);
        return bl;
    }

    public boolean isValidatorArgValueValidToUse(String string) {
        boolean bl = !this.isStringEmpty(string);
        return bl;
    }

    public String getValidatorArgKey() {
        return System.getProperty("validatorArgKey");
    }

    public String getValidatorArgValue() {
        if (this.sValidatorArgKey != null) {
            return System.getProperty(this.sValidatorArgKey);
        }
        return System.getProperty(this.getValidatorArgKey());
    }

    public void setValidatorArgKey(String string) {
        this.sValidatorArgKey = string;
    }

    public void setValidatorArgValue(String string) {
        this.sValidatorArgValue = string;
    }

    public int find(String string, String[] stringArray) {
        LOGGER.entering(GenericValidator.class.getName(), "find");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "find");
            return i;
        }
        LOGGER.exiting(GenericValidator.class.getName(), "find");
        return -1;
    }

    private boolean isStringEmpty(String string) {
        return string == null || string.equals("");
    }

    public static String[] getMaskableArgs() {
        LOGGER.entering(GenericValidator.class.getName(), "getMaskableArgs");
        String string = S_EMPTY;
        if (sMaskableArgsList == null) {
            try {
                string = new String(new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            catch (IOException iOException) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "getMaskableArgs", "No Maskable Action Arguments found in wasprofile.properties");
            }
            if (string.indexOf(S_PASSWD_PARAMETER) == -1) {
                string = "winservicePassword;" + string;
            }
            sMaskableArgsList = string.split(";");
        }
        LOGGER.exiting(GenericValidator.class.getName(), "getMaskableArgs");
        return sMaskableArgsList;
    }

    static {
        LOGGER = LoggerFactory.createLogger(GenericValidator.class);
        S_CLASS_NAME = GenericValidator.class.getName();
    }
}

