/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostNameValidator
extends GenericValidator {
    private static final Logger LOGGER = LoggerFactory.createLogger(HostNameValidator.class);
    private static final String S_CLASS_NAME = HostNameValidator.class.getName();
    private final String S_HOST_NAME_INVALID = "hostname.invalid";
    private final String S_IPv4_REGEX = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
    private final String S_IPv6_REGEX = "(^(:{2}((([0-9A-Fa-f]{1,4})?)|(([0-9A-Fa-f]{1,4}:){1,5}[0-9A-Fa-f]{1,4})))$)|(^(([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})$|^(([0-9A-Fa-f]{1,4}:){5}:((([0-9A-Fa-f]{1,4}:)[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){4}:((([0-9A-Fa-f]{1,4}:){1,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){3}:((([0-9A-Fa-f]{1,4}:){1,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){2}:((([0-9A-Fa-f]{1,4}:){1,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:):((([0-9A-Fa-f]{1,4}:){1,5}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$)";
    private final String S_IPv4_COMPATIBLE_IPv6_REGEX = "^([0]*[0]*[0]*[0]*:){1,7}((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]))$";
    private final String S_IPv4_MAPPED_IPv6_REGEX = "^([0]*[0]*[0]*[0]*:){1,6}([fF][fF][fF][fF]:){1}((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]))$";
    private final String S_HOST_NAME_REGEX = "^([a-zA-Z0-9]([a-zA-Z0-9\\-]*)\\.?)$";
    private final String S_DNS_HOST_NAME_REGEX = "^((?>[a-zA-Z0-9]\\.?)|(?>[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]\\.?)|(?>[a-zA-Z0-9]{0,62}[a-zA-Z0-9]\\.?))+$";
    private final String S_LOCAL_DOMAIN_REGEX = "^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+localdomain";
    private final String[] S_REGEX = new String[]{"^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$", "(^(:{2}((([0-9A-Fa-f]{1,4})?)|(([0-9A-Fa-f]{1,4}:){1,5}[0-9A-Fa-f]{1,4})))$)|(^(([0-9A-Fa-f]{1,4}:){7}[0-9A-Fa-f]{1,4})$|^(([0-9A-Fa-f]{1,4}:){5}:((([0-9A-Fa-f]{1,4}:)[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){4}:((([0-9A-Fa-f]{1,4}:){1,2}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){3}:((([0-9A-Fa-f]{1,4}:){1,3}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:){2}:((([0-9A-Fa-f]{1,4}:){1,4}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$|^(([0-9A-Fa-f]{1,4}:):((([0-9A-Fa-f]{1,4}:){1,5}[0-9A-Fa-f]{1,4})|(([0-9A-Fa-f]{1,4})?)))$)", "^([0]*[0]*[0]*[0]*:){1,7}((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]))$", "^([0]*[0]*[0]*[0]*:){1,6}([fF][fF][fF][fF]:){1}((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]))$", "^([a-zA-Z0-9]([a-zA-Z0-9\\-]*)\\.?)$", "^((?>[a-zA-Z0-9]\\.?)|(?>[a-zA-Z0-9][a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9]\\.?)|(?>[a-zA-Z0-9]{0,62}[a-zA-Z0-9]\\.?))+$", "^([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+localdomain"};

    public boolean runValidator() {
        LOGGER.entering(HostNameValidator.class.getName(), "runValidator");
        Pattern[] patternArray = new Pattern[this.S_REGEX.length];
        for (int i = 0; i < patternArray.length; ++i) {
            patternArray[i] = Pattern.compile(this.S_REGEX[i]);
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "Comparing with regular expression pattern:" + this.S_REGEX[i]);
            Matcher matcher = patternArray[i].matcher(this.sValidatorArgValue);
            if (!matcher.matches()) continue;
            LOGGER.logp(Level.FINE, S_CLASS_NAME, "runValidator", "Pattern match found");
            LOGGER.exiting(HostNameValidator.class.getName(), "runValidator");
            return true;
        }
        this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("hostname.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
        LOGGER.exiting(HostNameValidator.class.getName(), "runValidator");
        return false;
    }
}

