/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortValueInRangeValidator
extends GenericValidator {
    private final String S_PORT_ERROR_OUT_OF_RANGE = "port.error.outOfRange";
    private final String S_PORT_ERROR_NOT_NUMBER = "port.error.notNumber";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortValueInRangeValidator.class);
    private static final String S_CLASS_NAME = PortValueInRangeValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(PortValueInRangeValidator.class.getName(), "runValidator");
        boolean bl = true;
        int n = -1;
        try {
            n = Integer.parseInt(this.sValidatorArgValue);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("port.error.notNumber", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.exiting(PortValueInRangeValidator.class.getName(), "runValidator");
            return bl;
        }
        if (n < 0 || n > 65535) {
            bl = false;
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("port.error.outOfRange", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "runValidator", this.sErrorMessage);
            LOGGER.exiting(PortValueInRangeValidator.class.getName(), "runValidator");
            return bl;
        }
        LOGGER.exiting(PortValueInRangeValidator.class.getName(), "runValidator");
        return bl;
    }
}

