/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.defaulters.GenericDefaulter;
import com.ibm.ws.profile.utils.PortResolutionUtils;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import com.ibm.wsspi.profile.WSProfileException;
import com.ibm.wsspi.profile.WSProfileTemplate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortsCmdLineValidation
extends GenericValidator {
    private static final int I_MODE_INVALID = -1;
    private static final int I_MODE_RECOMMEND_PORTS = 0;
    private static final int I_MODE_STARTING_PORT = 1;
    private static final int I_MODE_PORTS_FILE = 2;
    private static final int I_MODE_DEFAULT_PORTS = 3;
    private static final String S_ARGS_VALIDATION_KEY = "validatePorts";
    private static final String S_ARGS_STARTING_PORT_KEY = "startingPort";
    private static final String S_ARGS_PORTS_FILE_KEY = "portsFile";
    private static final String S_ARGS_DEFAULT_PORTS_KEY = "defaultPorts";
    private static final String S_ARGS_NODE_STARTING_PORT_KEY = "nodeStartingPort";
    private static final String S_ARGS_NODE_PORTS_FILE_KEY = "nodePortsFile";
    private Vector lErrorMessages = new Vector();
    private static final String S_ERROR_MESSAGE_TEMPLATE_PATH_NOT_SET = "portsCmdLineValidation.templatePathNotSet";
    private static final String S_ERROR_MESSAGE_DEFAULT_PORTS_NOT_FREE = "portsCmdLineValidation.defaultPortsNotFree";
    private static final String S_ERROR_MESSAGE_EXCEPTION_VALIDATING_DEFAULT_PORTS = "portsCmdLineValidation.exceptionDuringValidation";
    private static final String S_ERROR_MESSAGE_PORTS_FILE_NOT_SET = "portsCmdLineValidation.portsFileNotSet";
    private static final String S_ERROR_MESSAGE_NODE_PORTS_FILE_NOT_SET = "portsCmdLineValidation.nodePortsFileNotSet";
    private static final String S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE = "portsCmdLineValidation.fileNotFoundOrNotAccessible";
    private static final String S_ERROR_MESSAGE_PORTS_FILE_NOT_VALID = "portsCmdLineValidation.portsFilePortsNotFree";
    private static final String S_ERROR_MESSAGE_EXCEPTION_VALIDATING_PORTS_FILE = "portsCmdLineValidation.exceptionDuringValidation";
    private static final String S_ERROR_MESSAGE_MULTIPLE_OPTIONS_SELECTED = "portsCmdLineValidation.multipleCommandLineOptions";
    private static final String S_ERROR_MESSAGE_MULTIPLE_NODE_OPTIONS_SELECTED = "portsCmdLineValidation.multipleCommandLineOptions.node";
    private static final String S_ERROR_MESSAGE_INVALID_PORTS_FILE = "portsCmdLineValidation.invalidFile";
    private static final Logger LOGGER = LoggerFactory.createLogger(PortsCmdLineValidation.class);
    private static final String S_CLASS_NAME = PortsCmdLineValidation.class.getName();

    public boolean runValidator() {
        LOGGER.entering(PortsCmdLineValidation.class.getName(), "runValidator");
        boolean bl = false;
        switch (this.determineMode()) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = this.validateForModePortsFile();
                break;
            }
            case 3: {
                bl = this.validateForModeDefaultPorts();
                break;
            }
            default: {
                bl = false;
            }
        }
        boolean bl2 = bl;
        if (!bl2) {
            this.lErrorMessages.add(this.sErrorMessage);
        }
        if (this.isCellProfile()) {
            switch (this.determineCellMode()) {
                case 0: 
                case 1: {
                    bl = true;
                    break;
                }
                case 2: {
                    bl = this.validateForModeNodePortsFile();
                    break;
                }
                case 3: {
                    bl = this.validateForModeDefaultPorts();
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                this.lErrorMessages.add(this.sErrorMessage);
            }
            if (!bl2 || !bl) {
                bl = bl2 && bl;
            }
        }
        LOGGER.exiting(PortsCmdLineValidation.class.getName(), "runValidator");
        return bl;
    }

    private int determineCellMode() {
        int n = 0;
        int n2 = 0;
        if (this.isModeNodeStartingPorts()) {
            n = 1;
            ++n2;
        }
        if (this.isModeNodePortsFile()) {
            n = 2;
            ++n2;
        }
        if (this.isModeDefaultPorts()) {
            n = 3;
            ++n2;
        }
        if (n2 > 1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_MULTIPLE_NODE_OPTIONS_SELECTED, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            n = -1;
        }
        return n;
    }

    private boolean isCellProfile() {
        String string = System.getProperty("templatePath");
        if (string == null || string.equals("")) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isCellProfile", "templatePath is not set in the system properties");
            return false;
        }
        try {
            WSProfileTemplate wSProfileTemplate = new WSProfileTemplate(new File(string));
            return wSProfileTemplate.getType().equals("cell.dmgr") || wSProfileTemplate.getType().equals("cell.node");
        }
        catch (WSProfileException wSProfileException) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "isCellProfile", "There were problems creating a template object with the path:" + string);
            LogUtils.logException(LOGGER, wSProfileException, Level.FINE);
            return false;
        }
    }

    public boolean doIRun() {
        this.bDoIRun = this.isArgumentAvailable(S_ARGS_VALIDATION_KEY);
        return this.bDoIRun;
    }

    public boolean isValidatorArgValueValidToUse(String string) {
        return true;
    }

    private boolean validateForModeDefaultPorts() {
        boolean bl = false;
        if (!this.isArgumentAvailable("templatePath")) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_TEMPLATE_PATH_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeDefaultPorts", "Argument templatePath was not set");
            return false;
        }
        try {
            Properties properties = PortResolutionUtils.determineBasePorts(this.getArgumentValue("templatePath"));
            bl = PortResolutionUtils.validatePorts(properties);
            if (this.isCellProfile()) {
                properties = (Properties)PortResolutionUtils.determineBasePorts(this.getArgumentValue("templatePath"), new String[]{"nodeportdef.props"}).get("nodeportdef.props");
                boolean bl2 = bl = bl && PortResolutionUtils.validatePorts(properties);
            }
            if (!bl) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_DEFAULT_PORTS_NOT_FREE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeDefaultPorts", "Some or all of the default ports for template " + this.getArgumentValue("templatePath") + " are currently in use");
            }
        }
        catch (WSProfileException wSProfileException) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("portsCmdLineValidation.exceptionDuringValidation", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LogUtils.logException(LOGGER, wSProfileException, Level.FINE);
            return false;
        }
        return bl;
    }

    private String getArgumentValue(String string) {
        return System.getProperty(string);
    }

    private boolean validateForModePortsFile() {
        if (!this.isArgumentAvailable(S_ARGS_PORTS_FILE_KEY)) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_PORTS_FILE_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModePortsFile", "Argument portsFile was not set");
            return false;
        }
        return this.validatePortsFromFile(this.getArgumentValue(S_ARGS_PORTS_FILE_KEY));
    }

    private boolean validateForModeNodePortsFile() {
        if (!this.isArgumentAvailable(S_ARGS_NODE_PORTS_FILE_KEY)) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_NODE_PORTS_FILE_NOT_SET, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validateForModeNodePortsFile", "Argument nodePortsFile was not set");
            return false;
        }
        return this.validatePortsFromFile(this.getArgumentValue(S_ARGS_NODE_PORTS_FILE_KEY));
    }

    private int determineMode() {
        int n = 0;
        int n2 = 0;
        if (this.isModeStartingPorts()) {
            n = 1;
            ++n2;
        }
        if (this.isModePortsFile()) {
            n = 2;
            ++n2;
        }
        if (this.isModeDefaultPorts()) {
            n = 3;
            ++n2;
        }
        if (n2 > 1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_MULTIPLE_OPTIONS_SELECTED, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            n = -1;
        }
        return n;
    }

    private boolean isModeDefaultPorts() {
        return this.isArgumentAvailable(S_ARGS_DEFAULT_PORTS_KEY);
    }

    private boolean isModePortsFile() {
        return this.isArgumentAvailable(S_ARGS_PORTS_FILE_KEY);
    }

    private boolean isModeNodePortsFile() {
        return this.isArgumentAvailable(S_ARGS_NODE_PORTS_FILE_KEY);
    }

    private boolean isModeStartingPorts() {
        return this.isArgumentAvailable(S_ARGS_STARTING_PORT_KEY);
    }

    private boolean isModeNodeStartingPorts() {
        return this.isArgumentAvailable(S_ARGS_NODE_STARTING_PORT_KEY);
    }

    private boolean isArgumentAvailable(String string) {
        return System.getProperty(string) != null;
    }

    private boolean validatePortsFromFile(String string) {
        boolean bl = true;
        File file = new File(string);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "File " + file + " was not found");
            LogUtils.logException(LOGGER, fileNotFoundException, Level.FINE);
            bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_FILE_NOT_FOUND_OR_NOT_ACCESSIBLE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "File " + file + " was not found or was not accessible");
            LogUtils.logException(LOGGER, iOException, Level.FINE);
            bl = false;
            return bl;
        }
        try {
            bl = PortResolutionUtils.validatePorts(properties);
            if (!bl) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_PORTS_FILE_NOT_VALID, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
                LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "validatePortsFromFile", "The ports file " + string + " contains used or reserved ports");
            }
        }
        catch (WSProfileException wSProfileException) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("portsCmdLineValidation.exceptionDuringValidation", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
            LogUtils.logException(LOGGER, wSProfileException, Level.FINE);
            bl = false;
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString(S_ERROR_MESSAGE_INVALID_PORTS_FILE, "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
            LogUtils.logException(LOGGER, numberFormatException, Level.FINE);
            bl = false;
            return bl;
        }
        return bl;
    }

    public String getErrorOutput() {
        LOGGER.entering(GenericDefaulter.class.getName(), "getErrorOutput");
        String string = "";
        for (int i = 0; i < this.lErrorMessages.size(); ++i) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "getErrorOutput", "Returning error message:" + this.sErrorMessage);
            string = string + "validationErrorMessage=" + (String)this.lErrorMessages.get(i) + "\n";
        }
        LOGGER.exiting(GenericDefaulter.class.getName(), "getErrorOutput");
        return string;
    }
}

