/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import com.ibm.wsspi.profile.WSProfile;
import com.ibm.wsspi.profile.WSProfileException;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Logger;

public class ProfileNameValidator
extends GenericValidator {
    private final String S_NAME_ERROR_IS_NOT_UNIQUE = "name.error.isNotUnique";
    private static final Logger LOGGER = LoggerFactory.createLogger(ProfileNameValidator.class);

    public boolean runValidator() throws WSProfileException {
        LOGGER.entering(ProfileNameValidator.class.getName(), "runValidator");
        File file = WSProfile.getRegistryFile();
        if (!file.exists()) {
            LOGGER.exiting(ProfileNameValidator.class.getName(), "runValidator");
            return true;
        }
        List list = WSProfile.listAllProfileNames(file);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                if (string == null || !string.equalsIgnoreCase(this.sValidatorArgValue.trim())) continue;
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("name.error.isNotUnique", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue.trim());
                LOGGER.exiting(ProfileNameValidator.class.getName(), "runValidator");
                return false;
            }
        }
        LOGGER.exiting(ProfileNameValidator.class.getName(), "runValidator");
        return true;
    }
}

