/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.UserValidator;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class ServiceUserAccountValidator
extends UserValidator {
    private final String S_KEY_NOT_SET_KEY = "key.notset";
    private final String S_SEVICE_ACCOUNT_INVALID_KEY = "service.account.invalid";
    private final String S_USER_VALIDATION_ERROR = "user.validation.error";
    private static final Logger LOGGER = LoggerFactory.createLogger(ServiceUserAccountValidator.class);

    public boolean runValidator() {
        LOGGER.entering(ServiceUserAccountValidator.class.getName(), "runValidator");
        String string = null;
        String string2 = null;
        if (WASUtilities.isWindows()) {
            if ("winserviceUserName".equals(this.sValidatorArgKey)) {
                string = System.getProperty(this.sValidatorArgKey);
                string2 = System.getProperty("winservicePassword");
            } else if ("winservicePassword".equals(this.sValidatorArgKey)) {
                string = System.getProperty("winserviceUserName");
                string2 = System.getProperty(this.sValidatorArgKey);
            }
            if (string == null || string2 == null || string.equals("") || string2.equals("")) {
                this.sErrorMessage = string == null || string.equals("") ? MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "winserviceUserName") : MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "winservicePassword");
                LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
                return false;
            }
        } else if (WASUtilities.isLinux()) {
            if ("serviceUserName".equals(this.sValidatorArgKey) && ((string = System.getProperty(this.sValidatorArgKey)) == null || string.equals(""))) {
                this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "serviceUserName");
                LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
                return false;
            }
        } else {
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        int n = -1;
        if (WASUtilities.isLinux()) {
            n = ServiceUserAccountValidator.validate(string, null);
        } else if (WASUtilities.isWindows()) {
            n = ServiceUserAccountValidator.validate(string, string2);
        }
        if (n == 0 || n == 255) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("service.account.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), string);
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        if (n == -1) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("user.validation.error", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "runValidator");
        return true;
    }

    public boolean doIRun() {
        String string;
        LOGGER.entering(ServiceUserAccountValidator.class.getName(), "doIRun");
        if (WASUtilities.isWindows()) {
            String string2;
            string = System.getProperty("winserviceCheck");
            this.bDoIRun = true;
            if (string == null || !string.equals("true")) {
                this.bDoIRun = false;
            }
            if ((string2 = System.getProperty("winserviceAccountType")) == null || !string2.equals("specifieduser")) {
                if (this.bDoIRun) {
                    // empty if block
                }
                this.bDoIRun = false;
            }
        }
        if (WASUtilities.isLinux()) {
            string = System.getProperty("enableService");
            this.bDoIRun = true;
            if (string == null || !string.equals("true")) {
                this.bDoIRun = false;
            }
        }
        LOGGER.exiting(ServiceUserAccountValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

