/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WASUtilities;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import com.ibm.ws.profile.validators.WebServerDefinitionComboValidator;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebServerProperlyFormedPathValidator
extends GenericValidator {
    public final String sCOLON = ":";
    private final String S_PATH_NOT_WELL_FORMED_KEY = "path.notWellFormed.webServer";
    private final String S_KEY_NOT_SET_KEY = "key.notset";
    public final String[] SA_SERVER_TYPES_REQUIRING_VALIDATION = new String[]{"IHS"};
    private static final Logger LOGGER = LoggerFactory.createLogger(WebServerProperlyFormedPathValidator.class);
    private static final String S_CLASS_NAME = WebServerProperlyFormedPathValidator.class.getName();

    public boolean runValidator() {
        LOGGER.entering(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
        String string = System.getProperty("webServerOS");
        if (string == null || string.equals("")) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("key.notset", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), "webServerOS");
            LOGGER.exiting(WebServerDefinitionComboValidator.class.getName(), "runValidator");
            return false;
        }
        if (string.equals("windows")) {
            int n = this.sValidatorArgValue.indexOf(":");
            if (n == -1 || this.sValidatorArgValue.charAt(n + 1) != '\\' && this.sValidatorArgValue.charAt(n + 1) != '/') {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed.webServer", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
                return false;
            }
            String string2 = this.sValidatorArgValue.substring(0, n + 2);
            File file = new File(string2);
            if (WASUtilities.isWindows() && !file.exists()) {
                this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed.webServer", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
                LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
                return false;
            }
            LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
            return true;
        }
        if (!this.sValidatorArgValue.startsWith("/")) {
            this.sErrorMessage = ResourceBundleUtils.getResourceBundleLocaleString("path.notWellFormed.webServer", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle");
            LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "runValidator");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(WebServerProperlyFormedPathValidator.class.getName(), "doIRun");
        this.bDoIRun = true;
        String string = System.getProperty("webServerCheck");
        String string2 = System.getProperty("webServerType");
        if (string == null || !string.equals("true")) {
            this.bDoIRun = false;
        } else {
            String string3 = this.getValidatorArgKey();
            if (string3 != null && string2 != null && string3.equals("webServerInstallPath")) {
                if (this.inListOfInstallPathRequiringTypes(string2)) {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", string2 + " in list of webServerTypes requiring webServerInstallPath is set.");
                    this.bDoIRun = true;
                } else {
                    LOGGER.logp(Level.INFO, S_CLASS_NAME, "doIRun", string2 + " not in list of webServerTypes requiring webServerInstallPath is set. No validation required.");
                    this.bDoIRun = false;
                }
            }
        }
        LOGGER.exiting(WebServerProperlyFormedPathValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }

    private boolean inListOfInstallPathRequiringTypes(String string) {
        for (int i = 0; i < this.SA_SERVER_TYPES_REQUIRING_VALIDATION.length; ++i) {
            if (!this.SA_SERVER_TYPES_REQUIRING_VALIDATION[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

