/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.validators;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.profile.WSWASProfileConstants;
import com.ibm.ws.profile.utils.ResourceBundleUtils;
import com.ibm.ws.profile.validators.GenericValidator;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class WinServiceAccountTypeValidator
extends GenericValidator {
    private final String S_WINSERVICE_ACCOUNT_TYPE_INVALID_KEY = "winService.accountType.invalid";
    private static final Logger LOGGER = LoggerFactory.createLogger(WinServiceAccountTypeValidator.class);

    public boolean runValidator() {
        LOGGER.entering(WinServiceAccountTypeValidator.class.getName(), "runValidator");
        int n = this.find(this.sValidatorArgValue, WSWASProfileConstants.SA_SERVICE_TYPE_TYPES);
        if (n == -1) {
            this.sErrorMessage = MessageFormat.format(ResourceBundleUtils.getResourceBundleLocaleString("winService.accountType.invalid", "com.ibm.ws.profile.validators.resourcebundle.ValidatorResourceBundle"), this.sValidatorArgValue);
            LOGGER.exiting(WinServiceAccountTypeValidator.class.getName(), "runValidator");
            return false;
        }
        LOGGER.exiting(WinServiceAccountTypeValidator.class.getName(), "runValidator");
        return true;
    }

    public boolean doIRun() {
        LOGGER.entering(WinServiceAccountTypeValidator.class.getName(), "doIRun");
        this.bDoIRun = true;
        String string = System.getProperty("winserviceCheck");
        if (string == null || !string.equals("true")) {
            this.bDoIRun = false;
        }
        LOGGER.exiting(WinServiceAccountTypeValidator.class.getName(), "doIRun");
        return this.bDoIRun;
    }
}

