/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.wsadmin;

import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.wsadmin.WsProfileAdminService;
import com.ibm.ws.scripting.WasxShell;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class WsProfileAdminListener
extends WsProfileAdminService {
    private static WasxShell m_wsadmin;
    private File m_FileTraceLogFileName = null;
    private static FileWriter fwLogger;
    public static final String S_RETURN_CODE_PREFIX = "returnCode=";
    public static final String S_FINISHED_PROCESSING = "Finished Processing";
    public static final String S_INITIALIZATION_MESSAGE = "wsadmin Listener initialized";
    private static final String S_REQUEST_FILE_EXTENSION = ".request";
    private static final String S_RESPONSE_FILE_EXTENSION = ".response";
    private static final String S_FINISHED_FILE_EXTENSION = ".finished";
    private static final String S_DASH = "-";
    private static final String S_EMPTY = "";
    private static final String S_SPACE = " ";
    private static final String S_NEWLINE = "\n";
    private static final String S_TRACEFILE = "tracefile";
    private static final String S_PASSWD_PARAMETER = "winservicePassword";
    private static final String S_PASSWD_HIDE = "****************";
    private File m_fileRequest;
    private File m_fileResponse;
    private File m_fileFinished;
    private FileLocker m_flRequest;
    private FileLocker m_flResponse;
    private String m_sFileEncoding;
    public static final int N_SINGLE_WSADMIN_ERROR_CODE = -1;
    private static final long L_LOCK_RETRY_INTERVAL = 200L;
    private static final String S_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_LOCK_RETRY_COUNT";
    private static final String S_INIT_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_INITIALIZATION_LOCK_RETRY_COUNT";
    private static final int N_DEFAULT_RETRY_COUNT = 30000;
    private static final int N_DEFAULT_INIT_RETRY_COUNT = 1500;
    private static int m_nInitRetryCount;
    private static int m_nRetryCount;

    public static void main(String[] stringArray) {
        WsProfileAdminListener wsProfileAdminListener = new WsProfileAdminListener();
        try {
            if (!wsProfileAdminListener.init(stringArray)) {
                System.err.println("Could not initialize WsProfileAdminListener");
            }
            wsProfileAdminListener.serviceRequests();
        }
        catch (Throwable throwable) {
            System.err.println("The WsProfileAdminListener class is exiting, due to an Exception.");
            System.err.println("An Exception was encountered in the WsProfileAdminListener class" + throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    private boolean init(String[] stringArray) throws IOException {
        if (stringArray.length != 3) {
            System.err.println("Invalid Arguments. The expected arguments are: IPCfilename logname");
            return false;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        this.m_sFileEncoding = stringArray[2];
        this.m_fileRequest = new File(string + S_REQUEST_FILE_EXTENSION);
        this.m_fileResponse = new File(string + S_RESPONSE_FILE_EXTENSION);
        this.m_fileFinished = new File(string + S_FINISHED_FILE_EXTENSION);
        this.cleanupPreviousFinishFile();
        this.initializeLogger(string2);
        this.log("Listener started");
        this.loadTimeouts();
        m_wsadmin = new WasxShell();
        try {
            this.m_flRequest = new FileLocker(string + S_REQUEST_FILE_EXTENSION);
            this.m_flResponse = new FileLocker(string + S_RESPONSE_FILE_EXTENSION);
        }
        catch (IOException iOException) {
            this.log("Could not initialize file lockers. Received IO Exception: " + iOException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(iOException));
            return false;
        }
        return this.sendInitializedMessage();
    }

    public void serviceRequests() throws FileLockerException, IOException {
        boolean bl = false;
        while (!bl) {
            int n;
            long l = 200L;
            int n2 = m_nRetryCount;
            for (n = 0; n < n2; ++n) {
                if (this.isRequestAvailable()) {
                    bl = this.processRequest();
                    break;
                }
                if (n >= n2 - 1) continue;
                try {
                    Thread.sleep(l);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (n != n2) continue;
            this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            bl = true;
        }
        if (bl) {
            this.m_fileRequest.delete();
            try {
                this.m_flRequest.releaseFileLock();
            }
            catch (FileLockerException fileLockerException) {
                // empty catch block
            }
            this.log("Exiting");
            this.closelog();
        }
    }

    private boolean processRequest() throws IOException, FileLockerException {
        String string = WsProfileAdminListener.readFromFile(this.m_fileRequest, this.m_sFileEncoding);
        if (this.isEndOfProcessing(string)) {
            this.log(S_FINISHED_PROCESSING);
            return true;
        }
        String[] stringArray = WsProfileAdminListener.unformatArgs(string);
        String string2 = this.getArgument(stringArray, S_TRACEFILE);
        stringArray = this.stripLogfileFromArgs(stringArray);
        int n = -1;
        try {
            this.openTraceFile(string2);
            n = this.runCommand(stringArray);
            this.closeTraceFile();
        }
        catch (Throwable throwable) {
            this.log("Error encountered running wsadmin: " + throwable.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(throwable));
            this.log("Returning with error code: " + n);
        }
        this.log(S_RETURN_CODE_PREFIX + n);
        try {
            this.m_fileRequest.delete();
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            this.log("Could not release lock for: " + this.m_fileRequest.getAbsolutePath());
            this.log("Received a FileLockerException: " + fileLockerException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fileLockerException));
            throw fileLockerException;
        }
        try {
            this.m_flResponse.acquireFileLock(200L, m_nRetryCount);
            WsProfileAdminListener.writeToFile(this.m_fileResponse, this.m_sFileEncoding, S_RETURN_CODE_PREFIX + Integer.toString(n));
            this.m_flResponse.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            this.log("Received a FileLockerException: " + fileLockerException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fileLockerException));
            throw fileLockerException;
        }
        catch (IOException iOException) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
            this.log("Received an IOException: " + iOException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(iOException));
            throw iOException;
        }
        return false;
    }

    private String[] stripLogfileFromArgs(String[] stringArray) {
        if (this.getArgument(stringArray, S_TRACEFILE) != null) {
            String[] stringArray2 = new String[stringArray.length - 2];
            int n = 0;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-tracefile")) {
                        i += 2;
                    }
                    if (i >= stringArray.length || n >= stringArray2.length) continue;
                    stringArray2[n] = stringArray[i];
                    ++n;
                }
            }
            catch (RuntimeException runtimeException) {
                this.log("Error in removing the tracefile from the args");
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(runtimeException));
                return stringArray;
            }
            return stringArray2;
        }
        return stringArray;
    }

    private boolean isRequestAvailable() throws FileLockerException, IOException {
        if (this.m_fileRequest.exists()) {
            try {
                this.m_flRequest.acquireFileLock(200L, m_nRetryCount);
                return true;
            }
            catch (FileLockerException fileLockerException) {
                this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
                this.log("Received a FileLockerException: " + fileLockerException.getMessage());
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fileLockerException));
                throw fileLockerException;
            }
            catch (IOException iOException) {
                this.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
                this.log("Received an IOException: " + iOException.getMessage());
                this.log(WsProfileAdminListener.getExceptionStackTraceAsString(iOException));
                throw iOException;
            }
        }
        return false;
    }

    private void openTraceFile(String string) throws FileNotFoundException {
        this.log("switching trace logging to file: " + string);
        boolean bl = !this.isTraceFileSwitchNeeded(string);
        this.m_FileTraceLogFileName = new File(string);
        this.redirectSystemOut(bl);
    }

    private int runCommand(String[] stringArray) {
        this.log("**** Running Command");
        String[] stringArray2 = this.hidePasswordArgs(stringArray);
        for (int i = 0; i < stringArray2.length; ++i) {
            this.log("args[" + i + "]=" + stringArray2[i] + S_SPACE);
        }
        this.log("****");
        m_wsadmin.run(stringArray);
        return m_wsadmin.getReturnCode();
    }

    private boolean isEndOfProcessing(String string) {
        return string.indexOf(S_FINISHED_PROCESSING) == 0;
    }

    private boolean isTraceFileSwitchNeeded(String string) {
        File file = new File(string);
        return this.m_FileTraceLogFileName == null && string != null || !this.m_FileTraceLogFileName.equals(file);
    }

    private void initializeLogger(String string) throws IOException {
        try {
            fwLogger = new FileWriter(new File(string), true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    private void log(String string) {
        try {
            fwLogger.write(string + S_NEWLINE);
            fwLogger.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void closelog() {
        try {
            fwLogger.flush();
            fwLogger.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void cleanupPreviousFinishFile() {
        if (this.m_fileFinished != null && this.m_fileFinished.exists()) {
            this.m_fileFinished.delete();
        }
    }

    private void redirectSystemOut(boolean bl) throws FileNotFoundException {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(this.m_FileTraceLogFileName, bl));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("File does not exist (or can not be created) to redirect outpt to: " + this.m_FileTraceLogFileName.toString());
            fileNotFoundException.printStackTrace();
            throw fileNotFoundException;
        }
        System.setOut(printStream);
        System.setErr(printStream);
    }

    private boolean sendInitializedMessage() {
        try {
            this.m_flResponse.acquireFileLock(200L, m_nInitRetryCount);
            WsProfileAdminListener.writeToFile(this.m_fileResponse, this.m_sFileEncoding, S_INITIALIZATION_MESSAGE);
            this.m_flResponse.releaseFileLock();
            this.log("Sent initialization status: [wsadmin Listener initialized]");
            return true;
        }
        catch (FileLockerException fileLockerException) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.  Exiting listener.");
            this.log("Received a FileLockerException: " + fileLockerException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(fileLockerException));
        }
        catch (IOException iOException) {
            this.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered. Exiting Listener.");
            this.log("Received an IOException: " + iOException.getMessage());
            this.log(WsProfileAdminListener.getExceptionStackTraceAsString(iOException));
        }
        return false;
    }

    private void closeTraceFile() {
        System.out.flush();
        System.out.close();
    }

    private String getArgument(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(S_DASH + string) || i >= stringArray.length - 1 || stringArray[i + 1].startsWith(S_DASH)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    private String[] hidePasswordArgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        String[] stringArray3 = this.getMaskableArgs();
        if (stringArray3 == null) {
            return stringArray2;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray3.length; ++j) {
                if (stringArray2[i].indexOf(S_DASH + stringArray3[j]) == -1) continue;
                stringArray2[i] = this.maskArgWithinString(stringArray2[i], stringArray3[j]);
            }
        }
        return stringArray2;
    }

    private String maskArgWithinString(String string, String string2) {
        String string3 = S_EMPTY;
        String string4 = S_EMPTY;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, S_SPACE);
        while (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
            if (bl) {
                string3 = string3 + "**************** ";
                bl = false;
            } else {
                string3 = string3 + string4 + S_SPACE;
            }
            if (!string4.equals(S_DASH + string2)) continue;
            bl = true;
        }
        return string3;
    }

    private String[] getMaskableArgs() {
        String string = S_EMPTY;
        try {
            string = new String(new WSProfileProperties().getProperty("WS_WSPROFILE_MASKABLE_ACTION_ARGUMENTS"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (string.indexOf(S_PASSWD_PARAMETER) == -1) {
            string = "winservicePassword;" + string;
        }
        String[] stringArray = string.split(";");
        return stringArray;
    }

    private void loadTimeouts() {
        m_nInitRetryCount = 30000;
        m_nRetryCount = 30000;
        try {
            WSProfileProperties wSProfileProperties = new WSProfileProperties();
            String string = wSProfileProperties.getProperty(S_RETRY_COUNT_PROPERTY);
            String string2 = wSProfileProperties.getProperty(S_INIT_RETRY_COUNT_PROPERTY);
            if (string != null) {
                try {
                    m_nRetryCount = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                try {
                    m_nInitRetryCount = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("wasprofile.properties file not found. Default timeouts will be used");
        }
        catch (IOException iOException) {
            this.log("IOException accessing wasprofile.properties file. Default timeouts will be used");
        }
        this.log("wsadmin listener retry count = " + m_nRetryCount + ", initialization retry count = " + m_nInitRetryCount);
    }

    static {
        m_nInitRetryCount = 1500;
        m_nRetryCount = 30000;
    }
}

