/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.profile.wsadmin;

import com.ibm.io.file.exception.FileNotFoundException;
import com.ibm.ws.profile.bootstrap.WSProfileProperties;
import com.ibm.ws.profile.utils.FileLocker;
import com.ibm.ws.profile.utils.FileLockerException;
import com.ibm.ws.profile.wsadmin.WsProfileAdminService;
import java.io.File;
import java.io.IOException;

public class WsProfileAdminRequester
extends WsProfileAdminService {
    private File m_fileRequest;
    private File m_fileResponse;
    private FileLocker m_flRequest;
    private FileLocker m_flResponse;
    private static boolean m_fIsListenerAvailable = false;
    private static String m_sCommunicationBaseFilename = "";
    public static final String RETURN_CODE_PREFIX = "returnCode=";
    public static final int N_SINGLE_WSADMIN_ERROR_CODE = -1;
    public static final int[] NA_SUCCESSFUL_WSADMIN_RETURN_CODES = new int[]{0, 101};
    private static final long L_LOCK_RETRY_INTERVAL = 200L;
    private static final String S_REQUEST_FILE_EXTENSION = ".request";
    private static final String S_RESPONSE_FILE_EXTENSION = ".response";
    private static final String S_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_LOCK_RETRY_COUNT";
    private static final String S_SHUTDOWN_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_SHUTDOWN_LOCK_RETRY_COUNT";
    private static final String S_INIT_RETRY_COUNT_PROPERTY = "WS_WSADMIN_LISTENER_INITIALIZATION_LOCK_RETRY_COUNT";
    private static final int N_DEFAULT_RETRY_COUNT = 30000;
    private static final int N_DEFAULT_SHUTDOWN_RETRY_COUNT = 1;
    private static final int N_DEFAULT_INIT_RETRY_COUNT = 1500;
    private static int m_nInitRetryCount = 1500;
    private static int m_nShutdownRetryCount = 1;
    private static int m_nRetryCount = 30000;

    private WsProfileAdminRequester(String string) throws IOException {
        this.m_fileRequest = new File(string + S_REQUEST_FILE_EXTENSION);
        this.m_fileResponse = new File(string + S_RESPONSE_FILE_EXTENSION);
        this.m_flRequest = new FileLocker(string + S_REQUEST_FILE_EXTENSION);
        this.m_flResponse = new FileLocker(string + S_RESPONSE_FILE_EXTENSION);
        if (this.isCommunicationsFileChanged(string)) {
            m_fIsListenerAvailable = false;
            WsProfileAdminRequester.log("Resetting listener available status to: " + m_fIsListenerAvailable);
            this.resetTimeouts();
        }
        m_sCommunicationBaseFilename = string;
    }

    public static int sendWsAdminRequest(String[] stringArray, String string) {
        int n = -1;
        try {
            WsProfileAdminRequester wsProfileAdminRequester = new WsProfileAdminRequester(string);
            n = wsProfileAdminRequester.processRequest(stringArray);
            if (wsProfileAdminRequester.isFatalFailure(n)) {
                wsProfileAdminRequester.stopListener();
            }
        }
        catch (Exception exception) {
            n = -1;
            WsProfileAdminRequester.log("Received Exception: " + exception.getMessage());
            WsProfileAdminRequester.log("Returning with error code=" + n);
            exception.printStackTrace();
        }
        return n;
    }

    private int processRequest(String[] stringArray) throws FileLockerException, IOException {
        int n = -1;
        if (this.isListenerAvailable()) {
            this.sendRequest(stringArray);
            n = this.processResponse();
        }
        WsProfileAdminRequester.log("Returning with returnCode=" + n);
        return n;
    }

    private void sendRequest(String[] stringArray) throws FileLockerException, IOException {
        WsProfileAdminRequester.log("Sending wsadmin request");
        try {
            this.m_flRequest.acquireFileLock(200L, m_nRetryCount);
            String string = WsProfileAdminRequester.formatArgs(stringArray);
            WsProfileAdminRequester.writeToFile(this.m_fileRequest, string);
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " within timeout period. Either file does not exist, or the lock is unavailable.");
            WsProfileAdminRequester.log("Received a FileLockerException: " + fileLockerException.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fileLockerException));
            throw fileLockerException;
        }
        catch (IOException iOException) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileRequest.getAbsolutePath() + " As an IOException was encountered.");
            WsProfileAdminRequester.log("Received an IOException: " + iOException.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(iOException));
            throw iOException;
        }
    }

    private int parseReturnCode(String string) {
        int n = -1;
        try {
            if (string == null || RETURN_CODE_PREFIX.length() > string.length()) {
                n = -1;
                return -1;
            }
            n = Integer.parseInt(string.substring(RETURN_CODE_PREFIX.length()));
        }
        catch (NumberFormatException numberFormatException) {
            WsProfileAdminRequester.log("NumberFormatException: " + numberFormatException.getMessage());
            numberFormatException.printStackTrace();
            n = -1;
        }
        return n;
    }

    private int processResponse() throws FileLockerException, IOException {
        int n = -1;
        long l = 200L;
        int n2 = m_nRetryCount;
        for (int i = 0; i < n2; ++i) {
            if (this.isResponseAvailable()) {
                WsProfileAdminRequester.log("wsadmin response available");
                String string = this.readResponse();
                if (!this.isInitMessageRecieved(string)) {
                    n = this.parseReturnCode(string);
                    WsProfileAdminRequester.log("Return Code = " + n);
                    break;
                }
                WsProfileAdminRequester.log("Recieved an initialization message. Waiting for response to wsadmin request.");
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (n == -1) {
            WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
        }
        WsProfileAdminRequester.log("Returning with returnCode=" + n);
        return n;
    }

    private boolean isCommunicationsFileChanged(String string) {
        return m_sCommunicationBaseFilename == null && string != null || m_sCommunicationBaseFilename != null && !m_sCommunicationBaseFilename.equals(string);
    }

    private boolean isResponseAvailable() throws FileLockerException, IOException {
        if (this.m_fileResponse.exists()) {
            try {
                this.m_flResponse.acquireFileLock(200L, m_nRetryCount);
                return true;
            }
            catch (FileLockerException fileLockerException) {
                WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
                WsProfileAdminRequester.log("Received a FileLockerException: " + fileLockerException.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fileLockerException));
                throw fileLockerException;
            }
            catch (IOException iOException) {
                WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered.");
                WsProfileAdminRequester.log("Received an IOException: " + iOException.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(iOException));
                throw iOException;
            }
        }
        return false;
    }

    private boolean isFatalFailure(int n) {
        boolean bl;
        for (bl = false; bl < NA_SUCCESSFUL_WSADMIN_RETURN_CODES.length; bl += 1) {
            if (n != NA_SUCCESSFUL_WSADMIN_RETURN_CODES[bl]) continue;
            return false;
        }
        bl = new Boolean(System.getProperty("isConfigActionFatal"));
        if (bl) {
            WsProfileAdminRequester.log("Failure detected in fatal config action.");
        } else {
            WsProfileAdminRequester.log("Failure detected in non-fatal config action.");
        }
        return bl;
    }

    private boolean isInitMessageRecieved(String string) {
        return string != null && string.indexOf("wsadmin Listener initialized") != -1;
    }

    private String readResponse() throws FileLockerException, IOException {
        String string = WsProfileAdminRequester.readFromFile(this.m_fileResponse);
        this.m_fileResponse.delete();
        try {
            this.m_flResponse.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            WsProfileAdminRequester.log("Could not release file lock to file: " + this.m_fileResponse.getAbsolutePath());
            WsProfileAdminRequester.log("Received a FileLockerException: " + fileLockerException.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fileLockerException));
            throw fileLockerException;
        }
        return string;
    }

    private void stopListener() {
        WsProfileAdminRequester.log("Signalling wsadmin listener to stop.");
        try {
            this.m_flRequest.acquireFileLock(200L, m_nShutdownRetryCount);
            WsProfileAdminRequester.writeToFile(this.m_fileRequest, "Finished Processing");
            this.m_flRequest.releaseFileLock();
        }
        catch (FileLockerException fileLockerException) {
            try {
                WsProfileAdminRequester.writeToFile(this.m_fileRequest, "Finished Processing");
            }
            catch (IOException iOException) {
                WsProfileAdminRequester.log("Error received stopping wsadmin listener.  The listener will timeout, or can be stopped manually.");
                WsProfileAdminRequester.log("The error message was: " + iOException.getMessage());
                WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(iOException));
            }
        }
        catch (IOException iOException) {
            WsProfileAdminRequester.log("Error received stopping wsadmin listener.  The listener will timeout, or can be stopped manually.");
            WsProfileAdminRequester.log("The error message was: " + iOException.getMessage());
            WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(iOException));
        }
    }

    private boolean isListenerAvailable() {
        if (!m_fIsListenerAvailable) {
            m_fIsListenerAvailable = this.isListenerInitialized();
        }
        WsProfileAdminRequester.log("Is wsadmin listener available? " + m_fIsListenerAvailable);
        return m_fIsListenerAvailable;
    }

    private boolean isListenerInitialized() {
        WsProfileAdminRequester.log("Checking for wsadmin listener initialization");
        boolean bl = false;
        int n = m_nInitRetryCount;
        long l = 200L;
        for (int i = 0; i < n; ++i) {
            if (this.m_fileResponse.exists()) {
                try {
                    this.m_flResponse.acquireFileLock(200L, m_nInitRetryCount);
                    String string = WsProfileAdminRequester.readFromFile(this.m_fileResponse);
                    WsProfileAdminRequester.log("wsadmin listener initalized status: [" + string + "]");
                    if (this.isInitMessageRecieved(string)) {
                        WsProfileAdminRequester.log("wsadmin listener is initialized.");
                        bl = true;
                    } else {
                        WsProfileAdminRequester.log("wsadmin listener is not initialized.");
                        bl = false;
                    }
                    this.m_fileResponse.delete();
                    this.m_flResponse.releaseFileLock();
                }
                catch (FileLockerException fileLockerException) {
                    WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " within timeout period. Either file does not exit, or the lock is unavailable.");
                    WsProfileAdminRequester.log("Received a FileLockerException: " + fileLockerException.getMessage());
                    WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(fileLockerException));
                    bl = false;
                }
                catch (IOException iOException) {
                    WsProfileAdminRequester.log("Could not aquire file lock to file: " + this.m_fileResponse.getAbsolutePath() + " As an IOException was encountered.");
                    WsProfileAdminRequester.log("Received an IOException: " + iOException.getMessage());
                    WsProfileAdminRequester.log(WsProfileAdminRequester.getExceptionStackTraceAsString(iOException));
                    bl = false;
                }
                break;
            }
            if (i >= n - 1) continue;
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void resetTimeouts() {
        WsProfileAdminRequester.log("setting wsadmin requester timeouts");
        m_nInitRetryCount = 30000;
        m_nShutdownRetryCount = 1;
        m_nRetryCount = 30000;
        try {
            WSProfileProperties wSProfileProperties = new WSProfileProperties();
            String string = wSProfileProperties.getProperty(S_RETRY_COUNT_PROPERTY);
            String string2 = wSProfileProperties.getProperty(S_SHUTDOWN_RETRY_COUNT_PROPERTY);
            String string3 = wSProfileProperties.getProperty(S_INIT_RETRY_COUNT_PROPERTY);
            if (string != null) {
                try {
                    m_nRetryCount = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                try {
                    m_nShutdownRetryCount = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string3 != null) {
                try {
                    m_nInitRetryCount = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            WsProfileAdminRequester.log("wasprofile.properties file not found. Default timeouts will be used");
        }
        catch (IOException iOException) {
            WsProfileAdminRequester.log("IOException accessing wasprofile.properties file. Default timeouts will be used");
        }
        WsProfileAdminRequester.log("wsadmin requester retry count = " + m_nRetryCount + ", initialization retry count = " + m_nInitRetryCount + ", shutdown retry count = " + m_nShutdownRetryCount);
    }

    private static void log(String string) {
        System.out.println(string);
    }
}

