/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ws.performance.tuning.EngineParameters;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.rasdiag.AlertConfigHome;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.ImmediateAlertBridge;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlertConfig {
    private String alertKey = null;
    private String nameKey = null;
    private String dPName = null;
    private boolean enabled = false;
    private boolean zos_enabled = true;
    private boolean initialized;
    private HashMap paramMap = null;
    private long iLastCheck;
    private long iTimeBetweenAlerts = 0L;
    private ArrayList iPropChgListeners = new ArrayList(8);
    private static String osName = EngineParameters.getOS();
    private static final String minTimeBetweenAlerts = "minTimeBetweenAlerts";
    private static final String sThisClass = AlertConfig.class.getName();
    private static Logger sAlertConfigLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.properties.ImmediateAlertMessages");
    private static ImmediateAlertBridge immediateAlertBridge = null;

    AlertConfig(String string, boolean bl) {
        if (string == null) {
            sAlertConfigLogger.logp(Level.WARNING, sThisClass, "constructor", "RasDiag.All.NullParm");
            return;
        }
        this.alertKey = string;
        this.enabled = bl;
        this.iLastCheck = 0L;
        this.initialized = false;
        if (sAlertConfigLogger.isLoggable(Level.FINE)) {
            sAlertConfigLogger.logp(Level.FINE, sThisClass, "constructor1", "Alert: " + this.alertKey + " HomeEnabled: " + AlertConfigHome.isEnabled() + " Enabled: " + this.enabled + " zEnabled: " + this.zos_enabled + " TimeBtw: " + this.iTimeBetweenAlerts + " LastCk: " + this.iLastCheck + " Obj: " + this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.iPropChgListeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.iPropChgListeners.remove(propertyChangeListener);
    }

    AlertConfig(RuleData ruleData) {
        this.convertRuleData(ruleData);
        this.iLastCheck = 0L;
    }

    void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        sAlertConfigLogger.logp(Level.FINE, sThisClass, "setEnabled", "Changing enabled boolean from: " + bl2 + " to: " + this.enabled + " for key: " + this.alertKey + " Obj: " + this);
        this.notifyListeners(new PropertyChangeEvent(this, "Enabled", new Boolean(bl2), new Boolean(this.enabled)));
    }

    synchronized void setParamMap(HashMap hashMap) {
        sAlertConfigLogger.logp(Level.FINE, sThisClass, "setParamMap", "Setting paramMap for key: " + this.alertKey);
        this.paramMap = hashMap;
    }

    synchronized void addParam(String string, Double d) {
        sAlertConfigLogger.logp(Level.FINE, sThisClass, "addParam", "Adding parm: " + string + " with val: " + d + " for alert: " + this.alertKey);
        if (!this.initialized) {
            this.getRuleData(this.alertKey);
        }
        if (string.equals(minTimeBetweenAlerts)) {
            this.iTimeBetweenAlerts = d.longValue();
        }
        if (this.paramMap == null) {
            this.getRuleData(this.alertKey);
        }
        if (this.paramMap != null) {
            this.paramMap.put(string, d);
        }
        this.notifyListeners(new PropertyChangeEvent(this, string, null, d));
    }

    synchronized void setParam(String string, Double d) {
        sAlertConfigLogger.logp(Level.FINE, sThisClass, "setParam", "Adding parm: " + string + " with val: " + d + " for alert: " + this.alertKey);
        if (!this.initialized) {
            this.getRuleData(this.alertKey);
        }
        if (string.equals(minTimeBetweenAlerts)) {
            this.iTimeBetweenAlerts = d.longValue();
        }
        if (this.paramMap != null) {
            Double d2 = (Double)this.paramMap.get(string);
            if (d2 == null) {
                throw new IllegalArgumentException("RuleData, param map does not contain " + string);
            }
            this.paramMap.put(string, d);
            this.notifyListeners(new PropertyChangeEvent(this, string, d2, d));
        }
    }

    public synchronized Double getParam(String string) {
        if (!this.initialized) {
            this.getRuleData(this.alertKey);
        }
        sAlertConfigLogger.logp(Level.FINE, sThisClass, "getParam", "Getting parm: " + string + " for alert: " + this.alertKey);
        if (this.paramMap != null) {
            return (Double)this.paramMap.get(string);
        }
        return null;
    }

    public synchronized String[] getParamNames() {
        if (!this.initialized) {
            this.getRuleData(this.alertKey);
        }
        if (this.paramMap != null) {
            try {
                Set set = this.paramMap.keySet();
                String[] stringArray = new String[set.size()];
                stringArray = set.toArray(stringArray);
                return stringArray;
            }
            catch (Exception exception) {
                sAlertConfigLogger.logp(Level.WARNING, sThisClass, "getParamNames", "RasDiag.AlCt.NoParmNames", exception);
                return new String[0];
            }
        }
        return null;
    }

    public String getAlertKey() {
        return this.alertKey;
    }

    public boolean isEnabled() {
        if (sAlertConfigLogger.isLoggable(Level.FINE)) {
            sAlertConfigLogger.logp(Level.FINE, sThisClass, "isEnabled", "Alert: " + this.alertKey + " HomeEnabled: " + AlertConfigHome.isEnabled() + " Enabled: " + this.enabled + " zEnabled: " + this.zos_enabled + " TimeBtw: " + this.iTimeBetweenAlerts + " LastCk: " + this.iLastCheck + " Obj: " + this);
        }
        if (!AlertConfigHome.isEnabled()) {
            return false;
        }
        long l = 0L;
        if (this.iTimeBetweenAlerts > 0L && this.iLastCheck + this.iTimeBetweenAlerts > (l = AlertConfigHome.getApproxTime() / 1000L)) {
            return false;
        }
        boolean bl = this.enabled;
        return bl;
    }

    public boolean isEnabled(boolean bl) {
        if (sAlertConfigLogger.isLoggable(Level.FINE)) {
            sAlertConfigLogger.logp(Level.FINE, sThisClass, "isEnabled w/FrameWork", "Alert: " + this.alertKey + " HomeEnabled: " + AlertConfigHome.isEnabled() + "TimeBtw: " + this.iTimeBetweenAlerts + " LastCk: " + this.iLastCheck);
        }
        if (bl && !AlertConfigHome.isEnabled()) {
            return false;
        }
        long l = 0L;
        if (this.iTimeBetweenAlerts > 0L && this.iLastCheck + this.iTimeBetweenAlerts > (l = AlertConfigHome.getApproxTime() / 1000L)) {
            return false;
        }
        boolean bl2 = this.enabled;
        return bl2;
    }

    void resetClock(long l) {
        if (sAlertConfigLogger.isLoggable(Level.FINE)) {
            sAlertConfigLogger.logp(Level.FINE, sThisClass, "resetClock", "Alert: " + this.alertKey + " OldCloc,k: " + this.iLastCheck + " NewClock: " + l);
        }
        this.iLastCheck = l;
    }

    public String getNameKey() {
        if (!this.initialized) {
            this.getRuleData(this.alertKey);
        }
        return this.nameKey;
    }

    public long getLastCheck() {
        return this.iLastCheck;
    }

    private void getRuleData(String string) {
        RuleData ruleData;
        if (immediateAlertBridge == null) {
            immediateAlertBridge = ImmediateAlertBridge.getInstance();
        }
        if ((ruleData = immediateAlertBridge.loadImmediateAlert(string)) == null) {
            sAlertConfigLogger.logp(Level.WARNING, sThisClass, "getRuleData", "RasDiag.AlCnf.NoRuleData", string);
        } else {
            this.convertRuleData(ruleData);
        }
    }

    private void convertRuleData(RuleData ruleData) {
        this.alertKey = ruleData.getRuleID();
        this.nameKey = ruleData.getNameKey();
        if (!this.enabled) {
            this.enabled = ruleData.getEnabled();
        }
        this.dPName = ruleData.getComponentKey();
        this.paramMap = ruleData.getParamMap();
        this.zos_enabled = ruleData.getZos_enabled();
        Double d = (Double)this.paramMap.get(minTimeBetweenAlerts);
        if (d != null) {
            this.iTimeBetweenAlerts = d.longValue();
        }
        this.initialized = true;
        if (sAlertConfigLogger.isLoggable(Level.FINE)) {
            sAlertConfigLogger.logp(Level.FINE, sThisClass, "convertRuleData", "Alert: " + this.alertKey + " HomeEnabled: " + AlertConfigHome.isEnabled() + " Enabled: " + this.enabled + " zEnabled: " + this.zos_enabled + " dPName: " + this.dPName + " Obj: " + this);
        }
    }

    private void notifyListeners(PropertyChangeEvent propertyChangeEvent) {
        Iterator iterator = this.iPropChgListeners.iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator.next();
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }
}

