/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.rasdiag.AlertConfig;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.timeutils.QuickApproxTimeA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AlertConfigHome {
    private static final String sThisClass = AlertConfigHome.class.getName();
    private static Logger sAlertConfigHomeLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.properties.ImmediateAlertMessages");
    private static AlertConfigHome sAlertConfigHome = new AlertConfigHome();
    private static HashMap sAlertConfigs = new HashMap();
    private static boolean engineEnabled = false;
    private static int minTimeBetweenAlerts = 0;
    private static QuickApproxTimeA qTimer = new QuickApproxTimeA();

    private AlertConfigHome() {
        sAlertConfigHomeLogger.logp(Level.FINE, sThisClass, "AlertConfigHome", "Constructing");
    }

    public static AlertConfigHome getInstance() {
        return sAlertConfigHome;
    }

    public AlertConfig getAlertConfig(String string) {
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "getAlertConfig", "RasDiag.All.NullParm");
            return null;
        }
        sAlertConfigHomeLogger.logp(Level.FINE, sThisClass, "getAlertConfig", "get for AlertKey: " + string);
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            if (engineEnabled) {
                sAlertConfigHomeLogger.logp(Level.INFO, sThisClass, "getAlertConfig", "RasDiag.ACfH.NoAlertCfg", string);
            }
            alertConfig = new AlertConfig(string, false);
        }
        return alertConfig;
    }

    static void setEnabled(boolean bl) {
        engineEnabled = bl;
    }

    public static boolean isEnabled() {
        return engineEnabled;
    }

    public boolean isImmediateAlert(String string) {
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "isImmediateAlert", "RasDiag.All.NullParm");
            return false;
        }
        return sAlertConfigs.containsKey(string);
    }

    public boolean isAlertEnabled(String string) {
        if (!engineEnabled) {
            return false;
        }
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "isAlertEnabled", "RasDiag.All.NullParm");
            return false;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "isAlertEnabled", "RasDiag.ACfH.NoAlertCfg", string);
            return false;
        }
        return alertConfig.isEnabled();
    }

    public boolean isAlertEnabled(String string, boolean bl) {
        if (!engineEnabled && bl) {
            return false;
        }
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "isAlertEnabled", "RasDiag.All.NullParm");
            return false;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "isAlertEnabled", "RasDiag.ACfH.NoAlertCfg", string);
            return false;
        }
        return alertConfig.isEnabled(bl);
    }

    void setAlertEnabled(String string, boolean bl) {
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "setAlertEnabled", "RasDiag.All.NullParm");
            return;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.FINE, sThisClass, "setAlertEnabled", "Creating AlertConfig object via AlertConfigHome.setAlertEnabled finding nothing in the hash for id: " + string + " w/enablement: " + bl);
            alertConfig = new AlertConfig(string, bl);
            sAlertConfigs.put(string, alertConfig);
        } else {
            alertConfig.setEnabled(bl);
        }
    }

    void setAlertAttribute(String string, String string2, Double d) {
        if (string == null || string2 == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "setAlertAttribute", "RasDiag.All.NullParm");
            return;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "setAlertAttribute", "RasDiag.ACfH.NoAlertCfg", string);
        } else {
            alertConfig.addParam(string2, d);
        }
    }

    AlertConfig setAlertFromRule(RuleData ruleData) {
        AlertConfig alertConfig = new AlertConfig(ruleData);
        sAlertConfigs.put(alertConfig.getAlertKey(), alertConfig);
        return alertConfig;
    }

    public Double getAlertAttribute(String string, String string2) {
        if (string == null || string2 == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "getAlertAttribute", "RasDiag.All.NullParm");
            return null;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "getAlertAttribute", "RasDiag.ACfH.NoAlertCfg", string);
            return null;
        }
        return alertConfig.getParam(string2);
    }

    public ArrayList getAlertParsedMBeanAttributes(String string) {
        return new ArrayList();
    }

    public String[] getImmediateAlertIDs() {
        try {
            Set set = sAlertConfigs.keySet();
            String[] stringArray = new String[set.size()];
            stringArray = set.toArray(stringArray);
            return stringArray;
        }
        catch (Exception exception) {
            System.out.println("[RuleData] getParamNames() caught exception " + exception.toString());
            exception.printStackTrace();
            return new String[0];
        }
    }

    public String getImmediateAlertNameLookup(String string) {
        if (string == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "getAlertAttribute", "RasDiag.All.NullParm");
            return null;
        }
        AlertConfig alertConfig = (AlertConfig)sAlertConfigs.get(string);
        if (alertConfig == null) {
            sAlertConfigHomeLogger.logp(Level.WARNING, sThisClass, "getImmediateAlertNameLookup", "RasDiag.ACfH.NoAlertCfg", string);
            return null;
        }
        return alertConfig.getNameKey();
    }

    public boolean getImmediateAlertRuleApplicability(String string) {
        return true;
    }

    public static long getApproxTime() {
        return qTimer.getApproxTime();
    }
}

