/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ws.rasdiag.AlertAgent;
import com.ibm.ws.rasdiag.AlertConfig;
import com.ibm.ws.rasdiag.AlertConfigHome;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.exception.AlertAgentException;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class AlertController {
    private static final String sThisClass = AlertController.class.getName();
    private static Logger sAlertControllerLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.properties.ImmediateAlertMessages");

    public static DiagnosticEvent checkPoint(Logger logger, AlertAgent alertAgent, AlertConfig alertConfig) {
        String string = alertConfig.getAlertKey();
        if (sAlertControllerLogger.isLoggable(Level.FINE)) {
            sAlertControllerLogger.entering(sThisClass, "checkPoint", "AlertKey: " + string + " HomeEnabled: " + AlertConfigHome.isEnabled() + " AlertEnabled: " + alertConfig.isEnabled());
        }
        DiagnosticEvent diagnosticEvent = null;
        if (AlertConfigHome.isEnabled() && alertConfig.isEnabled()) {
            alertConfig.resetClock(AlertConfigHome.getApproxTime() / 1000L);
            sAlertControllerLogger.logp(Level.FINE, sThisClass, "checkPoint", "AlertKey: " + string);
            try {
                diagnosticEvent = alertAgent.evaluateTriggerConditions(alertConfig);
            }
            catch (AlertAgentException alertAgentException) {
                sAlertControllerLogger.logp(Level.SEVERE, sThisClass, "checkPoint", "RasDiag.ACt.AppExcep", alertAgentException);
            }
            catch (Throwable throwable) {
                sAlertControllerLogger.logp(Level.SEVERE, sThisClass, "checkPoint", "RasDiag.ACt.eTrExcep", throwable);
            }
            if (diagnosticEvent != null) {
                AlertController.sendAlert(diagnosticEvent, logger);
            }
        }
        sAlertControllerLogger.exiting(sThisClass, "checkPoint");
        return diagnosticEvent;
    }

    private static void sendAlert(DiagnosticEvent diagnosticEvent, Logger logger) {
        sAlertControllerLogger.logp(Level.FINE, sThisClass, "sendAlert", "Sending an alert" + diagnosticEvent);
        if (diagnosticEvent == null || logger == null) {
            sAlertControllerLogger.logp(Level.WARNING, sThisClass, "sendAlert", "RasDiag.All.NullParm");
            return;
        }
        CommonBaseEvent commonBaseEvent = (CommonBaseEvent)diagnosticEvent.getContent();
        if (commonBaseEvent == null) {
            sAlertControllerLogger.logp(Level.WARNING, sThisClass, "sendAlert", "RasDiag.AlCt.noContent");
            return;
        }
        logger.log((LogRecord)new CommonBaseEventLogRecord(commonBaseEvent));
    }
}

