/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class CommonBaseEventDiagnosticEventImpl
implements DiagnosticEvent {
    static final long serialVersionUID = -639639525219673682L;
    private CommonBaseEvent iCbe = null;
    private MsgDataElement iMde = null;
    private ExtendedDataElement iEdeEventType = null;
    private static final String sThisClass = CommonBaseEventDiagnosticEventImpl.class.getName();
    private static Logger sCBEDEILogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private String iCellNm = null;
    private String iNodeNm = null;
    private String iServerNm = null;

    public CommonBaseEventDiagnosticEventImpl(CommonBaseEvent commonBaseEvent) {
        this.iCbe = commonBaseEvent;
        if (commonBaseEvent == null) {
            sCBEDEILogger.logp(Level.WARNING, sThisClass, "constructor", "RasDiag.CBEDEI.nullCBE");
        }
        if (sCBEDEILogger.isLoggable(Level.FINEST) && this.iCbe != null) {
            CommonBaseEventLogRecord commonBaseEventLogRecord = new CommonBaseEventLogRecord(this.iCbe);
            String string = commonBaseEventLogRecord.externalizeCanonicalXmlString();
            sCBEDEILogger.logp(Level.FINEST, sThisClass, "completeCBE", string);
        }
    }

    public Object getContent() {
        return this.iCbe;
    }

    public short getContentType() {
        return 1;
    }

    public String getEventType() {
        if (this.iEdeEventType == null) {
            this.iEdeEventType = DiagnosticEventHelper.getExtendedDataElement(this.iCbe, "com.ibm.websphere.Diagnostic.EventType.");
        }
        if (this.iEdeEventType == null) {
            sCBEDEILogger.logp(Level.WARNING, sThisClass, "getEventType", "RasDiag.CBEDEI.NoEDE");
            return null;
        }
        return this.iEdeEventType.getName().substring("com.ibm.websphere.Diagnostic.EventType.".length());
    }

    public String getDiagnosticProviderId() {
        return CBEHelper.getExtendedDataElementString(this.iCbe, "DiagnosticProvider");
    }

    public String getSourceClass() {
        return CBEHelper.getExtendedDataElementString(this.iCbe, CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_SOURCE_CLASS_NAME);
    }

    public String getSourceMethod() {
        return CBEHelper.getExtendedDataElementString(this.iCbe, CommonBaseEventLogRecord.EXTENDED_DATA_ELEMENT_NAME_SOURCE_METHOD_NAME);
    }

    public SortedMap getDiagnosticData() {
        if (this.iEdeEventType == null) {
            this.iEdeEventType = DiagnosticEventHelper.getExtendedDataElement(this.iCbe, "com.ibm.websphere.Diagnostic.EventType.");
        }
        if (this.iEdeEventType == null) {
            sCBEDEILogger.logp(Level.WARNING, sThisClass, "getDiagnosticData", "RasDiag.CBEDEI.NoEDE");
            return null;
        }
        String[] stringArray = this.iEdeEventType.getValuesAsStringArray();
        return DiagnosticEventHelper.inflateMap(stringArray);
    }

    public String getResourceBundleName() {
        if (CBEHelper.requiresNoLocalization(this.iCbe)) {
            sCBEDEILogger.logp(Level.FINER, sThisClass, "getResourceBundleName", "No Localization required for this CBE");
            return null;
        }
        if (this.iMde == null) {
            this.iMde = this.getMde();
        }
        return this.iMde == null ? null : this.iMde.getMsgCatalog();
    }

    public String getMessageKey() {
        if (this.iMde == null) {
            this.iMde = this.getMde();
        }
        return this.iMde == null ? null : this.iMde.getMsgCatalogId();
    }

    public Object[] getMessageParameters() {
        return CBEHelper.getParameters(this.iCbe);
    }

    public int getLevel() {
        return this.iCbe.getSeverity();
    }

    public String getCellName() {
        if (this.iCellNm == null) {
            this.parseInstanceId();
        }
        return this.iCellNm;
    }

    public String getNodeName() {
        if (this.iNodeNm == null) {
            this.parseInstanceId();
        }
        return this.iNodeNm;
    }

    public String getServerName() {
        if (this.iServerNm == null) {
            this.parseInstanceId();
        }
        return this.iServerNm;
    }

    public String getServerDetail() {
        return CBEHelper.getExtendedDataElementString(this.iCbe, "com.ibm.websphere.Diagnostic.serverDetail");
    }

    private MsgDataElement getMde() {
        MsgDataElement msgDataElement = this.iCbe.getMsgDataElement();
        if (msgDataElement == null) {
            sCBEDEILogger.logp(Level.FINE, sThisClass, "getMde", "RasDiag.CBEDEI.nullMde");
            return null;
        }
        return msgDataElement;
    }

    private void parseInstanceId() {
        String string = this.iCbe.getSourceComponentId().getInstanceId();
        if (string == null) {
            return;
        }
        int n = string.indexOf(92);
        if (n < 1) {
            sCBEDEILogger.logp(Level.WARNING, sThisClass, "parseInstanceId", "RasDiag.CBEDEI.InvalidInst", string);
            return;
        }
        this.iCellNm = string.substring(0, n);
        if ((n = (string = string.substring(n + 1)).indexOf(92)) < 1) {
            sCBEDEILogger.logp(Level.WARNING, sThisClass, "parseInstanceId", "RasDiag.CBEDEI.InvalidInst", string);
            return;
        }
        this.iNodeNm = string.substring(0, n);
        this.iServerNm = string.substring(n + 1);
    }

    public String toString() {
        return this.iCbe.toString();
    }
}

