/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ejs.ras.RasMessageImpl2;
import com.ibm.websphere.ras.RasMessage;
import com.ibm.ws.logging.LogRecordRasMessageAdapter;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class DiagnosticEventHelper {
    public static final String sRsrceBundle = "com.ibm.ws.rasdiag.resources.RasDiagMessages";
    public static final String sRBundleLocalization = "com.ibm.ws.rasdiag.resources.RasDiagLocalization";
    public static final String sRBundleSample = "com.ibm.ws.rasdiag.resources.RasDiagSample";
    private static final String HASHMAPDELIMITER = "--hmd--";
    private static String serverDetail = null;
    private static final String sThisClass = DiagnosticEventHelper.class.getName();
    private static Logger sDiagnosticEventHelperLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");

    public static Level convertLevel(int n) {
        if (n == 10) {
            return Level.INFO;
        }
        if (n == 30) {
            return Level.WARNING;
        }
        if (n != 50) {
            sDiagnosticEventHelperLogger.logp(Level.WARNING, sThisClass, "convertLevel", "RasDiag.All.InvalidParm", new Integer(n));
        }
        return Level.SEVERE;
    }

    public static String[] getStringArray(HashMap hashMap) {
        if (hashMap == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(64);
        DiagnosticEventHelper.addToStringArray(hashMap, arrayList, "");
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static void addToStringArray(HashMap hashMap, ArrayList arrayList, String string) {
        sDiagnosticEventHelperLogger.entering(sThisClass, "addToStringArray", "Entering w/prefix: " + string);
        ArrayList<HashMap> arrayList2 = new ArrayList<HashMap>(16);
        ArrayList<String> arrayList3 = new ArrayList<String>(16);
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = hashMap.get(string2);
            if (v instanceof HashMap) {
                arrayList2.add((HashMap)v);
                arrayList3.add(string + string2 + HASHMAPDELIMITER);
                continue;
            }
            if (v instanceof DiagnosticTypedValue) {
                DiagnosticTypedValue diagnosticTypedValue = (DiagnosticTypedValue)v;
                arrayList.add(string + string2 + "=" + DiagnosticTypedValue.sTypeNames[diagnosticTypedValue.tvType] + diagnosticTypedValue.tvMsgKey + ":" + diagnosticTypedValue.tvString);
                continue;
            }
            sDiagnosticEventHelperLogger.logp(Level.WARNING, sThisClass, "addToStringArray", "RasDiag.All.InvMapType", new Object[]{v.getClass(), string2, v});
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            DiagnosticEventHelper.addToStringArray((HashMap)arrayList2.get(i), arrayList, (String)arrayList3.get(i));
        }
        sDiagnosticEventHelperLogger.exiting(sThisClass, "addToStringArray", "Exiting w/prefix: " + string);
    }

    public static String getServerDetail() {
        if (serverDetail == null) {
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper == null) {
                return null;
            }
            serverDetail = platformHelper.isZOS() ? (platformHelper.isServantJvm() ? "Servant: " + platformHelper.getServantToken() : (platformHelper.isControlJvm() ? "Controller" : "z/OS Specific")) : "";
        }
        return serverDetail;
    }

    public static SortedMap inflateMap(String[] stringArray) {
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n <= 0 || n >= stringArray[i].length()) continue;
            String[] stringArray2 = stringArray[i].substring(0, n).split(HASHMAPDELIMITER);
            TreeMap treeMap2 = treeMap;
            DiagnosticTypedValue diagnosticTypedValue = DiagnosticTypedValue.fromString(stringArray[i].substring(n + 1));
            for (int j = 1; j < stringArray2.length; ++j) {
                if (treeMap2.containsKey(stringArray2[j - 1])) {
                    treeMap2 = (TreeMap)treeMap2.get(stringArray2[j - 1]);
                    continue;
                }
                treeMap2.put(stringArray2[j - 1], new TreeMap());
                treeMap2 = (TreeMap)treeMap2.get(stringArray2[j - 1]);
            }
            if (diagnosticTypedValue == null) continue;
            treeMap2.put(stringArray2[stringArray2.length - 1], diagnosticTypedValue);
        }
        return treeMap;
    }

    public static Logger getLogger(final String string, final String string2) {
        Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Logger.getLogger(string, string2);
            }
        });
        return logger;
    }

    public static String getDPidFromRasMessage(RasMessage rasMessage) {
        if (rasMessage instanceof RasMessageImpl2) {
            return ((RasMessageImpl2)rasMessage).getDiagnosticProviderId();
        }
        if (rasMessage instanceof LogRecordRasMessageAdapter) {
            LogRecordRasMessageAdapter logRecordRasMessageAdapter = (LogRecordRasMessageAdapter)rasMessage;
            sDiagnosticEventHelperLogger.logp(Level.FINE, sThisClass, "getDPidFromRasMessage", "Got RasMessage which IS an LRRMA");
            if (logRecordRasMessageAdapter == null) {
                return null;
            }
            LogRecord logRecord = logRecordRasMessageAdapter.getLogRecord();
            sDiagnosticEventHelperLogger.logp(Level.FINE, sThisClass, "getDPidFromRasMessage", "Got LogRecord from lrrma");
            if (logRecord == null) {
                return null;
            }
            if (logRecord instanceof CommonBaseEventLogRecord) {
                sDiagnosticEventHelperLogger.logp(Level.FINE, sThisClass, "getDPidFromRasMessage", "LogRecord was a CBELR");
                CommonBaseEventLogRecord commonBaseEventLogRecord = (CommonBaseEventLogRecord)logRecord;
                if (commonBaseEventLogRecord == null) {
                    return null;
                }
                CommonBaseEvent commonBaseEvent = commonBaseEventLogRecord.getCommonBaseEvent();
                if (commonBaseEvent == null) {
                    return null;
                }
                sDiagnosticEventHelperLogger.logp(Level.FINE, sThisClass, "getDPidFromRasMessage", "Got CBE from CBELR");
                return CBEHelper.getExtendedDataElementString(commonBaseEvent, "DiagnosticProvider");
            }
            return null;
        }
        return null;
    }

    public static ExtendedDataElement getExtendedDataElement(CommonBaseEvent commonBaseEvent, String string) {
        if (commonBaseEvent == null || string == null) {
            String string2 = string == null ? "name" : "iCBE";
            sDiagnosticEventHelperLogger.logp(Level.WARNING, sThisClass, "getExtendedDataElement", "RasDiag.All.NullParm", "NullVar: " + string2);
            return null;
        }
        EList eList = commonBaseEvent.getExtendedDataElements();
        for (int i = 0; i < eList.size(); ++i) {
            ExtendedDataElement extendedDataElement = (ExtendedDataElement)eList.get(i);
            if (!extendedDataElement.getName().startsWith(string)) continue;
            return extendedDataElement;
        }
        return null;
    }
}

