/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DiagnosticProviderHelperSaxHandler
extends DefaultHandler
implements ContentHandler {
    private static final String sThisClass = DiagnosticProviderHelperSaxHandler.class.getName();
    private static Logger sDPHSaxHandlerLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private boolean getData = false;
    private boolean moreData = false;
    private Stack opStack = new Stack();
    private DiagnosticProviderInfo dpInfo;
    private String lastData;
    private ArrayList configAttrib;
    private ArrayList stateAttrib;
    private ArrayList selfDiagTest;
    private ArrayList testAttrib;
    private String id;
    private String descriptionKey;
    private AttributeInfo attributeInfo = null;
    private static final String sDtdName = "com/ibm/wsspi/rasdiag/DiagnosticProvider.dtd";
    private static final String[] elTypes = new String[]{"id", "descriptionKey", "attribute", "state", "config", "test", "selfDiagnostic", "resourceBundleName", "registered"};

    public DiagnosticProviderHelperSaxHandler(DiagnosticProviderInfo diagnosticProviderInfo) {
        this.dpInfo = diagnosticProviderInfo;
        this.configAttrib = new ArrayList(32);
        this.stateAttrib = new ArrayList(32);
        this.selfDiagTest = new ArrayList(32);
        this.testAttrib = new ArrayList(32);
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.getData) {
            this.lastData = new String(cArray, n, n2);
            this.getData = false;
            this.moreData = true;
        } else if (this.moreData) {
            this.lastData = this.lastData + String.copyValueOf(cArray, n, n2);
        }
    }

    public void endDocument() {
        if (this.moreData) {
            this.moreData = false;
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4;
        if (this.moreData) {
            this.moreData = false;
        }
        if (!(string4 = (String)this.opStack.pop()).equalsIgnoreCase(string3)) {
            sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "endElement", "RasDiag.Xml1.ParseErr", "End el not compatible with started els, end el: " + string3 + " Top stack el: " + string4);
            return;
        }
        int n = this.getElType(string3);
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: {
                if (((String)this.opStack.peek()).equalsIgnoreCase("attribute")) {
                    this.attributeInfo.id = this.lastData;
                    break;
                }
                this.id = this.lastData;
                break;
            }
            case 1: {
                if (((String)this.opStack.peek()).equalsIgnoreCase("attribute")) {
                    this.attributeInfo.descriptionKey = this.lastData;
                    break;
                }
                this.descriptionKey = this.lastData;
                break;
            }
            case 2: {
                if (this.attributeInfo.id.equalsIgnoreCase("noId")) {
                    sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "endElement", "RasDiag.Xml1.ParseErr", "No id val in an attribute, incomplete attribute");
                    return;
                }
                String string5 = (String)this.opStack.peek();
                if (string5.equalsIgnoreCase("state")) {
                    this.stateAttrib.add(this.attributeInfo);
                    break;
                }
                if (string5.equalsIgnoreCase("config")) {
                    this.configAttrib.add(this.attributeInfo);
                    break;
                }
                if (string5.equalsIgnoreCase("test")) {
                    this.testAttrib.add(this.attributeInfo);
                    break;
                }
                sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "endElement", "RasDiag.Xml1.ParseErr", "Invalid AttributeContainer: " + string5);
                break;
            }
            case 3: {
                this.dpInfo.stateInfo.attributeInfo = new AttributeInfo[this.stateAttrib.size()];
                this.dpInfo.stateInfo.attributeInfo = this.stateAttrib.toArray(this.dpInfo.stateInfo.attributeInfo);
                this.stateAttrib.clear();
                break;
            }
            case 4: {
                this.dpInfo.configInfo.attributeInfo = new AttributeInfo[this.configAttrib.size()];
                this.dpInfo.configInfo.attributeInfo = this.configAttrib.toArray(this.dpInfo.configInfo.attributeInfo);
                this.configAttrib.clear();
                break;
            }
            case 5: {
                if (this.id.equalsIgnoreCase("noId")) {
                    sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "endElement", "RasDiag.Xml1.ParseErr", "No id val in a test, incomplete test");
                    return;
                }
                AttributeInfo[] attributeInfoArray = new AttributeInfo[this.testAttrib.size()];
                attributeInfoArray = this.testAttrib.toArray(attributeInfoArray);
                this.selfDiagTest.add(new TestInfo(this.id, this.descriptionKey, attributeInfoArray));
                this.testAttrib.clear();
                break;
            }
            case 6: {
                this.dpInfo.selfDiagnosticInfo.testInfo = new TestInfo[this.selfDiagTest.size()];
                this.dpInfo.selfDiagnosticInfo.testInfo = this.selfDiagTest.toArray(this.dpInfo.selfDiagnosticInfo.testInfo);
                this.selfDiagTest.clear();
                break;
            }
            case 7: {
                this.dpInfo.resourceBundleName = this.lastData;
                break;
            }
            case 8: {
                this.attributeInfo.registered = !this.lastData.equalsIgnoreCase("false");
            }
        }
    }

    public void startDocument() {
        if (this.moreData) {
            this.moreData = false;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) {
        if (this.moreData) {
            this.moreData = false;
        }
        this.opStack.push(string3);
        int n = this.getElType(string3);
        if (n == -1) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 7: 
            case 8: {
                this.getData = true;
                break;
            }
            case 2: {
                this.attributeInfo = new AttributeInfo();
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.id = "noId";
                this.descriptionKey = "";
                break;
            }
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        if (string != null && string.equalsIgnoreCase("RasDiag") && string2.endsWith("DiagnosticProvider.dtd")) {
            try {
                InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(sDtdName);
                return new InputSource(inputStream);
            }
            catch (Exception exception) {
                sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "resolveEntity", "RasDiag.DPHS.XMLDTD1", exception);
                return null;
            }
        }
        return null;
    }

    public void warning(SAXParseException sAXParseException) {
        sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "warning", "RasDiag.XmlHandler.XmlError", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) {
        sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "warning", "RasDiag.XmlHandler.XmlError", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        sDPHSaxHandlerLogger.logp(Level.WARNING, sThisClass, "warning", "RasDiag.XmlHandler.XmlError", sAXParseException);
    }

    private int getElType(String string) {
        for (int i = 0; i < elTypes.length; ++i) {
            if (!string.equalsIgnoreCase(elTypes[i])) continue;
            return i;
        }
        return -1;
    }
}

