/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistration;
import com.ibm.ws.rasdiag.DiagnosticService;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.rasdiag.DiagnosticConfigHome;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DiagnosticProviderRegistry {
    private static final String sThisClass = DiagnosticProviderRegistry.class.getName();
    private static Logger sDiagnosticProviderRegistryLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private static DiagnosticProviderRegistry sDiagnosticProviderRegistry = new DiagnosticProviderRegistry();
    private static Hashtable sDiagnosticProviders = new Hashtable();
    private static Hashtable sDiagProvidersReverse = new Hashtable();
    private static DiagnosticService sDiagnosticService = null;
    private static AdminService sAdminSvc = AdminServiceFactory.getAdminService();
    private static final String jmxQuery1 = "WebSphere:process=";
    private static final String jmxQuery3 = ",diagnosticProvider=true,*";
    private static final boolean isCR = PlatformHelperFactory.getPlatformHelper().isControlJvm();

    private DiagnosticProviderRegistry() {
        sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "constructor", "Constructing");
    }

    public static DiagnosticProviderRegistry getInstance() {
        return sDiagnosticProviderRegistry;
    }

    public static void register(String string, ObjectName objectName) {
        if (string == null || objectName == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "register", "RasDiag.All.NullParm");
            return;
        }
        sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "register", "Registering DPName: " + string + " DPid: " + objectName);
        if (sDiagnosticProviders.containsKey(string)) {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "register", "Did not register dup for DPName: " + string + " DPID: " + objectName + " HashSz: " + sDiagnosticProviders.size());
            return;
        }
        Iterator iterator = DiagnosticProviderHelper.resolveObjNm(sAdminSvc, objectName);
        if (iterator == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "register", "Failed to resolve object to register DPID: " + objectName);
            return;
        }
        ObjectName objectName2 = (ObjectName)iterator.next();
        sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "register", "Adding to HashMaps");
        sDiagnosticProviders.put(string, objectName2);
        sDiagProvidersReverse.put(objectName2.toString(), string);
        sDiagnosticProviderRegistryLogger.logp(Level.FINER, sThisClass, "register", "Reg'd DPNm" + string + " DPID: " + objectName + " HashSz: " + sDiagnosticProviders.size() + "ReverseSz: " + sDiagProvidersReverse.size());
        if (isCR) {
            return;
        }
        if (sDiagnosticService == null) {
            sDiagnosticService = DiagnosticService.getInstance();
        }
        if (sDiagnosticService == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "register", "RasDiag.DPReg.RegFail", "Registration of DPName: " + string + " withPid:" + objectName + "Failed w/no ref to DiagnosticService");
        } else {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "register", "Sending Registration Notification");
            sDiagnosticService.sendRegistrationNotification(new DiagnosticProviderRegistration(string, objectName, true));
        }
    }

    public static void deregister(String string, ObjectName objectName, boolean bl) {
        if (string == null && objectName == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "deregister", "RasDiag.All.NullParm");
            return;
        }
        sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "deRegister", "deRegistering DPName: " + string + " DPId: " + objectName);
        if (string == null) {
            string = (String)sDiagProvidersReverse.get(objectName.toString());
        }
        if (string == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "deregister", "null DPName DPHashSz: " + sDiagnosticProviders.size() + " ReverseHashSz: " + sDiagProvidersReverse.size());
        } else {
            if (bl) {
                DiagnosticConfigHome.releaseDiagnosticConfig(string);
            }
            if (!sDiagnosticProviders.containsKey(string)) {
                if (objectName == null) {
                    objectName = (ObjectName)sDiagnosticProviders.get(string);
                }
                sDiagnosticProviders.remove(string);
            }
            if (objectName != null) {
                sDiagProvidersReverse.remove(objectName.toString());
            }
            sDiagnosticProviderRegistryLogger.logp(Level.FINER, sThisClass, "deregister", "After Rmv of: " + string + " Sz: " + sDiagnosticProviders.size() + " Rvrs Sz: " + sDiagProvidersReverse.size());
        }
        if (isCR) {
            return;
        }
        if (sDiagnosticService == null) {
            sDiagnosticService = DiagnosticService.getInstance();
        }
        if (sDiagnosticService == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "deregister", "RasDiag.DPReg.RegFail", "DeRegistration of DPName: " + string + " withPid:" + objectName + "Failed w/no ref to DiagnosticService");
        } else {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "deregister", "Sending DeRegistration Notification");
            sDiagnosticService.sendRegistrationNotification(new DiagnosticProviderRegistration(string, objectName, false));
        }
    }

    public String getDiagnosticProviderNameById(String string) {
        if (string == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "getDiagnosticProviderNameById", "RasDiag.All.NullParm");
            return null;
        }
        String string2 = (String)sDiagProvidersReverse.get(string);
        if (string2 == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "getDiagnosticProviderNameById", "RasDiag.DS.DPidNotRegd", string);
        }
        return string2;
    }

    public String[] queryDPNames(String string) {
        String[] stringArray;
        if (string == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "queryDPNames", "RasDiag.All.NullParm");
            return null;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>(16);
        Pattern pattern = Pattern.compile(string);
        Enumeration enumeration = sDiagnosticProviders.keys();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            if (!pattern.matcher((CharSequence)stringArray).matches()) continue;
            arrayList.add(stringArray);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public ObjectName[] queryDPids(String string) {
        ObjectName[] objectNameArray;
        if (string == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "queryDPids", "RasDiag.All.NullParm");
            return null;
        }
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(16);
        Pattern pattern = Pattern.compile(string);
        Enumeration enumeration = sDiagnosticProviders.keys();
        while (enumeration.hasMoreElements()) {
            objectNameArray = (ObjectName[])enumeration.nextElement();
            if (!pattern.matcher((CharSequence)objectNameArray).matches()) continue;
            arrayList.add((ObjectName)sDiagnosticProviders.get(objectNameArray));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        objectNameArray = new ObjectName[arrayList.size()];
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray[i] = (ObjectName)arrayList.get(i);
        }
        return objectNameArray;
    }

    public void refreshRegistrations() {
        sDiagnosticProviders.clear();
        sDiagProvidersReverse.clear();
        Iterator iterator = this.getSet(jmxQuery1 + sAdminSvc.getProcessName() + jmxQuery3);
        while (iterator.hasNext()) {
            final ObjectName objectName = (ObjectName)iterator.next();
            String string = null;
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                    Object returnValue;

                    public Object run() throws Exception {
                        try {
                            this.returnValue = DiagnosticProviderHelper.getJmxAttrib(sAdminSvc, objectName, "diagnosticProviderName");
                            return this.returnValue;
                        }
                        catch (Exception exception) {
                            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
                            return null;
                        }
                    }
                };
                string = (String)SecurityContext.runAsSystem(privilegedExceptionAction);
            }
            catch (Exception exception) {
                sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.All.JmxInfo", new Object[]{objectName, "", "", ""});
                sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.DS.JMXCallIssue", exception);
            }
            sDiagnosticProviders.put(string, objectName);
            sDiagProvidersReverse.put(objectName.toString(), string);
        }
    }

    private Iterator getSet(String string) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "getSet", "RasDiag.DS.ObjNmJmxIssue", malformedObjectNameException);
            return null;
        }
        return DiagnosticProviderHelper.resolveObjNm(sAdminSvc, objectName);
    }

    public String[] listRegistrations() {
        Object object;
        String string;
        int n = sDiagnosticProviders.size() + sDiagProvidersReverse.size() + 2;
        String[] stringArray = new String[n];
        int n2 = 0;
        stringArray[n2++] = "This is the DPName sorted Hashtable contents";
        Enumeration enumeration = sDiagnosticProviders.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (ObjectName)sDiagnosticProviders.get(string);
            stringArray[n2++] = "   Key: " + string + " DPid: " + ((ObjectName)object).toString();
        }
        stringArray[n2++] = "This is the DPId sorted Hashtable contents";
        enumeration = sDiagProvidersReverse.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (String)sDiagProvidersReverse.get(string);
            stringArray[n2++] = "   Key: " + (String)object + " aDPid: " + string;
        }
        return stringArray;
    }

    public ObjectName getObjNameFromDPid(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        sDiagnosticProviderRegistryLogger.entering(sThisClass, "getObjNameFromDPid", "DPid: " + string);
        if (sDiagProvidersReverse == null) {
            try {
                return new ObjectName(string);
            }
            catch (Exception exception) {
                sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "registerProviders:DPid", "RasDiag.DS.RegistryIssue", exception);
            }
        }
        if ((string2 = (String)sDiagProvidersReverse.get(string)) == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.WARNING, sThisClass, "getObjNameFromDPid", "RasDiag.DS.DPidNotRegd", "DPName lookup failed");
            return null;
        }
        sDiagnosticProviderRegistryLogger.exiting(sThisClass, "getObjNameFromDPid", "ObjNm for DPNm: " + string2);
        return (ObjectName)sDiagnosticProviders.get(string2);
    }

    public ObjectName getDPid4DPName(String string) {
        ObjectName objectName = (ObjectName)sDiagnosticProviders.get(string);
        if (objectName == null) {
            sDiagnosticProviderRegistryLogger.logp(Level.FINE, sThisClass, "getDPid4DPName", "No DPID associated with DPName: " + string);
        }
        return objectName;
    }
}

