/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistration;
import com.ibm.ws.rasdiag.DiagnosticProviderRegistry;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.rasdiag.DiagnosticConfigHome;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;

public class DiagnosticService
extends RuntimeCollaborator {
    private static final String sThisClass = DiagnosticService.class.getName();
    private static Logger sDiagnosticServiceLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private DiagnosticProviderRegistry iDiagnosticProviderRegistry = DiagnosticProviderRegistry.getInstance();
    private static DiagnosticConfigHome sDiagnosticConfigHome = DiagnosticConfigHome.getInstance();
    private static AdminService sAdminSvc = AdminServiceFactory.getAdminService();
    private static DiagnosticService sDiagnosticService = null;
    private static final int NumStrings = 2;
    private static Locale dfltLocale = null;
    private static ResourceBundle dfltBundle = null;
    private static String[] dfltStrings = new String[2];
    private static int ntfySeqNum = 0;
    public static final int REGISTRY_TYPE_CONFIG = 1;
    public static final int REGISTRY_TYPE_STATE = 2;
    public static final int REGISTRY_TYPE_DIAG = 3;
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private static final boolean isCR = PlatformHelperFactory.getPlatformHelper().isControlJvm();

    DiagnosticService() {
        sDiagnosticServiceLogger.logp(Level.FINER, sThisClass, "PrivateConstructor", "DiagnosticService constructing");
        sDiagnosticService = this;
    }

    public String getDiagnosticProviderNameById(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDiagnosticProviderNameById", "RasDiag.All.NullParm");
            return null;
        }
        return this.iDiagnosticProviderRegistry.getDiagnosticProviderNameById(string);
    }

    public String[] queryDPNames(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "queryDPNames", "RasDiag.All.NullParm");
            return null;
        }
        return this.iDiagnosticProviderRegistry.queryDPNames(string);
    }

    public ObjectName[] queryDPids(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "queryDPids", "RasDiag.All.NullParm");
            return null;
        }
        return this.iDiagnosticProviderRegistry.queryDPids(string);
    }

    public String[] getRegisteredConfig(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredConfig", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getRegistryInternal(objectName, 1);
    }

    public String[] getRegisteredConfigById(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredConfigById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getRegistryInternal(objectName, 1);
    }

    public String[] getRegisteredState(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredState", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getRegistryInternal(objectName, 2);
    }

    public String[] getRegisteredStateById(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredStateById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getRegistryInternal(objectName, 2);
    }

    public String[] getRegisteredSelfDiagnostics(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredSelfDiagnostics", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getSDRegistryInternal(objectName, 3);
    }

    public String[] getRegisteredSelfDiagnosticsById(String string) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getRegisteredSelfDiagnosticsById", "RasDiag.All.NullParm");
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getSDRegistryInternal(objectName, 2);
    }

    private String[] getRegistryInternal(ObjectName objectName, int n) {
        AttributeInfo[] attributeInfoArray;
        DiagnosticProviderInfo diagnosticProviderInfo = this.getDPInfo(objectName);
        if (diagnosticProviderInfo == null) {
            return null;
        }
        AttributeInfo[] attributeInfoArray2 = attributeInfoArray = n == 1 ? diagnosticProviderInfo.configInfo.attributeInfo : diagnosticProviderInfo.stateInfo.attributeInfo;
        if (attributeInfoArray == null) {
            String string = n == 1 ? "Configuration" : "State";
            sDiagnosticServiceLogger.logp(Level.INFO, sThisClass, "getRegistryInternal", "RasDiag.DSrv.NoCfgData", string + " ObjNm: " + objectName);
            return null;
        }
        String[] stringArray = new String[attributeInfoArray.length];
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            stringArray[i] = attributeInfoArray[i].id;
        }
        return stringArray;
    }

    private String[] getSDRegistryInternal(ObjectName objectName, int n) {
        DiagnosticProviderInfo diagnosticProviderInfo = this.getDPInfo(objectName);
        if (diagnosticProviderInfo == null) {
            return null;
        }
        TestInfo[] testInfoArray = diagnosticProviderInfo.selfDiagnosticInfo.testInfo;
        if (testInfoArray == null) {
            sDiagnosticServiceLogger.logp(Level.INFO, sThisClass, "getSDRegistryInternal", "RasDiag.DSrv.NoCfgData", "SelfDiag: ObjNm: " + objectName);
            return null;
        }
        String[] stringArray = new String[testInfoArray.length];
        for (int i = 0; i < testInfoArray.length; ++i) {
            stringArray[i] = testInfoArray[i].id;
        }
        return stringArray;
    }

    private DiagnosticProviderInfo getDPInfo(final ObjectName objectName) {
        if (objectName == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.All.NullParm");
            return null;
        }
        sDiagnosticServiceLogger.entering(sThisClass, "getDPInfo", objectName);
        DiagnosticProviderInfo diagnosticProviderInfo = null;
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, objectName, "getRegisteredDiagnostics", new Object[0], new String[0]);
                        return this.returnValue;
                    }
                    catch (Exception exception) {
                        sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
                        return null;
                    }
                }
            };
            diagnosticProviderInfo = (DiagnosticProviderInfo)SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.All.JmxInfo", new Object[]{objectName, "", "", ""});
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.DS.JMXCallIssue", exception);
        }
        if (diagnosticProviderInfo == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPInfo", "RasDiag.All.JmxInfo", new Object[]{"Null Diagnostic Provider Info back thru JMX layer", "", "", ""});
            sDiagnosticServiceLogger.exiting(sThisClass, "getDPInfo", "dpinfo is null");
        } else {
            sDiagnosticServiceLogger.exiting(sThisClass, "getDPInfo w/val: " + diagnosticProviderInfo.toString());
        }
        return diagnosticProviderInfo;
    }

    public DiagnosticEvent[] configDump(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "configDump", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getDPDumpInternal(objectName, string2, bl, "configDump");
    }

    public DiagnosticEvent[] configDumpById(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "configDumpById", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getDPDumpInternal(objectName, string2, bl, "configDump");
    }

    public String[] configDumpFormatted(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "configDumpFormatted", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getDPDumpInternal(objectName, string2, bl, "configDump");
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    public String[] configDumpFormattedById(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "configDumpFromattedById", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getDPDumpInternal(objectName, string2, bl, "configDump");
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    public DiagnosticEvent[] stateDump(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "stateDump", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getDPDumpInternal(objectName, string2, bl, "stateDump");
    }

    public DiagnosticEvent[] stateDumpById(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "stateDumpById", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getDPDumpInternal(objectName, string2, bl, "stateDump");
    }

    public String[] stateDumpFormatted(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "stateDumpFormatted", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getDPDumpInternal(objectName, string2, bl, "stateDump");
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    public String[] stateDumpFormattedById(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "stateDumpFormattedById", "RasDiag.All.NullParm", "Attr: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getDPDumpInternal(objectName, string2, bl, "stateDump");
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    public DiagnosticEvent[] selfDiagnostic(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "selfDiagnostic", "RasDiag.All.NullParm", "Test: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.getSelfDiagnosticInternal(objectName, string2, bl);
    }

    public DiagnosticEvent[] selfDiagnosticById(String string, String string2, boolean bl) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticById", "RasDiag.All.NullParm", "Test: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.getSelfDiagnosticInternal(objectName, string2, bl);
    }

    public String[] selfDiagnosticFormatted(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticFormatted", "RasDiag.All.NullParm", "Test: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getSelfDiagnosticInternal(objectName, string2, bl);
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    public String[] selfDiagnosticFormattedById(String string, String string2, boolean bl, Locale locale) {
        if (string == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "selfDiagnosticFormattedById", "RasDiag.All.NullParm", "Test: " + string2 + " Regd: " + bl);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        DiagnosticEvent[] diagnosticEventArray = this.getSelfDiagnosticInternal(objectName, string2, bl);
        return this.formatDiagnosticEvent(objectName, diagnosticEventArray, locale);
    }

    private DiagnosticEvent[] getDPDumpInternal(final ObjectName objectName, final String string, final boolean bl, final String string2) {
        if (sDiagnosticServiceLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceLogger.entering(sThisClass, "getDPDumpInternal", new Object[]{string2, objectName, string, new Boolean(bl)});
        }
        DiagnosticEvent[] diagnosticEventArray = null;
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, objectName, string2, new Object[]{string, new Boolean(bl)}, new String[]{"java.lang.String", "boolean"});
                        return this.returnValue;
                    }
                    catch (Exception exception) {
                        sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
                        return null;
                    }
                }
            };
            diagnosticEventArray = (DiagnosticEvent[])SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPDumpInternal", "RasDiag.All.JmxInfo", new Object[]{objectName, string, string2, ""});
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDPDumpInternal", "RasDiag.DS.JMXCallIssue", exception);
        }
        sDiagnosticServiceLogger.exiting(sThisClass, "getDPDumpInternal");
        return diagnosticEventArray;
    }

    private DiagnosticEvent[] getSelfDiagnosticInternal(final ObjectName objectName, final String string, final boolean bl) {
        if (sDiagnosticServiceLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceLogger.entering(sThisClass, "getSelfDiagnosticInternal", new Object[]{objectName.toString(), string});
        }
        DiagnosticEvent[] diagnosticEventArray = null;
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, objectName, "selfDiagnostic", new Object[]{string, new Boolean(bl)}, new String[]{"java.lang.String", "boolean"});
                        return this.returnValue;
                    }
                    catch (Exception exception) {
                        sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
                        return null;
                    }
                }
            };
            diagnosticEventArray = (DiagnosticEvent[])SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getSelfDiagnosticInternal", "RasDiag.All.JmxInfo", new Object[]{objectName, string, "", ""});
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getSelfDiagnosticInternal", "RasDiag.DS.JMXCallIssue", exception);
        }
        sDiagnosticServiceLogger.exiting(sThisClass, "getSelfDiagnosticInternal");
        return diagnosticEventArray;
    }

    public void setStateCollectionSpec(String string) {
        sDiagnosticConfigHome.setStateCollectionSpec(string);
    }

    public String getStateCollectionSpec() {
        return sDiagnosticConfigHome.getStateCollectionSpec();
    }

    public void refreshRegistrations() {
        this.iDiagnosticProviderRegistry.refreshRegistrations();
    }

    public String[] listRegistrations() {
        return this.iDiagnosticProviderRegistry.listRegistrations();
    }

    public String[] localize(String string, String[] stringArray, Locale locale) {
        if (string == null || stringArray == null || locale == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "localize", "RasDiag.All.NullParm", "DPN: " + string);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getDPid4DPName(string);
        if (objectName == null) {
            return null;
        }
        return this.localizeInternal(objectName, stringArray, locale);
    }

    public String[] localizeById(String string, String[] stringArray, Locale locale) {
        if (string == null || stringArray == null || locale == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "localizeById", "RasDiag.All.NullParm", "DPid: " + string);
            return null;
        }
        ObjectName objectName = this.iDiagnosticProviderRegistry.getObjNameFromDPid(string);
        if (objectName == null) {
            return null;
        }
        return this.localizeInternal(objectName, stringArray, locale);
    }

    private String[] localizeInternal(final ObjectName objectName, final String[] stringArray, final Locale locale) {
        if (sDiagnosticServiceLogger.isLoggable(Level.FINER)) {
            sDiagnosticServiceLogger.entering(sThisClass, "localizeInternal", new Object[]{objectName, stringArray, locale});
        }
        String[] stringArray2 = null;
        if (objectName == null) {
            return null;
        }
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){
                Object returnValue;

                public Object run() throws Exception {
                    try {
                        this.returnValue = DiagnosticProviderHelper.callJmxServer(sAdminSvc, objectName, "localize", new Object[]{stringArray, locale}, new String[]{"[Ljava.lang.String;", "java.util.Locale"});
                        return this.returnValue;
                    }
                    catch (Exception exception) {
                        sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "callJmxServer", "RasDiag.DS.JMXCallIssue", exception);
                        return null;
                    }
                }
            };
            stringArray2 = (String[])SecurityContext.runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.All.JmxInfo", new Object[]{objectName, locale, "", ""});
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "localizeInternal", "RasDiag.DS.JMXCallIssue", exception);
        }
        sDiagnosticServiceLogger.exiting(sThisClass, "localizeInternal");
        sDiagnosticServiceLogger.logp(Level.FINER, "DiagnosticService", "localizeInternal", "First string to localize: " + stringArray[0] + " Locd: " + stringArray2[0]);
        return stringArray2;
    }

    private String[] formatDiagnosticEvent(ObjectName objectName, DiagnosticEvent[] diagnosticEventArray, Locale locale) {
        if (dfltLocale == null) {
            this.loadStrings();
        }
        if (diagnosticEventArray == null || diagnosticEventArray.length == 0) {
            String string = diagnosticEventArray == null ? "Null DiagEventArray" : "Empty DiagEventArray";
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "formatDiagnosticEvent", "RasDiag.All.InvalidParm", string);
            return null;
        }
        if (locale == null) {
            locale = dfltLocale;
        }
        String[] stringArray = new String[diagnosticEventArray.length];
        for (int i = 0; i < diagnosticEventArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(4096);
            short s = diagnosticEventArray[i].getContentType();
            String string = diagnosticEventArray[i].getDiagnosticProviderId();
            String string2 = diagnosticEventArray[i].getEventType();
            String string3 = diagnosticEventArray[i].getMessageKey();
            String string4 = diagnosticEventArray[i].getResourceBundleName();
            String string5 = diagnosticEventArray[i].getSourceClass();
            String string6 = diagnosticEventArray[i].getSourceMethod();
            String string7 = diagnosticEventArray[i].getCellName();
            String string8 = diagnosticEventArray[i].getNodeName();
            String string9 = diagnosticEventArray[i].getServerName();
            String string10 = diagnosticEventArray[i].getServerDetail();
            if (locale == dfltLocale) {
                stringBuffer.append(TraceNLS.getFormattedMessageFromLocalizedMessage(dfltStrings[0], new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, new Short(s)}, false));
                stringBuffer.append("\n\n" + dfltStrings[1] + "\n");
            } else {
                stringBuffer.append(TraceNLS.getFormattedMessage("com.ibm.ws.rasdiag.resources.RasDiagLocalization", "RasDiag.DEFormat.Msg0", locale, new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, new Short(s)}, "Formatting error", false));
                stringBuffer.append("\n\n" + TraceNLS.getStringFromBundle("com.ibm.ws.rasdiag.resources.RasDiagLocalization", "RasDiag.DEFormat.Msg1", locale) + "\n");
            }
            sDiagnosticServiceLogger.logp(Level.FINE, sThisClass, "formatDiagnosticEvent", "Current generic Return Value: " + stringBuffer);
            ArrayList arrayList = new ArrayList(64);
            ArrayList arrayList2 = new ArrayList(64);
            ArrayList arrayList3 = new ArrayList(64);
            ArrayList arrayList4 = new ArrayList(64);
            int n = DiagnosticService.getDiagFormatInfo(diagnosticEventArray[i], arrayList, arrayList2, arrayList3, arrayList4);
            String[] stringArray2 = new String[n];
            stringArray2 = arrayList4.toArray(stringArray2);
            for (int j = 0; j < n; ++j) {
                stringBuffer.append("\n" + String.format(" %1$-50s = %2$-5s", arrayList.get(j), arrayList3.get(j)));
            }
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    private void loadStrings() {
        dfltLocale = Locale.getDefault();
        dfltBundle = TraceNLS.getResourceBundle("com.ibm.ws.rasdiag.resources.RasDiagLocalization", dfltLocale);
        for (int i = 0; i < 2; ++i) {
            DiagnosticService.dfltStrings[i] = dfltBundle.getString("RasDiag.DEFormat.Msg" + i);
        }
    }

    public static int getDiagFormatInfo(DiagnosticEvent diagnosticEvent, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        if (diagnosticEvent == null || arrayList == null || arrayList2 == null || arrayList3 == null || arrayList4 == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDiagFormatInfo", "RasDiag.All.NullParm");
            return 0;
        }
        TreeMap treeMap = (TreeMap)diagnosticEvent.getDiagnosticData();
        if (treeMap == null) {
            return 0;
        }
        return DiagnosticService.getDiagFormatInfoRecurse(treeMap, "", arrayList, arrayList2, arrayList3, arrayList4, 0);
    }

    private static int getDiagFormatInfoRecurse(TreeMap treeMap, String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, int n) {
        Set set = treeMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = treeMap.get(string2);
            if (v instanceof DiagnosticTypedValue) {
                DiagnosticTypedValue diagnosticTypedValue = (DiagnosticTypedValue)v;
                arrayList.add(n, string + string2);
                arrayList2.add(n, DiagnosticTypedValue.sTypeNames[diagnosticTypedValue.tvType]);
                arrayList3.add(n, diagnosticTypedValue.tvString);
                arrayList4.add(n, diagnosticTypedValue.tvMsgKey);
                ++n;
                continue;
            }
            if (v instanceof TreeMap) {
                n = DiagnosticService.getDiagFormatInfoRecurse((TreeMap)v, string + string2 + "-", arrayList, arrayList2, arrayList3, arrayList4, n);
                continue;
            }
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "getDiagFormatInfoRecurse", "RasDiag.All.InvMapType", v.getClass().getName());
        }
        return n;
    }

    static DiagnosticService getInstance() {
        return sDiagnosticService;
    }

    void sendRegistrationNotification(DiagnosticProviderRegistration diagnosticProviderRegistration) {
        if (isCR || !isZOS) {
            return;
        }
        if (diagnosticProviderRegistration == null) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "sendRegistrationNotification", "RasDiag.All.NullParm");
            return;
        }
        Notification notification = new Notification("DiagnosticProvider.registration", this.getObjectName(), ntfySeqNum++);
        String string = "";
        if (isZOS) {
            string = PlatformHelperFactory.getPlatformHelper().getServantToken();
        }
        diagnosticProviderRegistration.setStoken(string);
        notification.setUserData(diagnosticProviderRegistration);
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            sDiagnosticServiceLogger.logp(Level.WARNING, sThisClass, "sendRegistrationNotification", "RasDiag.DPReg.RegFail", mBeanException);
        }
    }
}

