/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.models.config.diagnosticproviderservice.DiagnosticProviderService;
import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.ws.rasdiag.DiagnosticService;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.rasdiag.DiagnosticConfigHome;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class DiagnosticServiceImpl
extends WsComponentImpl {
    ObjectName sDiagServiceMBean = null;
    private static final String sThisClass = DiagnosticServiceImpl.class.getName();
    private static Logger sDiagnosticServiceImplLogger = DiagnosticEventHelper.getLogger(sThisClass, "com.ibm.ws.rasdiag.resources.RasDiagMessages");

    public void initialize(Object object) {
        DiagnosticProviderService diagnosticProviderService = null;
        if (object != null) {
            if (object instanceof String) {
                sDiagnosticServiceImplLogger.logp(Level.INFO, sThisClass, "initialize", "RasDiag.All.InvalidParm", (String)object);
            } else if (object instanceof DiagnosticProviderService) {
                diagnosticProviderService = (DiagnosticProviderService)object;
                String string = diagnosticProviderService.getStartupStateCollectionSpec();
                sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "initialize", "Correct Init w/DPService object and spec of: " + string);
                DiagnosticConfigHome diagnosticConfigHome = DiagnosticConfigHome.getInstance();
                diagnosticConfigHome.setStateCollectionSpec(string);
            } else {
                sDiagnosticServiceImplLogger.logp(Level.INFO, sThisClass, "initialize", "TestMsg", "Incorrect drive of init w/config that is not proper type: " + object.getClass().getName());
            }
        } else {
            sDiagnosticServiceImplLogger.logp(Level.INFO, sThisClass, "initialize", "RasDiag.All.NullParm");
        }
    }

    public void destroy() {
    }

    public void start() {
        Properties properties = new Properties();
        sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "MJC: SrvType: " + AdminServiceFactory.getAdminService().getServerType() + " CR: " + PlatformHelperFactory.getPlatformHelper().isControlJvm() + " NA constant: " + "NODE_AGENT");
        if (AdminServiceFactory.getAdminService().getServerType().equals("NODE_AGENT")) {
            sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "This is nodeagent, so starting the standard");
            DiagnosticService diagnosticService = new DiagnosticService();
            this.sDiagServiceMBean = this.locRegisterMBean("DiagnosticService", diagnosticService, "DiagnosticService", null, properties);
        } else if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
            sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "This is CR and not nodeagent, so starting the MBeanProxy");
            RuntimeCollaborator runtimeCollaborator = null;
            try {
                sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "Creating MBeanProxy itself in try block");
                Class<?> clazz = Class.forName("com.ibm.ws390.management.proxy.DiagnosticServiceMBeanProxy");
                sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "creating newInstance of MBeanProxy");
                runtimeCollaborator = (RuntimeCollaborator)clazz.newInstance();
            }
            catch (Exception exception) {
                sDiagnosticServiceImplLogger.logp(Level.WARNING, sThisClass, "start", "RasDiagSamp.DSI.MBeanAct", "Creating MBeanProxy");
                sDiagnosticServiceImplLogger.logp(Level.WARNING, sThisClass, "start", "RasDiagSamp.DSI.MBeanAct", exception);
            }
            sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "Registering the created proxy");
            this.sDiagServiceMBean = this.locRegisterMBean("DiagnosticService", runtimeCollaborator, "DiagnosticService", null, properties);
            sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "Registered the created proxy");
        } else {
            sDiagnosticServiceImplLogger.logp(Level.FINE, sThisClass, "start", "This is not CR or NodeAgent, so we are starting the standard");
            DiagnosticService diagnosticService = new DiagnosticService();
            this.sDiagServiceMBean = this.locRegisterMBean("DiagnosticService", diagnosticService, "DiagnosticService", null, properties);
        }
    }

    public ObjectName getDPid() {
        return this.sDiagServiceMBean;
    }

    private ObjectName locRegisterMBean(String string, RuntimeCollaborator runtimeCollaborator, String string2, String string3, Properties properties) {
        MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
        ObjectName objectName = null;
        if (mBeanFactory != null) {
            try {
                properties.setProperty("name", string2);
                objectName = mBeanFactory.activateMBean(string, runtimeCollaborator, string3, null, properties);
            }
            catch (Exception exception) {
                sDiagnosticServiceImplLogger.logp(Level.SEVERE, sThisClass, "locRegisterMBean", "RasDiagSamp.DSI.MBeanAct", exception);
            }
        }
        return objectName;
    }
}

