/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rasdiag;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.performance.tuning.rule.RuleData;
import com.ibm.ws.performance.tuning.serverAlert.ServerRuleDriver;
import com.ibm.ws.rasdiag.AlertConfigHome;
import java.util.ArrayList;

public class ImmediateAlertBridge {
    private static TraceComponent tc = Tr.register(ImmediateAlertBridge.class, null, "com.ibm.ws.performance.tuning.properties.perftuning");
    private boolean enabled;
    private int minTimeBetweenAlerts = 0;
    private String node;
    private String server;
    private ServerRuleDriver rpa;
    private static ImmediateAlertBridge immediateAlertBridge = new ImmediateAlertBridge();
    private static AlertConfigHome alertConfigHome = AlertConfigHome.getInstance();

    private ImmediateAlertBridge() {
    }

    public static ImmediateAlertBridge getInstance() {
        return immediateAlertBridge;
    }

    public void setImmediateAlertBridge(ServerRuleDriver serverRuleDriver, String string, String string2) {
        Tr.entry(tc, "ImmediateAlertBridge");
        this.node = string;
        this.server = string2;
        this.rpa = serverRuleDriver;
        this.enabled = false;
        Tr.exit(tc, "ImmediateAlertBridge");
    }

    public void setEnabled(boolean bl) {
        Tr.entry(tc, "setEnabled");
        this.enabled = bl;
        AlertConfigHome.setEnabled(bl);
        Tr.exit(tc, "setEnabled");
    }

    public boolean getEnabled() {
        Tr.entry(tc, "getEnabled");
        Tr.exit(tc, "getEnabled");
        return this.enabled;
    }

    public boolean isImmediateAlert(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, ">><<<isImmediateAlert");
        }
        return alertConfigHome.isImmediateAlert(string);
    }

    public boolean isAlertEnabled(String string) {
        Tr.entry(tc, "isAlertEnabled");
        boolean bl = alertConfigHome.isAlertEnabled(string, false);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enabled: " + bl);
        }
        Tr.exit(tc, "isAlertEnabled");
        return bl;
    }

    public void setAlertEnabled(String string, boolean bl) {
        Tr.entry(tc, "setAlertEnabled");
        alertConfigHome.setAlertEnabled(string, bl);
        Tr.exit(tc, "setAlertEnabled");
    }

    public void setAlertAttribute(String string, String string2, Double d) {
        Tr.entry(tc, "setAlertAttribute");
        alertConfigHome.setAlertAttribute(string, string2, d);
        Tr.exit(tc, "setAlertAttribute");
    }

    public Double getAlertAttribute(String string, String string2) {
        Tr.entry(tc, "getAlertAttribute");
        Double d = alertConfigHome.getAlertAttribute(string, string2);
        Tr.exit(tc, "getAlertAttribute");
        return d;
    }

    public ArrayList getAlertParsedMBeanAttributes(String string) {
        Tr.entry(tc, "getAlertParsedMBeanAttributes - NOT IMPLEMENTED YET");
        ArrayList arrayList = alertConfigHome.getAlertParsedMBeanAttributes(string);
        Tr.exit(tc, "getAlertParsedMBeanAttributes");
        return arrayList;
    }

    public String[] getImmediateAlertIDs() {
        return alertConfigHome.getImmediateAlertIDs();
    }

    public String getImmediateAlertNameLookup(String string) {
        Tr.entry(tc, "getImmediateAlertNameLookup");
        String string2 = alertConfigHome.getImmediateAlertNameLookup(string);
        Tr.exit(tc, "getImmediateAlertNameLookup");
        return string2;
    }

    public boolean getImmediateAlertRuleApplicability(String string) {
        Tr.entry(tc, "getImmediateAlertRuleApplicability");
        boolean bl = alertConfigHome.getImmediateAlertRuleApplicability(string);
        Tr.exit(tc, "getImmediateAlertRuleApplicability");
        return bl;
    }

    public RuleData loadImmediateAlert(String string) {
        RuleData ruleData;
        block3: {
            Tr.entry(tc, "loadImmediateAlert");
            ruleData = null;
            try {
                ruleData = this.rpa.readImmediateAlertConfig(string);
                if (ruleData == null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "did not find immediate alert config for : " + string);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "exception when loading rule : " + string + " : " + exception.toString());
                exception.printStackTrace();
            }
        }
        Tr.exit(tc, "loadImmediateAlert");
        return ruleData;
    }
}

