/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RLSAccessFile;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class CoordinationLock {
    private static final TraceComponent tc = Tr.register(CoordinationLock.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    public static final int LOCK_SUCCESS = 1;
    public static final int LOCK_FAILURE = 2;
    public static final int LOCK_INTERRUPT = 4;
    static final int LOCKRETRYCOUNT = 0;
    static final int LOCKRETRYDELAY = 10000;
    static final int LOCKRETRYTIMES = 30;
    private static String RECOVERY_FILE_1_NAME = "log1";
    private static String RECOVERY_FILE_2_NAME = "log2";
    CoordinationLockHandle _handle1 = null;
    CoordinationLockHandle _handle2 = null;
    private String _lockDirectory;
    private boolean _lockFilesExist = false;
    private boolean _interrupted = false;

    CoordinationLock(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CoordinationLock", string);
        }
        this._lockDirectory = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CoordinationLock", this);
        }
    }

    public int lock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lock");
        }
        int n = 2;
        if (!this._lockFilesExist) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confirming/Creating the lock files");
            }
            this._handle1 = this.ensureFileExists(RECOVERY_FILE_1_NAME);
            if (this._handle1 != null) {
                this._handle2 = this.ensureFileExists(RECOVERY_FILE_2_NAME);
                if (this._handle2 != null) {
                    this._lockFilesExist = true;
                } else {
                    Tr.error(tc, "CWRLS0004_RECOVERY_LOG_CREATE_FAILED", this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME);
                    this._handle1 = null;
                }
            } else {
                Tr.error(tc, "CWRLS0004_RECOVERY_LOG_CREATE_FAILED", this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Already Confirmed/Created the lock files");
        }
        if (this._lockFilesExist) {
            n = this.obtainLock(this._handle1);
            if (n == 1) {
                n = this.obtainLock(this._handle2);
                if (n != 1) {
                    if (n == 2) {
                        Tr.error(tc, "CWRLS0005_RECOVERY_LOG_LOCK_FAILED", this._lockDirectory + File.separator + RECOVERY_FILE_2_NAME);
                    }
                    this.releaseLock(this._handle1);
                }
            } else if (n == 2) {
                Tr.error(tc, "CWRLS0005_RECOVERY_LOG_LOCK_FAILED", this._lockDirectory + File.separator + RECOVERY_FILE_1_NAME);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lock", new Integer(n));
        }
        return n;
    }

    public void unlock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unlock");
        }
        if (this._handle2 != null) {
            this.releaseLock(this._handle2);
        }
        if (this._handle1 != null) {
            this.releaseLock(this._handle1);
        }
        this._handle2 = null;
        this._handle1 = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unlock");
        }
    }

    private int obtainLock(CoordinationLockHandle coordinationLockHandle) {
        int n;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "obtainLock", coordinationLockHandle);
            }
            n = 2;
            try {
                final File file = new File(coordinationLockHandle._directory, coordinationLockHandle._fileName);
                try {
                    coordinationLockHandle._raf = (RandomAccessFile)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "run", this);
                            }
                            RLSAccessFile rLSAccessFile = RLSAccessFile.getRLSAccessFile(file);
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "run");
                            }
                            return rLSAccessFile;
                        }
                    });
                    coordinationLockHandle._channel = coordinationLockHandle._raf.getChannel();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", "253", this);
                    throw privilegedActionException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.CoordinationLock.obtainLock", "258", this);
                    throw exception;
                }
                boolean bl = false;
                int n2 = 0;
                while (!bl) {
                    int n3;
                    ++n2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RLSHA: Lock attempt #" + n2 + " on lock file " + coordinationLockHandle);
                    }
                    coordinationLockHandle._fileLock = coordinationLockHandle._channel.tryLock();
                    if (coordinationLockHandle._fileLock != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RLSHA: Obtained an exclusive access lock on lock file " + coordinationLockHandle);
                        }
                        bl = true;
                        n = 1;
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RLSHA: Unable to obtain an exclusive access lock on lock file " + coordinationLockHandle);
                    }
                    if ((n3 = n2 - 2) / 30 * 30 == n3) {
                        Tr.warning(tc, "CWRLS0026_RECOVERY_LOG_LOCK_RETRY", file);
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Sleeping for 10000 ms before re-try");
                        }
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this._interrupted) continue;
                    bl = true;
                    n = 4;
                    try {
                        coordinationLockHandle._raf.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "An unexpected exception has occured when trying to obtain the exclusive lock " + exception);
                }
                Tr.error(tc, "CWRLS0024_EXC_DURING_RECOVERY", exception);
                if (coordinationLockHandle._raf == null) break block21;
                try {
                    coordinationLockHandle._raf.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainLock", new Integer(n));
        }
        return n;
    }

    public void releaseLock(CoordinationLockHandle coordinationLockHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseLock", coordinationLockHandle);
        }
        if (coordinationLockHandle._fileLock != null) {
            try {
                coordinationLockHandle._fileLock.release();
                coordinationLockHandle._fileLock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (coordinationLockHandle._channel != null) {
            try {
                coordinationLockHandle._channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (coordinationLockHandle._raf != null) {
            try {
                coordinationLockHandle._raf.close();
                coordinationLockHandle._raf = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLock");
        }
    }

    public CoordinationLockHandle ensureFileExists(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ensureFileExists", string);
        }
        CoordinationLockHandle coordinationLockHandle = null;
        if (RLSUtils.createDirectoryTree(this._lockDirectory)) {
            final File file = new File(this._lockDirectory, string);
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run", this);
                        }
                        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                        randomAccessFile.close();
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run");
                        }
                        return null;
                    }
                });
                if (file.exists()) {
                    coordinationLockHandle = new CoordinationLockHandle();
                    coordinationLockHandle._fileName = string;
                    coordinationLockHandle._directory = this._lockDirectory;
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", "418", this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.CoordinationLock.ensureFileExists", "422", this);
            }
            if (coordinationLockHandle != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lock file exists");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to create the lock file");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unable to create the lock directory");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ensureFileExists", coordinationLockHandle);
        }
        return coordinationLockHandle;
    }

    public synchronized void interrupt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interrupt");
        }
        this._interrupted = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interrupt");
        }
    }

    private class CoordinationLockHandle {
        RandomAccessFile _raf = null;
        FileChannel _channel = null;
        String _fileName = null;
        String _directory = null;
        FileLock _fileLock = null;

        private CoordinationLockHandle() {
        }

        void raf(RandomAccessFile randomAccessFile) {
            this._raf = randomAccessFile;
        }

        public String toString() {
            return this._directory + File.separator + this._fileName;
        }
    }
}

