/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.nio.BufferUnderflowException;

public class DataItem {
    private static final TraceComponent tc = Tr.register(DataItem.class, "Transaction", null);
    protected static final int HEADER_SIZE = 4;
    protected static final int UNWRITTEN = -1;
    protected int _storageMode = 1;
    protected byte[] _data = null;
    protected int _filePosition = -1;
    protected LogRecord _logRecord = null;
    protected int _dataSize = 0;
    protected RecoverableUnitSectionImpl _rus = null;
    protected boolean _written = false;

    public DataItem(int n, byte[] byArray, RecoverableUnitSectionImpl recoverableUnitSectionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DataItem", new Object[]{new Integer(n), RLSUtils.toHexString(byArray, 32), recoverableUnitSectionImpl});
        }
        this._rus = recoverableUnitSectionImpl;
        this._data = byArray;
        this._storageMode = n;
        this._dataSize = byArray.length;
        this._rus.payloadAdded(this._dataSize + 4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DataItem", this);
        }
    }

    public DataItem(int n, ReadableLogRecord readableLogRecord, RecoverableUnitSectionImpl recoverableUnitSectionImpl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DataItem", new Object[]{new Integer(n), readableLogRecord, recoverableUnitSectionImpl});
        }
        this._rus = recoverableUnitSectionImpl;
        this._storageMode = n;
        this._logRecord = readableLogRecord;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Reading data size field @ position " + readableLogRecord.position());
            }
            this._dataSize = readableLogRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "This data item contains " + this._dataSize + " bytes of data");
            }
            this._rus.payloadAdded(this._dataSize + 4);
            this._rus.payloadWritten(this._dataSize + 4);
            this._written = true;
            if (n == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reading " + this._dataSize + "bytes of data @ position " + readableLogRecord.position());
                }
                this._data = new byte[this._dataSize];
                this._logRecord.get(this._data);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Tracking " + this._dataSize + "bytes of data @ position " + readableLogRecord.position());
                }
                this._filePosition = readableLogRecord.position();
                this._data = null;
                this._logRecord.advancePosition(this._dataSize);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, "com.ibm.ws.recoverylog.spi.DataItem.DataItem", "176", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DataItem", "InternalLogException");
            }
            throw new InternalLogException(bufferUnderflowException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.DataItem.DataItem", "182", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DataItem", "InternalLogException");
            }
            throw new InternalLogException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DataItem", this);
        }
    }

    protected void write(WriteableLogRecord writeableLogRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write", new Object[]{writeableLogRecord, this});
        }
        byte[] byArray = this.getData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing '" + byArray.length + "' bytes " + RLSUtils.toHexString(byArray, 32));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing length field");
        }
        writeableLogRecord.putInt(byArray.length);
        if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Updaing data location references");
            }
            this._filePosition = writeableLogRecord.position();
            this._logRecord = writeableLogRecord;
            this._data = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Writing data field");
        }
        writeableLogRecord.put(byArray);
        if (!this._written) {
            this._rus.payloadWritten(this._dataSize + 4);
        }
        this._written = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
    }

    protected byte[] getData() {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getData", this);
        }
        if ((byArray = this._data) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cached data located");
            }
        } else if (this._storageMode == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No cached data located. Attempting data retreival");
            }
            if (this._filePosition != -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Retrieving " + this._dataSize + " bytes of data @ position " + this._filePosition);
                }
                this._logRecord.position(this._filePosition);
                byArray = new byte[this._dataSize];
                this._logRecord.get(byArray);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to retrieve data as file position is not set");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No cached data located");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getData", new Object[]{new Integer(byArray.length), RLSUtils.toHexString(byArray, 32)});
        }
        return byArray;
    }
}

