/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FileFailureScopeFactory
implements FailureScopeFactory {
    private static final TraceComponent tc = Tr.register(FileFailureScopeFactory.class, "Transaction", null);
    private static final byte VERSION = 2;

    public FailureScope toFailureScope(byte[] byArray) {
        byte by;
        DataInputStream dataInputStream;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "toFailureScope", new Object[]{RLSUtils.toHexString(byArray), this});
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            by = 0;
            try {
                byte by2 = dataInputStream.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FailureScope version manager id is " + by2);
                }
                by = dataInputStream.readByte();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "FailureScope version is " + by);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", "61", this);
                if (!tc.isEventEnabled()) break block12;
                Tr.event(tc, "IOException caught inflating failure scope", iOException);
            }
        }
        FileFailureScope fileFailureScope = null;
        if (by == 2) {
            try {
                String string = dataInputStream.readUTF();
                fileFailureScope = new FileFailureScope(string);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toFailureScope", "68", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "IOException caught inflating failure scope", iOException);
                }
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "FailureScope version level not recognized. Expected version 2");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toFailureScope", fileFailureScope);
        }
        return fileFailureScope;
    }

    public byte[] toByteArray(FailureScope failureScope) {
        byte[] byArray;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "toByteArray", new Object[]{failureScope, this});
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byArray = null;
            try {
                dataOutputStream.writeByte(FailureScopeFactory.FILE_FAILURE_SCOPE_ID.byteValue());
                dataOutputStream.writeByte(2);
                dataOutputStream.writeUTF(failureScope.serverName());
                dataOutputStream.flush();
                dataOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.FileFailureScopeFactory.toByteArray", "104", this);
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "IOException caught deflating failure scope", iOException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toByteArray", byArray);
        }
        return byArray;
    }
}

