/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import java.util.HashMap;

public class Lock {
    private static final TraceComponent tc = Tr.register(Lock.class, "Transaction", null);
    private HashMap _sharedThreads = null;
    private Thread _threadHoldingExclusiveLock = null;
    private Thread _threadRequestingExclusiveLock = null;
    private String _traceId;

    public Lock(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Lock", string);
        }
        this._sharedThreads = new HashMap();
        this._threadHoldingExclusiveLock = null;
        this._threadRequestingExclusiveLock = null;
        this._traceId = "Lock:ownerIdentifier=" + string + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Lock", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSharedLock(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSharedLock", new Object[]{this, new Integer(n)});
        }
        Thread thread = Thread.currentThread();
        Integer n2 = null;
        Lock lock = this;
        synchronized (lock) {
            if (!this._sharedThreads.containsKey(thread) && (this._threadRequestingExclusiveLock != null || this._threadHoldingExclusiveLock != null && !this._threadHoldingExclusiveLock.equals(thread))) {
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " is waiting for the exclusive lock to be released");
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " waiting..");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.Lock.getSharedLock", "180", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " is has detected that the exclusive lock has been released");
                }
            }
            n2 = (n2 = (Integer)this._sharedThreads.get(thread)) == null ? new Integer(1) : new Integer(n2 + 1);
            this._sharedThreads.put(thread, n2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Count: " + n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSharedLock(int n) throws NoSharedLockException {
        Integer n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseSharedLock", new Object[]{this, new Integer(n)});
        }
        Thread thread = Thread.currentThread();
        int n3 = 0;
        Lock lock = this;
        synchronized (lock) {
            n2 = (Integer)this._sharedThreads.get(thread);
            if (n2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "releaseSharedLock", "NoSharedLockException");
                }
                throw new NoSharedLockException();
            }
            n3 = n2 - 1;
            if (n3 > 0) {
                n2 = new Integer(n3);
                this._sharedThreads.put(thread, n2);
            } else {
                n2 = null;
                this._sharedThreads.remove(thread);
            }
            if (n2 == null) {
                this.notifyAll();
            }
        }
        if (tc.isDebugEnabled()) {
            int n4 = 0;
            n2 = (Integer)this._sharedThreads.get(thread);
            if (n2 != null) {
                n4 = n2;
            }
            Tr.debug(tc, "Count: " + n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptExclusiveLock() throws HoldingExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attemptExclusiveLock", this);
        }
        boolean bl = false;
        Thread thread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock != null && this._threadHoldingExclusiveLock.equals(thread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "attemptExclusiveLock", "HoldingExclusiveLockException");
                }
                throw new HoldingExclusiveLockException();
            }
            if (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                Integer n = (Integer)this._sharedThreads.get(thread);
                this._sharedThreads.remove(thread);
                this.notifyAll();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " is waiting for the exclusive lock to be released");
                }
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " waiting..");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", "325", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " has detected that the exclusive lock has been released");
                }
                if (n != null) {
                    this._sharedThreads.put(thread, n);
                }
                bl = false;
            } else {
                this._threadRequestingExclusiveLock = thread;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " is waiting for the shared locks to quiesce");
                }
                while (this._sharedThreads.size() > 1 || this._sharedThreads.size() == 1 && !this._sharedThreads.containsKey(thread)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " waiting..");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", "362", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition");
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Thread " + Integer.toHexString(thread.hashCode()) + " has detected that the shared locks have quiesced");
                }
                this._threadHoldingExclusiveLock = thread;
                this._threadRequestingExclusiveLock = null;
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attemptExclusiveLock", "" + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseExclusiveLock() throws NoExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseExclusiveLock", this);
        }
        Thread thread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock == null || !this._threadHoldingExclusiveLock.equals(thread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "releaseExclusiveLock", "NoExclusiveLockException");
                }
                throw new NoExclusiveLockException();
            }
            this._threadHoldingExclusiveLock = null;
            this._threadRequestingExclusiveLock = null;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseExclusiveLock");
        }
    }

    public String toString() {
        return this._traceId;
    }
}

