/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.NotSupportedException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LogCursorImpl
implements LogCursor {
    private static final TraceComponent tc = Tr.register(LogCursorImpl.class, "Transaction", null);
    private Lock _controlLock = null;
    private int _initialSize = 0;
    private boolean _empty = true;
    private Iterator _iterator1 = null;
    private Iterator _iterator2 = null;
    private Iterator _removeIterator = null;
    private Object _removeObject = null;
    private Object _singleObject = null;
    private boolean _removeSupported = false;
    private LogCursorCallback _callback = null;
    private static final int LOCK_REQUEST_ID_LCI = 12;

    LogCursorImpl(Lock lock, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogCursorImpl", new Object[]{lock, object});
        }
        this._controlLock = lock;
        this._singleObject = object;
        this._removeSupported = false;
        this._callback = null;
        if (object != null) {
            this._initialSize = 1;
            this._empty = false;
        } else {
            this._initialSize = 0;
            this._empty = true;
        }
        if (this._controlLock != null) {
            this._controlLock.getSharedLock(12);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogCursorImpl", new Object[]{new Integer(this._initialSize), this});
        }
    }

    LogCursorImpl(Lock lock, Collection collection, boolean bl, LogCursorCallback logCursorCallback) {
        this(lock, collection, null, bl, logCursorCallback);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogCursorImpl", new Object[]{lock, collection, new Boolean(bl), logCursorCallback});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogCursorImpl", new Object[]{new Integer(this._initialSize), this});
        }
    }

    LogCursorImpl(Lock lock, Collection collection, Collection collection2, boolean bl, LogCursorCallback logCursorCallback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogCursorImpl", new Object[]{lock, collection, collection2, new Boolean(bl), logCursorCallback});
        }
        int n = 0;
        int n2 = 0;
        if (collection != null) {
            n = collection.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Collection 1 size: " + n);
            }
            this._iterator1 = collection.iterator();
            this._empty = false;
        }
        if (collection2 != null) {
            n2 = collection2.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Collection 2 size: " + n2);
            }
            this._iterator2 = collection2.iterator();
            this._empty = false;
        }
        this._singleObject = null;
        this._controlLock = lock;
        this._initialSize = n + n2;
        this._removeSupported = bl;
        this._callback = this._removeSupported ? logCursorCallback : null;
        if (this._controlLock != null) {
            this._controlLock.getSharedLock(12);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogCursorImpl", new Object[]{new Integer(this._initialSize), this});
        }
    }

    public Object next() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "next", this);
        }
        Object object = null;
        this._removeIterator = null;
        if (!this._empty) {
            if (this._singleObject != null) {
                object = this._singleObject;
                this._singleObject = null;
                this._empty = true;
            } else {
                try {
                    if (this._iterator1 != null && this._iterator1.hasNext()) {
                        object = this._iterator1.next();
                        this._removeIterator = this._iterator1;
                    } else if (this._iterator2 != null && this._iterator2.hasNext()) {
                        object = this._iterator2.next();
                        this._removeIterator = this._iterator2;
                    } else {
                        this._empty = true;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    FFDCFilter.processException((Throwable)noSuchElementException, "com.ibm.ws.recoverylog.spi.LogCursorImpl.next", "328", this);
                    this._empty = true;
                }
            }
        }
        this._removeObject = object;
        Object object2 = this.preprocessResult(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "next", object2);
        }
        return object2;
    }

    public boolean hasNext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNext", this);
        }
        boolean bl = false;
        if (!this._empty && (this._singleObject != null || this._iterator1 != null && this._iterator1.hasNext() || this._iterator2 != null && this._iterator2.hasNext())) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNext", new Boolean(bl));
        }
        return bl;
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", this);
        }
        if (this._controlLock != null) {
            try {
                this._controlLock.releaseSharedLock(12);
            }
            catch (NoSharedLockException noSharedLockException) {
                FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.LogCursorImpl.close", "401", this);
            }
        }
        this._iterator1 = null;
        this._iterator2 = null;
        this._removeIterator = null;
        this._controlLock = null;
        this._singleObject = null;
        this._empty = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public int initialSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialSize", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialSize", new Integer(this._initialSize));
        }
        return this._initialSize;
    }

    public void remove() throws NotSupportedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", this);
        }
        if (!this._removeSupported) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "remove", "NotSupportedException");
            }
            throw new NotSupportedException(null);
        }
        if (this._removeIterator != null) {
            if (this._callback != null) {
                this._removeIterator.remove();
                try {
                    this._callback.removing(this._removeObject);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.LogCursorImpl.remove", "469", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "An unexpected error occured whilst attempting to remove an object from the cursor");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "remove", "InternalLogException");
                    }
                    throw new InternalLogException(exception);
                }
            }
            this._removeIterator = null;
            this._removeObject = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    public Object last() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "last", this);
        }
        Object object = null;
        while (this.hasNext()) {
            object = this.next();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "last", object);
        }
        return this.preprocessResult(object);
    }

    private Object preprocessResult(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preprocessResult", new Object[]{object, this});
        }
        Object object2 = null;
        object2 = object instanceof DataItem ? (Object)((DataItem)object).getData() : object;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preprocessResult", object2);
        }
        return object2;
    }
}

