/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.RLSAccessFile;
import com.ibm.ws.recoverylog.spi.RLSHAGroupCallback;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

class LogFileHandle {
    private static final TraceComponent tc = Tr.register(LogFileHandle.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    static final int STATUS_FIELD_FILE_OFFSET = 4 + LogFileHeader.MAGIC_NUMBER.length + 4;
    private ByteBuffer _fileBuffer = null;
    private boolean _isMapped = false;
    private List _pendingWriteList = new ArrayList();
    private Comparator _recordComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "compare", new Object[]{object, object2, this});
            }
            int n = ((LogRecord)object).absolutePosition() - ((LogRecord)object2).absolutePosition();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "compare", new Integer(n));
            }
            return n;
        }

        public boolean equals(Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "equals", new Object[]{object, this});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "equals", Boolean.FALSE);
            }
            return false;
        }
    };
    private RandomAccessFile _file = null;
    private FileChannel _fileChannel = null;
    private LogFileHeader _logFileHeader = null;
    private String _logDirectory = null;
    private String _fileName = null;
    private String _serverName = null;
    private String _serviceName = null;
    private int _serviceVersion;
    private String _logName = null;
    private int _fileSize = 0;
    FailureScope _failureScope = null;

    protected LogFileHandle(String string, String string2, String string3, String string4, int n, String string5, int n2, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogFileHandle", new Object[]{string, string2, string3, string4, new Integer(n), string5, new Integer(n2), failureScope});
        }
        this._logDirectory = string;
        this._fileName = string2;
        this._serverName = string3;
        this._serviceName = string4;
        this._serviceVersion = n;
        this._logName = string5;
        this._fileSize = n2;
        this._failureScope = failureScope;
        this._logFileHeader = new LogFileHeader(this._serverName, this._serviceName, this._serviceVersion, this._logName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogFileHandle", this);
        }
    }

    protected ReadableLogRecord getReadableLogRecord(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadableLogRecord", new Object[]{this, new Long(l)});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating readable log record to read from file " + this._fileName);
        }
        ReadableLogRecord readableLogRecord = ReadableLogRecord.read(this._fileBuffer.slice(), l, this._fileBuffer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReadableLogRecord", readableLogRecord);
        }
        return readableLogRecord;
    }

    protected void fileOpen() throws InternalLogException, LogAllocationException, LogIncompatibleException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fileOpen", this);
        }
        try {
            try {
                final File file = new File(this._logDirectory, this._fileName);
                boolean bl2 = bl = !file.exists() || file.length() == 0L;
                if (bl) {
                    Tr.info(tc, "CWRLS0006_RECOVERY_LOG_CREATE", this._logDirectory + File.separator + this._fileName);
                }
                this._fileBuffer = (MappedByteBuffer)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "run", this);
                        }
                        LogFileHandle.this._file = RLSAccessFile.getRLSAccessFile(file);
                        LogFileHandle.this._fileChannel = LogFileHandle.this._file.getChannel();
                        int n = (int)LogFileHandle.this._file.length();
                        int n2 = LogFileHandle.this._fileSize * 1024;
                        int n3 = n > n2 ? n : n2;
                        boolean bl2 = Boolean.getBoolean("com.ibm.ws.recoverylog.spi.NoMemoryMappedFiles");
                        ByteBuffer byteBuffer = null;
                        if (!bl2) {
                            try {
                                byteBuffer = LogFileHandle.this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n3);
                                LogFileHandle.this._isMapped = true;
                            }
                            catch (Throwable throwable) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Mapping of recovery log file failed. Using non-mapped file.", throwable);
                                }
                            }
                        } else if (tc.isEventEnabled()) {
                            Tr.event(tc, "Recovery log has been instructed not to use a mapped-file model.");
                        }
                        if (byteBuffer == null) {
                            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3);
                            if (bl) {
                                LogFileHandle.this._fileChannel.write(byteBuffer2, 0L);
                                LogFileHandle.this._fileChannel.force(true);
                            }
                            LogFileHandle.this._fileChannel.read(byteBuffer2);
                            byteBuffer2.rewind();
                            LogFileHandle.this._isMapped = false;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "A direct byte buffer has been allocated successfully.");
                            }
                            byteBuffer = byteBuffer2;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run", byteBuffer);
                        }
                        return byteBuffer;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "338", this);
                throw new LogAllocationException(privilegedActionException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "343", this);
                throw new InternalLogException(throwable);
            }
        }
        catch (LogAllocationException logAllocationException) {
            FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "351", this);
            this._fileBuffer = null;
            if (this._file != null) {
                this.fileClose();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fileOpen", logAllocationException);
            }
            throw logAllocationException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "359", this);
            this._fileBuffer = null;
            if (this._file != null) {
                this.fileClose();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fileOpen", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log File " + this._fileName + " is cold starting");
            }
            try {
                this.writeFileHeader(false);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "388", this);
                this.fileClose();
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fileOpen", internalLogException);
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "396", this);
                this.fileClose();
                this._file = null;
                this._fileChannel = null;
                this._fileBuffer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fileOpen", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log File " + this._fileName + " is warm starting");
            }
            this.readFileHeader();
        }
        if (!this._logFileHeader.compatible()) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "423", this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "429", this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fileOpen", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (!this.serviceCompatible()) {
            try {
                this._file.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "423", this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileOpen", "429", this);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
            this._logFileHeader = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "fileOpen", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fileOpen");
        }
    }

    protected boolean fileExists() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fileExists", this);
        }
        boolean bl = true;
        File file = new File(this._logDirectory, this._fileName);
        boolean bl2 = bl = file.exists() && file.length() > 0L;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fileExists", new Boolean(bl));
        }
        return bl;
    }

    void fileClose() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fileClose", this);
        }
        if (this._fileChannel != null) {
            try {
                this._file.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileClose", "541", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fileClose", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            this._fileBuffer = null;
            this._file = null;
            this._fileChannel = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fileClose");
        }
    }

    public WriteableLogRecord getWriteableLogRecord(int n, long l) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWriteableLogRecord", new Object[]{new Integer(n), new Long(l), this});
        }
        ByteBuffer byteBuffer = (ByteBuffer)this._fileBuffer.slice().limit(n + WriteableLogRecord.HEADER_SIZE);
        WriteableLogRecord writeableLogRecord = new WriteableLogRecord(byteBuffer, l, n, this._fileBuffer.position());
        this._fileBuffer.position(this._fileBuffer.position() + n + WriteableLogRecord.HEADER_SIZE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWriteableLogRecord", writeableLogRecord);
        }
        return writeableLogRecord;
    }

    private void writeFileHeader(boolean bl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeFileHeader", new Object[]{this, new Boolean(bl)});
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing header for log file " + this._fileName);
            }
            this._logFileHeader.write(this._fileBuffer, bl);
            this.force();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", "706", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeFileHeader", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileHeader", "712", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeFileHeader", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeFileHeader");
        }
    }

    private void writeFileStatus(boolean bl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeFileStatus", new Object[]{this, new Boolean(bl)});
        }
        if (this._logFileHeader.status() == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeFileStatus", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int n = 0;
            if (bl) {
                n = this._fileBuffer.position();
            }
            this._fileBuffer.position(STATUS_FIELD_FILE_OFFSET);
            this._fileBuffer.putInt(this._logFileHeader.status());
            this.force();
            if (bl) {
                this._fileBuffer.position(n);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.writeFileStatus", "797", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeFileStatus", "WriteOperationFailedException");
            }
            throw new WriteOperationFailedException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeFileStatus");
        }
    }

    private void readFileHeader() {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "readFileHeader", this);
            }
            this._logFileHeader.reset();
            try {
                if (this._fileBuffer.capacity() >= 4) {
                    this._logFileHeader.read(this._fileBuffer);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.readFileHeader", "863", this);
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "The log header could not be read from the disk due to an unexpected exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readFileHeader");
        }
    }

    private boolean serviceCompatible() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceCompatible");
        }
        boolean bl = false;
        String string = this._logFileHeader.serviceName();
        int n = this._logFileHeader.serviceVersion();
        String string2 = this._logFileHeader.logName();
        if (n > this._serviceVersion || string == null || string2 == null || !string.equals(this._serviceName) || !string2.equals(this._logName)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Client service and recovery log are not compatible");
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Current service name is " + this._serviceName);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Service name from file is " + string);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Current log name is " + this._logName);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Log name from file is " + string2);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Client version number is " + this._serviceVersion);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Version number from file is " + n);
            }
        } else {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serviceCompatible", new Boolean(bl));
        }
        return bl;
    }

    protected LogFileHeader logFileHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logFileHeader", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logFileHeader", this._logFileHeader);
        }
        return this._logFileHeader;
    }

    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceData", this);
        }
        byte[] byArray = null;
        if (this._logFileHeader != null) {
            byArray = this._logFileHeader.getServiceData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceData", RLSUtils.toHexString(byArray, 32));
        }
        return byArray;
    }

    public int freeBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "freeBytes", this);
        }
        int n = 0;
        try {
            int n2 = this._fileBuffer.position();
            int n3 = this._fileBuffer.capacity();
            n = n3 - n2;
            if (n < 0) {
                n = 0;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.freeBytes", "956", this);
            n = 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "freeBytes", new Integer(n));
        }
        return n;
    }

    public void setServiceData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceData", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        this._logFileHeader.setServiceData(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceData");
        }
    }

    public String fileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fileName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fileName", this._fileName);
        }
        return this._fileName;
    }

    void keypointStarting(long l) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointStarting", new Object[]{new Long(l), this});
        }
        this._logFileHeader.keypointStarting(l);
        try {
            this.writeFileHeader(false);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", "1073", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointStarting", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.keypointStarting", "1079", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointStarting", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointStarting");
        }
    }

    void keypointComplete() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointComplete", this);
        }
        this._logFileHeader.keypointComplete();
        try {
            this.writeFileStatus(true);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", "1117", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointComplete", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.keypointComplete", "1123", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointComplete", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointComplete");
        }
    }

    void becomeInactive() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "becomeInactive", this);
        }
        this._logFileHeader.changeStatus(2);
        try {
            this.writeFileStatus(false);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", "1161", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "becomeInactive", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHandle.becomeInactive", "1167", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "becomeInactive", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "becomeInactive", this);
        }
    }

    void becomeActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "becomeActive", this);
        }
        this._logFileHeader.changeStatus(4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "becomeActive");
        }
    }

    public void fileExtend(int n) throws LogAllocationException {
        int n2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fileExtend", new Object[]{new Integer(n), this});
        }
        if ((n2 = this._fileBuffer.capacity()) < n) {
            try {
                int n3 = this._fileBuffer.position();
                Tr.uncondEvent(tc, "Expanding log file to size of " + n + " bytes.");
                if (this._isMapped) {
                    this._fileBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "File is NOT mapped.  Allocating new DirectByteBuffer");
                    }
                    this._fileBuffer.position(0);
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
                    byteBuffer.put(this._fileBuffer);
                    byteBuffer.position(0);
                    this._fileChannel.write(byteBuffer, 0L);
                    this._fileBuffer = byteBuffer;
                }
                this._fileBuffer.position(n3);
                this._fileSize = n;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.LogFileHandle.fileExtend", "1266", this);
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Unable to extend file " + this._fileName + " to " + n + " bytes");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "fileExtend", "LogAllocationException");
                }
                throw new LogAllocationException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fileExtend");
        }
    }

    protected void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force", this);
        }
        try {
            if (this._isMapped) {
                ((MappedByteBuffer)this._fileBuffer).force();
            } else {
                this.writePendingToFile();
                this._fileChannel.force(false);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.LogFileHandle.force", "1049", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to force file " + this._fileName);
            }
            if (Configuration.HAEnabled()) {
                if (Configuration.localFailureScope().equals(this._failureScope)) {
                    Tr.error(tc, "CWRLS0024_EXC_DURING_RECOVERY", iOException);
                    RLSHAGroupCallback.terminateServer();
                } else {
                    RecLogServiceImpl.leaveGroup(this._failureScope);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", "InternalLogException");
            }
            throw new InternalLogException(iOException);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogFileHandle.force", "1056", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to force file " + this._fileName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", "InternalLogException");
            }
            throw internalLogException;
        }
        catch (LogIncompatibleException logIncompatibleException) {
            FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.recoverylog.spi.LogFileHandle.force", "1096", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to force file " + this._fileName);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", "InternalLogException");
            }
            throw new InternalLogException(logIncompatibleException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "force");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLogRecord(LogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeLogRecord", logRecord);
        }
        if (!this._isMapped) {
            List list = this._pendingWriteList;
            synchronized (list) {
                this._pendingWriteList.add(logRecord);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeLogRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePendingToFile() throws IOException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writePendingToFile");
        }
        List list = this._pendingWriteList;
        synchronized (list) {
            LogRecord[] logRecordArray = this._pendingWriteList.toArray(new LogRecord[0]);
            if (!Boolean.getBoolean("com.ibm.ws.recoverylog.spi.UseVectoredIO")) {
                ByteBuffer byteBuffer = (ByteBuffer)this._fileBuffer.duplicate().position(0).limit(this._logFileHeader.length());
                this._fileChannel.write(byteBuffer, 0L);
                for (int i = 0; i < logRecordArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Performing write at position " + logRecordArray[i].absolutePosition());
                    }
                    this._fileChannel.write((ByteBuffer)logRecordArray[i]._buffer.flip(), logRecordArray[i].absolutePosition());
                }
            } else {
                int n;
                Arrays.sort(logRecordArray, this._recordComparator);
                ByteBuffer[] byteBufferArray = new ByteBuffer[logRecordArray.length + 1];
                int[] nArray = new int[logRecordArray.length + 1];
                for (n = 0; n < logRecordArray.length; ++n) {
                    byteBufferArray[n + 1] = (ByteBuffer)logRecordArray[n]._buffer.flip();
                    nArray[n + 1] = logRecordArray[n].absolutePosition();
                }
                byteBufferArray[0] = (ByteBuffer)this._fileBuffer.duplicate().position(0).limit(this._logFileHeader.length());
                nArray[0] = 0;
                n = 0;
                while (n < byteBufferArray.length) {
                    int n2 = n;
                    int n3 = n;
                    while (n3 <= byteBufferArray.length - 2) {
                        if (nArray[n3 + 1] != nArray[n3] + byteBufferArray[n3].remaining()) continue;
                        ++n3;
                    }
                    this._fileChannel.position(nArray[n2]);
                    this._fileChannel.write(byteBufferArray, n2, n3 - n2 + 1);
                    n = n3 + 1;
                }
            }
            this._pendingWriteList.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writePendingToFile");
        }
    }

    public void resetHeader(LogFileHandle logFileHandle) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetHeader");
        }
        this._logFileHeader.resetHeader(logFileHandle.logFileHeader());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetHeader");
        }
    }

    public String toString() {
        return "LogFileHandle: " + this._serviceName + " " + this._logName;
    }
}

