/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.GregorianCalendar;

public class LogFileHeader {
    private static final TraceComponent tc = Tr.register(LogFileHeader.class, "Transaction", null);
    static final byte[] MAGIC_NUMBER = new byte[]{87, 65, 83, 76, 79, 71};
    public static final int STATUS_INACTIVE = 2;
    public static final int STATUS_ACTIVE = 4;
    public static final int STATUS_KEYPOINTING = 8;
    public static final int STATUS_INVALID = 16;
    private int _status = 2;
    private int _creatorRLSVersionNumber = 0;
    private long _date = 0L;
    private long _firstRecordSequenceNumber = 0L;
    private String _serverName = null;
    private byte[] _serverNameBytes = null;
    private String _serviceName = null;
    private int _serviceVersion;
    private byte[] _serviceNameBytes = null;
    private String _logName = null;
    private byte[] _logNameBytes = null;
    private byte[] _serviceData = null;
    private boolean _compatible = false;
    private static final int HEADER_SIZE = 66;

    public LogFileHeader(String string, String string2, int n, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogFileHeader", new Object[]{string, string2, new Integer(n), string3});
        }
        this._status = 2;
        this._creatorRLSVersionNumber = 3;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        this._date = date.getTime();
        this._firstRecordSequenceNumber = 0L;
        this._serverName = new String(string);
        this._serverNameBytes = this._serverName.getBytes();
        this._serviceName = new String(string2);
        this._serviceNameBytes = this._serviceName.getBytes();
        this._serviceVersion = n;
        this._logName = new String(string3);
        this._logNameBytes = this._logName.getBytes();
        this._serviceData = null;
        this._compatible = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogFileHeader", this);
        }
    }

    public int length() throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "length");
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "length", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "length", "LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException(null);
        }
        int n = 70 + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length + (this._serviceData != null ? this._serviceData.length : 0);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "length", new Integer(n));
        }
        return n;
    }

    public void write(ByteBuffer byteBuffer, boolean bl) throws InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write", new Object[]{byteBuffer, new Boolean(bl), this});
        }
        if (!this._compatible) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this._status == 16) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "LogHeaderInvalid - throwing InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int n = 0;
            if (bl) {
                n = byteBuffer.position();
            }
            byteBuffer.position(0);
            byteBuffer.putInt(66 + this._serverNameBytes.length + this._serviceNameBytes.length + this._logNameBytes.length);
            byteBuffer.put(MAGIC_NUMBER);
            byteBuffer.putInt(3);
            byteBuffer.putInt(this._status);
            byteBuffer.putLong(this._date);
            byteBuffer.putLong(this._firstRecordSequenceNumber);
            byteBuffer.putInt(this._serverNameBytes.length);
            byteBuffer.put(this._serverNameBytes);
            byteBuffer.putInt(this._serviceNameBytes.length);
            byteBuffer.put(this._serviceNameBytes);
            byteBuffer.putInt(this._serviceVersion);
            byteBuffer.putInt(this._logNameBytes.length);
            byteBuffer.put(this._logNameBytes);
            if (this._serviceData != null) {
                byteBuffer.putInt(this._serviceData.length);
                byteBuffer.put(this._serviceData);
            } else {
                byteBuffer.putInt(0);
            }
            byteBuffer.putLong(this._date);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing FRSN " + this._firstRecordSequenceNumber + " at position " + byteBuffer.position() + " in log file " + this._logName);
            }
            byteBuffer.putLong(this._firstRecordSequenceNumber);
            if (bl) {
                byteBuffer.position(n);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, "com.ibm.ws.recoverylog.spi.LogFileHeader.write", "449", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "InternalLogException");
            }
            throw new InternalLogException(bufferUnderflowException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHeader.write", "455", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
    }

    public boolean read(ByteBuffer byteBuffer) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "read", new Object[]{byteBuffer, this});
        }
        long l = -1L;
        long l2 = -1L;
        int n2 = -1;
        boolean bl = false;
        this._status = 16;
        this._compatible = false;
        try {
            n = byteBuffer.getInt();
            if (n > 0 && n <= byteBuffer.capacity() - byteBuffer.position()) {
                byte[] byArray = new byte[MAGIC_NUMBER.length];
                byteBuffer.get(byArray);
                if (this.validMagicNumber(byArray)) {
                    this._creatorRLSVersionNumber = byteBuffer.getInt();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Recovery log creator version is " + this._creatorRLSVersionNumber);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Current recovery log version is 3");
                    }
                    for (int i = 0; !this._compatible && i < Configuration.COMPATIBLE_RLS_VERSIONS.length; ++i) {
                        if (this._creatorRLSVersionNumber != Configuration.COMPATIBLE_RLS_VERSIONS[i]) continue;
                        this._compatible = true;
                    }
                    if (this._compatible) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This version of recovery log file can be parsed by this level of the RLS");
                        }
                        this._status = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file state is " + LogFileHeader.statusToString(this._status));
                        }
                        this._date = byteBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file date (long) is " + this._date);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file date (date) is " + new Date(this._date).toString());
                        }
                        this._firstRecordSequenceNumber = byteBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file first record sequence number is " + this._firstRecordSequenceNumber);
                        }
                        int n3 = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reading String of length " + n3);
                        }
                        byte[] byArray2 = new byte[n3];
                        byteBuffer.get(byArray2);
                        this._serverName = new String(byArray2);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file created on server " + this._serverName);
                        }
                        n3 = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reading String of length " + n3);
                        }
                        byte[] byArray3 = new byte[n3];
                        byteBuffer.get(byArray3);
                        this._serviceName = new String(byArray3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file created by service " + this._serviceName);
                        }
                        this._serviceVersion = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file created by service version" + this._serviceVersion);
                        }
                        n3 = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reading String of length " + n3);
                        }
                        byte[] byArray4 = new byte[n3];
                        byteBuffer.get(byArray4);
                        this._logName = new String(byArray4);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log name was " + this._logName);
                        }
                        n2 = byteBuffer.getInt();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file contains " + n2 + " bytes of service specific information");
                        }
                        if (n2 > 0) {
                            this._serviceData = new byte[n2];
                            byteBuffer.get(this._serviceData);
                        } else {
                            this._serviceData = null;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Service Specific Information is [" + RLSUtils.toHexString(this._serviceData, 32) + "]");
                        }
                        l = byteBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file check date (long) is " + l);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file check date (date) is " + new Date(l).toString());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Reading FRSN from position " + byteBuffer.position());
                        }
                        l2 = byteBuffer.getLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovery log file check first record sequence number is " + l2);
                        }
                        if (this._date == l && this._firstRecordSequenceNumber == l2 && this._date > 0L) {
                            bl = true;
                        } else {
                            this.changeStatus(16);
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Error processing recovery log file header - integrity check failed");
                            }
                        }
                    } else {
                        this.reset();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "This version of recovery log file can not be parsed by this level of the RLS");
                        }
                    }
                }
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            FFDCFilter.processException((Throwable)bufferUnderflowException, "com.ibm.ws.recoverylog.spi.LogFileHeader.read", "603", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Error processing recovery log file header", bufferUnderflowException.toString());
            }
            this.changeStatus(16);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogFileHeader.read", "609", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Error processing recovery log file header", throwable.toString());
            }
            this.changeStatus(16);
        }
        int n4 = n = this._compatible && bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", new Boolean(n != 0));
        }
        return n;
    }

    private boolean validMagicNumber(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validMagicNumber", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        boolean bl = false;
        for (int i = 0; !bl && i < MAGIC_NUMBER.length; ++i) {
            if (byArray[i] == MAGIC_NUMBER[i]) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validMagicNumber", new Boolean(!bl));
        }
        return !bl;
    }

    public long date() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "date", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "date", new Long(this._date));
        }
        return this._date;
    }

    public long firstRecordSequenceNumber() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "firstRecordSequenceNumber", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "firstRecordSequenceNumber", new Long(this._firstRecordSequenceNumber));
        }
        return this._firstRecordSequenceNumber;
    }

    public String serverName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverName", this._serverName);
        }
        return this._serverName;
    }

    public String serviceName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serviceName", this._serviceName);
        }
        return this._serviceName;
    }

    public int serviceVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceVersion", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serviceVersion", new Integer(this._serviceVersion));
        }
        return this._serviceVersion;
    }

    public String logName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logName", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logName", this._logName);
        }
        return this._logName;
    }

    public byte[] getServiceData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceData", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceData", RLSUtils.toHexString(this._serviceData, 32));
        }
        return this._serviceData;
    }

    public void setServiceData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceData", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        this._serviceData = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceData");
        }
    }

    public boolean compatible() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compatible", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compatible", new Boolean(this._compatible));
        }
        return this._compatible;
    }

    public int status() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "status", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "status", new Integer(this._status));
        }
        return this._status;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset", this);
        }
        this._status = 4;
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = null;
        this._serviceName = null;
        this._serviceVersion = 0;
        this._logName = null;
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public void resetHeader(LogFileHeader logFileHeader) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetHeader", this);
        }
        this._date = 0L;
        this._firstRecordSequenceNumber = 0L;
        this._serverName = logFileHeader.serverName();
        this._serviceName = logFileHeader.serviceName();
        this._logName = logFileHeader.logName();
        this._serviceData = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetHeader");
        }
    }

    public void changeStatus(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeStatus", new Object[]{this, new Integer(n)});
        }
        this._status = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeStatus");
        }
    }

    public void keypointStarting(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointStarting", new Object[]{this, new Long(l)});
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        this._date = date.getTime();
        this._firstRecordSequenceNumber = l;
        this._status = 8;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointStarting");
        }
    }

    public void keypointComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointComplete", this);
        }
        this._status = 4;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointComplete");
        }
    }

    static String statusToString(int n) {
        String string = null;
        string = n == 2 ? "INACTIVE" : (n == 4 ? "ACTIVE" : (n == 8 ? "KEYPOINTING" : (n == 16 ? "INVALID" : "UNKNOWN")));
        return string;
    }
}

