/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogFileHandle;
import com.ibm.ws.recoverylog.spi.LogFileHeader;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.LogRecord;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RLSControllerImpl;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.WriteOperationFailedException;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.util.ArrayList;

class LogHandle {
    private static final TraceComponent tc = Tr.register(LogHandle.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static String RECOVERY_FILE_1_NAME = "log1";
    private static String RECOVERY_FILE_2_NAME = "log2";
    private MultiScopeRecoveryLog _recoveryLog = null;
    private String _serviceName = null;
    private int _serviceVersion = 0;
    private String _serverName = null;
    private String _logName = null;
    private String _logDirectory = null;
    private int _logFileSize = 0;
    private int _maxLogFileSize = 0;
    private LogFileHandle _file1 = null;
    private LogFileHandle _file2 = null;
    private LogFileHandle _activeFile = null;
    private LogFileHandle _inactiveFile = null;
    private long _recordSequenceNumber = 0L;
    private ArrayList _recoveredRecords = null;
    public int _physicalFreeBytes = 0;
    private byte[] _serviceData = null;
    FailureScope _failureScope = null;

    LogHandle(MultiScopeRecoveryLog multiScopeRecoveryLog, String string, int n, String string2, String string3, String string4, int n2, int n3, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogHandle", new Object[]{multiScopeRecoveryLog, string, new Integer(n), string2, string3, string4, new Integer(n2), new Integer(n3), failureScope});
        }
        this._recoveryLog = multiScopeRecoveryLog;
        this._serviceName = string;
        this._serviceVersion = n;
        this._serverName = string2;
        this._logName = string3;
        this._logDirectory = string4;
        this._maxLogFileSize = n3;
        this._logFileSize = n2;
        this._failureScope = failureScope;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogHandle", this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void openLog() throws LogOpenException, LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        block71: {
            block74: {
                long l;
                long l2;
                block77: {
                    block76: {
                        long l3;
                        long l4;
                        block75: {
                            int n;
                            int n2;
                            block73: {
                                block72: {
                                    boolean bl;
                                    if (tc.isEntryEnabled()) {
                                        Tr.entry(tc, "openLog", this);
                                    }
                                    if (this._activeFile != null) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "LogOpenException");
                                        }
                                        throw new LogOpenException(null);
                                    }
                                    if (!RLSUtils.createDirectoryTree(this._logDirectory)) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "LogAllocationException");
                                        }
                                        throw new LogAllocationException(null);
                                    }
                                    String string = System.getProperty("os.name");
                                    if (string.equalsIgnoreCase("HPUX") || string.equalsIgnoreCase("HP-UX")) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Running on HP-UX, open logs with initial size of maximum log size");
                                        }
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._maxLogFileSize, this._failureScope);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._maxLogFileSize, this._failureScope);
                                    } else {
                                        this._file1 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_1_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._logFileSize, this._failureScope);
                                        this._file2 = new LogFileHandle(this._logDirectory, RECOVERY_FILE_2_NAME, this._serverName, this._serviceName, this._serviceVersion, this._logName, this._logFileSize, this._failureScope);
                                    }
                                    this._activeFile = null;
                                    this._inactiveFile = null;
                                    if (this._file1.fileExists() != this._file2.fileExists()) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event(tc, "One of the recovery log files has been deleted. Recovery can't complete");
                                        }
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "LogCorruptedException");
                                        }
                                        throw new LogCorruptedException(null);
                                    }
                                    boolean bl2 = bl = !this._file1.fileExists();
                                    if (bl) {
                                        this._file1.becomeActive();
                                        Tr.info(tc, "CWRLS0007_RECOVERY_LOG_NOT_EXIST", this._logDirectory);
                                    }
                                    try {
                                        this._file1.fileOpen();
                                    }
                                    catch (LogIncompatibleException logIncompatibleException) {
                                        FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "391", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", logIncompatibleException);
                                        }
                                        throw logIncompatibleException;
                                    }
                                    catch (InternalLogException internalLogException) {
                                        FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "331", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", internalLogException);
                                        }
                                        throw internalLogException;
                                    }
                                    catch (LogAllocationException logAllocationException) {
                                        FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "339", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", logAllocationException);
                                        }
                                        throw logAllocationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "347", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "InternalLogException");
                                        }
                                        throw new InternalLogException(throwable);
                                    }
                                    try {
                                        this._file2.fileOpen();
                                    }
                                    catch (LogIncompatibleException logIncompatibleException) {
                                        FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "449", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", logIncompatibleException);
                                        }
                                        throw logIncompatibleException;
                                    }
                                    catch (InternalLogException internalLogException) {
                                        FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "369", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", internalLogException);
                                        }
                                        throw internalLogException;
                                    }
                                    catch (LogAllocationException logAllocationException) {
                                        FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "377", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", logAllocationException);
                                        }
                                        throw logAllocationException;
                                    }
                                    catch (Throwable throwable) {
                                        FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "385", this);
                                        this._file1 = null;
                                        this._file2 = null;
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "InternalLogException");
                                        }
                                        throw new InternalLogException(throwable);
                                    }
                                    if (this._file1 == null || this._file2 == null) {
                                        if (tc.isEventEnabled()) {
                                            Tr.event(tc, "Neither of the recovery log files are valid. Recovery can't complete");
                                        }
                                        if (tc.isEntryEnabled()) {
                                            Tr.exit(tc, "openLog", "LogCorruptedException");
                                        }
                                        throw new LogCorruptedException(null);
                                    }
                                    if (this._file2.logFileHeader().status() == 16) {
                                        if (this._file1.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event(tc, "Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not valid");
                                            }
                                            this._activeFile = this._file1;
                                            this._inactiveFile = this._file2;
                                            this._inactiveFile.resetHeader(this._activeFile);
                                            break block71;
                                        } else {
                                            if (tc.isEventEnabled()) {
                                                Tr.event(tc, "The only valid recovery log file '" + this._file1.fileName() + "' is not in ACTIVE state");
                                            }
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit(tc, "openLog", "LogCorruptedException");
                                            }
                                            throw new LogCorruptedException(null);
                                        }
                                    }
                                    if (this._file1.logFileHeader().status() == 16) {
                                        if (this._file2.logFileHeader().status() == 4) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event(tc, "Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not valid");
                                            }
                                            this._activeFile = this._file2;
                                            this._inactiveFile = this._file1;
                                            this._inactiveFile.resetHeader(this._activeFile);
                                            break block71;
                                        } else {
                                            if (tc.isEventEnabled()) {
                                                Tr.event(tc, "The only valid recovery log file '" + this._file2.fileName() + "' is not in ACTIVE state");
                                            }
                                            this._file1 = null;
                                            this._file2 = null;
                                            if (tc.isEntryEnabled()) {
                                                Tr.exit(tc, "openLog", "LogCorruptedException");
                                            }
                                            throw new LogCorruptedException(null);
                                        }
                                    }
                                    n2 = this._file1.logFileHeader().status();
                                    n = this._file2.logFileHeader().status();
                                    l2 = this._file1.logFileHeader().firstRecordSequenceNumber();
                                    l = this._file2.logFileHeader().firstRecordSequenceNumber();
                                    l4 = this._file1.logFileHeader().date();
                                    l3 = this._file2.logFileHeader().date();
                                    if (n2 != 4 || n == 4) break block72;
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "Selecting recovery log file '" + this._file1.fileName() + "' as its ACTIVE and '" + this._file2.fileName() + "' is not ACTIVE");
                                    }
                                    this._activeFile = this._file1;
                                    this._inactiveFile = this._file2;
                                    break block71;
                                }
                                if (n2 == 4 || n != 4) break block73;
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Selecting recovery log file '" + this._file2.fileName() + "' as its ACTIVE and '" + this._file1.fileName() + "' is not ACTIVE");
                                }
                                this._activeFile = this._file2;
                                this._inactiveFile = this._file1;
                                break block71;
                            }
                            if (n2 != 4 || n != 4) break block74;
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Both recovery files are in ACTIVE state. Determine target file by examining timestamp");
                            }
                            if (l4 <= l3) break block75;
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Selecting recovery log file '" + this._file1.fileName() + "' as it was created after '" + this._file2.fileName() + "'");
                            }
                            this._activeFile = this._file1;
                            this._inactiveFile = this._file2;
                            break block71;
                        }
                        if (l4 >= l3) break block76;
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Selecting recovery log file '" + this._file2.fileName() + "' as it was created after '" + this._file1.fileName() + "'");
                        }
                        this._activeFile = this._file2;
                        this._inactiveFile = this._file1;
                        break block71;
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Both recovery files have the same timestamp. Determine target file by examining first record sequence numbers");
                    }
                    if (l2 != 0L || l != 0L) break block77;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Selecting recovery log file '" + this._file1.fileName() + "' as both files are empty");
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block71;
                }
                if (l2 > l) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Selecting recovery log file '" + this._file1.fileName() + "' as it has as the highest record sequence number");
                    }
                    this._activeFile = this._file1;
                    this._inactiveFile = this._file2;
                    break block71;
                } else if (l2 < l) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Selecting recovery log file '" + this._file2.fileName() + "' as it has as the highest record sequence number");
                    }
                    this._activeFile = this._file2;
                    this._inactiveFile = this._file1;
                    break block71;
                } else {
                    this._file1 = null;
                    this._file2 = null;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Neither of the recovery log files are valid as they have the same record sequence number. Recovery can't complete");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "openLog", "LogCorruptedException");
                    }
                    throw new LogCorruptedException(null);
                }
            }
            this._file1 = null;
            this._file2 = null;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The recovery lof files are in an undefined state");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openLog", "LogCorruptedException");
            }
            throw new LogCorruptedException(null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Selected log file '" + this._activeFile.fileName() + "' for recovery");
        }
        this._serviceData = this._activeFile.getServiceData();
        if (this._activeFile == this._file1) {
            this._file2.setServiceData(this._serviceData);
        } else {
            this._file1.setServiceData(this._serviceData);
        }
        try {
            this._recoveredRecords = this.readRecords();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "554", this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openLog", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.openLog", "565", this);
            this._file1 = null;
            this._file2 = null;
            this._activeFile = null;
            this._inactiveFile = null;
            this._recoveredRecords = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openLog", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openLog");
        }
    }

    private ArrayList readRecords() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readRecords", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "readRecords", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        ArrayList<ReadableLogRecord> arrayList = null;
        this._recordSequenceNumber = this._activeFile.logFileHeader().firstRecordSequenceNumber();
        ReadableLogRecord readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        if (readableLogRecord != null) {
            arrayList = new ArrayList<ReadableLogRecord>();
        }
        while (readableLogRecord != null) {
            arrayList.add(readableLogRecord);
            ++this._recordSequenceNumber;
            readableLogRecord = this._activeFile.getReadableLogRecord(this._recordSequenceNumber);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Next record sequence number is " + this._recordSequenceNumber);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readRecords", arrayList);
        }
        return arrayList;
    }

    void keypointStarting() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointStarting", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointStarting", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._activeFile == this._file1) {
            this._activeFile = this._file2;
            this._inactiveFile = this._file1;
        } else {
            this._activeFile = this._file1;
            this._inactiveFile = this._file2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Keypoint processing is switching to log file " + this._activeFile.fileName());
        }
        try {
            this._activeFile.keypointStarting(this._recordSequenceNumber);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", "690", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointStarting", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.keypointStarting", "696", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointStarting", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointStarting");
        }
    }

    void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeLog", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            this._file1.fileClose();
            this._file2.fileClose();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.closeLog", "736", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeLog", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.closeLog", "742", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "closeLog", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        this._file1 = null;
        this._file2 = null;
        this._activeFile = null;
        this._recoveredRecords = null;
        this._physicalFreeBytes = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLog");
        }
    }

    byte[] getServiceData() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServiceData", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServiceData", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        byte[] byArray = this._activeFile.getServiceData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServiceData", RLSUtils.toHexString(byArray, 32));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        Object object = RLSControllerImpl.SUSPEND_LOCK;
        synchronized (object) {
            while (RLSControllerImpl.isSuspended()) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for RecoveryLogService to resume");
                    }
                    RLSControllerImpl.SUSPEND_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.LogHandle.force", "834", this);
                }
            }
            if (Configuration._isSnapshotSafe) {
                this._activeFile.force();
            }
        }
        if (!Configuration._isSnapshotSafe) {
            this._activeFile.force();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "force");
        }
    }

    LogFileHeader logFileHeader() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logFileHeader", this);
        }
        if (this._activeFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "logFileHeader", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        LogFileHeader logFileHeader = this._activeFile.logFileHeader();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logFileHeader", logFileHeader);
        }
        return logFileHeader;
    }

    ArrayList recoveredRecords() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveredRecords", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveredRecords", this._recoveredRecords);
        }
        return this._recoveredRecords;
    }

    void setServiceData(byte[] byArray) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServiceData", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        if (this._file1 == null || this._file2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setServiceData", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._serviceData = byArray;
        this._file1.setServiceData(byArray);
        this._file2.setServiceData(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServiceData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keypoint() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypoint", this);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe);
            }
            Object object = RLSControllerImpl.SUSPEND_LOCK;
            synchronized (object) {
                while (RLSControllerImpl.isSuspended()) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for RecoveryLogService to resume");
                        }
                        RLSControllerImpl.SUSPEND_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.LogHandle.keypoint", "923", this);
                    }
                }
                if (Configuration._isSnapshotSafe) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe);
                    }
                    this.keypointInternal();
                }
            }
            if (!Configuration._isSnapshotSafe) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keypointing with isSnapshotSafe set to " + Configuration._isSnapshotSafe);
                }
                this.keypointInternal();
            }
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.keypoint", "932", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", internalLogException);
            }
            throw internalLogException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypoint");
        }
    }

    private void keypointInternal() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypointInternal");
        }
        try {
            this.force();
            this._activeFile.keypointComplete();
            if (this._activeFile == this._file1) {
                this._file2.becomeInactive();
            } else {
                this._file1.becomeInactive();
            }
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.keypointInternal", "952", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointInternal", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.keypointInternal", "958", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypointInternal", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypointInternal");
        }
    }

    void resizeLog(int n) throws InternalLogException, LogFullException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resizeLog", new Object[]{this, new Integer(n)});
        }
        if (this._activeFile == null || this._inactiveFile == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resizeLog", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            this._file1.fileExtend(n);
            this._file2.fileExtend(n);
        }
        catch (LogAllocationException logAllocationException) {
            FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", "1612", this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resizeLog", "WriteOperationFailedException");
            }
            throw new WriteOperationFailedException(logAllocationException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.LogHandle.resizeLog", "1555", this);
            this._activeFile = this._activeFile == this._file1 ? this._file2 : this._file1;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resizeLog", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        this._physicalFreeBytes = this._activeFile.freeBytes();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Log file " + this._activeFile.fileName() + " now has " + this._physicalFreeBytes + " bytes of storage available");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resizeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WriteableLogRecord getWriteableLogRecord(int n) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWriteableLogRecord", new Object[]{this, new Integer(n)});
        }
        WriteableLogRecord writeableLogRecord = null;
        boolean bl = false;
        LogHandle logHandle = this;
        synchronized (logHandle) {
            if (this._activeFile.freeBytes() < n + WriteableLogRecord.HEADER_SIZE) {
                bl = true;
            } else {
                try {
                    writeableLogRecord = this._activeFile.getWriteableLogRecord(n, this._recordSequenceNumber++);
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", "1112", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getWriteableLogRecord", internalLogException);
                    }
                    throw internalLogException;
                }
            }
        }
        if (bl) {
            try {
                this._recoveryLog.keypoint();
            }
            catch (LogClosedException logClosedException) {
                FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", "1129", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWriteableLogRecord", "InternalLogException");
                }
                throw new InternalLogException(logClosedException);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", "1135", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWriteableLogRecord", internalLogException);
                }
                throw internalLogException;
            }
            catch (LogIncompatibleException logIncompatibleException) {
                FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.recoverylog.spi.LogHandle.getWriteableLogRecord", "1204", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getWriteableLogRecord", logIncompatibleException);
                }
                throw new InternalLogException(logIncompatibleException);
            }
            writeableLogRecord = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWriteableLogRecord", writeableLogRecord);
        }
        return writeableLogRecord;
    }

    protected int getFreeSpace() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFreeSpace", this);
        }
        int n = this._activeFile.freeBytes();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFreeSpace", new Integer(n));
        }
        return n;
    }

    protected void writeLogRecord(LogRecord logRecord) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeLogRecord", logRecord);
        }
        this._activeFile.writeLogRecord(logRecord);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeLogRecord");
        }
    }
}

