/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import java.nio.ByteBuffer;

public abstract class LogRecord {
    private static final TraceComponent tc = Tr.register(LogRecord.class, "Transaction", null);
    protected static final byte TRUE = 1;
    protected static final byte FALSE = 0;
    protected ByteBuffer _buffer = null;
    private int _absolutePosition;
    protected static final byte[] RECORD_MAGIC_NUMBER = new byte[]{82, 67, 82, 68};
    public static final int HEADER_SIZE = RECORD_MAGIC_NUMBER.length + 8 + 4 + 8;

    protected LogRecord(ByteBuffer byteBuffer, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "LogRecord", new Object[]{byteBuffer, new Integer(n)});
        }
        this._buffer = byteBuffer;
        this._absolutePosition = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "LogRecord", this);
        }
    }

    protected int position() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "position", this);
        }
        int n = this._absolutePosition + this._buffer.position();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "position", new Integer(n));
        }
        return n;
    }

    protected void position(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "position", new Object[]{this, new Integer(n)});
        }
        this._buffer.position(n -= this._absolutePosition);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "position");
        }
    }

    protected int absolutePosition() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "absolutePosition", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "absolutePosition", new Integer(this._absolutePosition));
        }
        return this._absolutePosition;
    }

    protected void advancePosition(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "advancePosition", new Object[]{this, new Integer(n)});
        }
        int n2 = this._buffer.position() + n;
        this._buffer.position(n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Buffer's position now " + n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "advancePosition");
        }
    }

    protected void get(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", new Object[]{this, new Integer(byArray.length)});
        }
        this._buffer.get(byArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, RLSUtils.toHexString(byArray, 32));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get");
        }
    }

    protected int getInt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInt", this);
        }
        int n = this._buffer.getInt();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInt", new Integer(n));
        }
        return n;
    }

    protected long getLong() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLong", this);
        }
        long l = this._buffer.getLong();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLong", new Long(l));
        }
        return l;
    }

    protected short getShort() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getShort", this);
        }
        short s = this._buffer.getShort();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getShort", new Short(s));
        }
        return s;
    }

    protected boolean getBoolean() {
        byte by;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoolean", this);
        }
        boolean bl2 = bl = (by = this._buffer.get()) == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoolean", new Boolean(bl));
        }
        return bl;
    }
}

