/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorCallback;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogFullException;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogOpenException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.utils.DirUtils;
import com.ibm.ws.recoverylog.utils.RecoverableUnitIdTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class MultiScopeRecoveryLog
implements LogCursorCallback {
    private static final TraceComponent tc = Tr.register(MultiScopeRecoveryLog.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static int DEFAULT_LOGFILE_SIZE = 1024;
    private static final int MIN_LOGFILE_SIZE = 8;
    private static final int LOCK_REQUEST_ID_MSRL_CREATE = 1;
    private static final int LOCK_REQUEST_ID_MSRL_REMOVE = 2;
    protected static final int MEMORY_BACKED = 1;
    protected static final int FILE_BACKED = 2;
    protected static final int IN_MEMORY_MAXIMUM = 5120;
    private static float TOTAL_DATA_RESIZE_TRIGGER = 0.95f;
    private static float TOTAL_DATA_RESIZE_MULTIPLIER = 1.25f;
    private RecoveryAgent _recoveryAgent = null;
    private String _clientName = null;
    private int _clientVersion = 0;
    private String _logName = null;
    private int _logIdentifier = 0;
    private String _serverName = null;
    private String _logDirectory = null;
    private int _logFileSize = 0;
    private int _maxLogFileSize = 0;
    private HashMap _recoverableUnits;
    private LogHandle _logHandle = null;
    private Lock _controlLock = null;
    private int _closesRequired = 0;
    private static String _fileSeparator = null;
    private FileLogProperties _fileLogProperties = null;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private int _storageMode = 1;
    private boolean _failed = false;
    private boolean _incompatible = false;
    private boolean _logWarningIssued;
    private static final int LOG_WARNING_FACTOR = 3;
    private RecoverableUnitIdTable _recUnitIdTable = new RecoverableUnitIdTable();
    private String _traceId;
    private boolean _bypassContainmentCheck = false;
    FailureScope _failureScope = null;

    MultiScopeRecoveryLog(FileLogProperties fileLogProperties, RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiScopeRecoveryLog", new Object[]{fileLogProperties, recoveryAgent, failureScope});
        }
        this._fileLogProperties = fileLogProperties;
        this._recoveryAgent = recoveryAgent;
        this._logName = this._fileLogProperties.logName();
        this._logIdentifier = this._fileLogProperties.logIdentifier();
        this._logDirectory = this._fileLogProperties.logDirectory();
        this._logFileSize = this._fileLogProperties.logFileSize();
        this._maxLogFileSize = this._fileLogProperties.maxLogFileSize();
        this._clientName = recoveryAgent.clientName();
        this._clientVersion = recoveryAgent.clientVersion();
        this._serverName = failureScope.serverName();
        this._failureScope = failureScope;
        if (_fileSeparator == null) {
            _fileSeparator = System.getProperty("file.separator");
        }
        if (this._logDirectory == null) {
            this._logDirectory = Configuration.WASInstallDirectory() + _fileSeparator + "recoveryLogs" + _fileSeparator + DirUtils.createDirectoryPath(this._serverName) + _fileSeparator + this._clientName + _fileSeparator + this._logName;
        }
        if (this._logFileSize == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default values for log file size and maximum size");
            }
            this._logFileSize = DEFAULT_LOGFILE_SIZE;
            this._maxLogFileSize = DEFAULT_LOGFILE_SIZE;
        }
        if (this._logFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log file size is too small. Enforcing minimum size");
            }
            this._logFileSize = 8;
        }
        if (this._maxLogFileSize < 8) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log file maximum size is too small. Enforcing minimum size");
            }
            this._maxLogFileSize = 8;
        }
        if (this._logFileSize > this._maxLogFileSize) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Log file size is greater than maximum. Constraining log file size");
            }
            this._logFileSize = this._maxLogFileSize;
        }
        String string = "serverName=" + this._serverName + ":" + "clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "logName=" + this._logName + ":" + "logIdentifier=" + this._logIdentifier;
        this._controlLock = new Lock(string);
        if (this._maxLogFileSize >= 5120) {
            this._storageMode = 2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using a 'retain only on disk' model for forced log data");
            }
        } else {
            this._storageMode = 1;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using a 'retain in memory' model for forced log data");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Recovery log belongs to server " + this._serverName);
            Tr.debug(tc, "Recovery log created by client service " + this._clientName + " at version " + this._clientVersion);
            Tr.debug(tc, "Recovery log name is " + this._logName);
            Tr.debug(tc, "Recovery log identifier is " + this._logIdentifier);
            Tr.debug(tc, "Recovery log directory is " + this._logDirectory);
            Tr.debug(tc, "Recovery log file size is " + this._logFileSize);
            Tr.debug(tc, "Recovery log file size is " + this._maxLogFileSize);
        }
        this._traceId = "MultiScopeRecoveryLog:serverName=" + this._serverName + ":" + "clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "logName=" + this._logName + ":" + "logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        boolean bl = this._bypassContainmentCheck = !Configuration.HAEnabled() && !Configuration.isZOS();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_bypassContainmentCheck = " + this._bypassContainmentCheck);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiScopeRecoveryLog", this);
        }
    }

    public synchronized void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openLog", this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openLog", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "openLog", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            this._logHandle = new LogHandle(this, this._clientName, this._clientVersion, this._serverName, this._logName, this._logDirectory, this._logFileSize, this._maxLogFileSize, this._failureScope);
            this._recoverableUnits = new HashMap();
            try {
                this._logHandle.openLog();
            }
            catch (LogOpenException logOpenException) {
                FFDCFilter.processException((Throwable)logOpenException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "464", this);
                this.markFailed(logOpenException);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", "InternalLogException");
                }
                throw new InternalLogException(logOpenException);
            }
            catch (LogCorruptedException logCorruptedException) {
                FFDCFilter.processException((Throwable)logCorruptedException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "473", this);
                this.markFailed(logCorruptedException);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", logCorruptedException);
                }
                throw logCorruptedException;
            }
            catch (LogIncompatibleException logIncompatibleException) {
                this.markIncompatible();
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", logIncompatibleException);
                }
                throw logIncompatibleException;
            }
            catch (LogAllocationException logAllocationException) {
                FFDCFilter.processException((Throwable)logAllocationException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "482", this);
                this.markFailed(logAllocationException);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", logAllocationException);
                }
                throw logAllocationException;
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "491", this);
                this.markFailed(internalLogException);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", internalLogException);
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "500", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unexpected exception caught in openLog", throwable);
                }
                this.markFailed(throwable);
                this._logHandle = null;
                this._recoverableUnits = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "openLog", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            ArrayList arrayList = this._logHandle.recoveredRecords();
            if (arrayList != null && arrayList.size() > 0) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MultiScopeRecoveryLog " + this._logName + " contains " + arrayList.size() + " records to recover");
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ReadableLogRecord readableLogRecord = (ReadableLogRecord)arrayList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Recovering record " + i);
                        }
                        RecoverableUnitImpl.recover(this, readableLogRecord, this._logHandle, this._storageMode, this._controlLock);
                    }
                }
                catch (LogCorruptedException logCorruptedException) {
                    FFDCFilter.processException((Throwable)logCorruptedException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "531", this);
                    this.markFailed(logCorruptedException);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A LogCorruptedException exception occured when reconstructng a RecoverableUnit");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "openLog", logCorruptedException);
                    }
                    throw logCorruptedException;
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "541", this);
                    this.markFailed(internalLogException);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "An InternalLogException exception occured when reconstructng a RecoverableUnit");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "openLog", internalLogException);
                    }
                    throw internalLogException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.openLog", "551", this);
                    this.markFailed(throwable);
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "An exception occured reconstructng a RecoverableUnit", throwable);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "openLog", "InternalLogException");
                    }
                    throw new InternalLogException(throwable);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MultiScopeRecoveryLog " + this._logName + " is empty");
            }
        }
        ++this._closesRequired;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Closes required: " + this._closesRequired);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openLog");
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceData", this);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serviceData", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        byte[] byArray = null;
        try {
            byArray = this._logHandle.getServiceData();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.serviceData", "609", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serviceData", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.serviceData", "615", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serviceData", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serviceData", RLSUtils.toHexString(byArray2, 32));
        }
        return byArray2;
    }

    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete", this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        try {
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "686", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", logClosedException);
            }
            throw logClosedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "692", this);
            this.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "699", this);
            this.markFailed(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    public void recoveryComplete(byte[] byArray) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        byte[] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        try {
            this._logHandle.setServiceData(byArray2);
            this.keypoint();
        }
        catch (LogClosedException logClosedException) {
            FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "785", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", logClosedException);
            }
            throw logClosedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "791", this);
            this.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.recoveryComplete", "798", this);
            this.markFailed(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryComplete", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    public void closeLog(byte[] byArray) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        if (this._logHandle != null) {
            try {
                this._logHandle.setServiceData(byArray);
                this.closeLog();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "870", this);
                this.markFailed(internalLogException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeLog", internalLogException);
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "877", this);
                this.markFailed(throwable);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeLog", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", this);
        }
        if (this._logHandle != null) {
            if (!this.failed() && !this.incompatible()) {
                try {
                    this.keypoint();
                }
                catch (LogClosedException logClosedException) {
                    FFDCFilter.processException((Throwable)logClosedException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "944", this);
                }
                catch (InternalLogException internalLogException) {
                    FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "948", this);
                    this.markFailed(internalLogException);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeLog", internalLogException);
                    }
                    throw internalLogException;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "955", this);
                    this.markFailed(throwable);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "closeLog", "InternalLogException");
                    }
                    throw new InternalLogException(throwable);
                }
            }
            MultiScopeRecoveryLog multiScopeRecoveryLog = this;
            synchronized (multiScopeRecoveryLog) {
                --this._closesRequired;
                if (this._closesRequired <= 0) {
                    try {
                        this._logHandle.closeLog();
                    }
                    catch (InternalLogException internalLogException) {
                        FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "974", this);
                        this.markFailed(internalLogException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "closeLog", internalLogException);
                        }
                        throw internalLogException;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLog", "981", this);
                        this.markFailed(throwable);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "closeLog", "InternalLogException");
                        }
                        throw new InternalLogException(throwable);
                    }
                    this._logHandle = null;
                    this._recoverableUnits = null;
                    this._closesRequired = 0;
                    this._unwrittenDataSize = 0;
                    this._totalDataSize = 0;
                    this._failed = false;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Closes required: " + this._closesRequired);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLog");
        }
    }

    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLogImmediate", this);
        }
        if (this._logHandle != null) {
            try {
                this._logHandle.closeLog();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLogImmediate", "1173", this);
                this.markFailed(internalLogException);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeLogImmediate", internalLogException);
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.closeLogImmediate", "1180", this);
                this.markFailed(throwable);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "closeLogImmediate", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            this._logHandle = null;
            this._recoverableUnits = null;
            this._closesRequired = 0;
            this._unwrittenDataSize = 0;
            this._totalDataSize = 0;
            this._failed = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLogImmediate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoverableUnit createRecoverableUnit(FailureScope failureScope) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRecoverableUnit", new Object[]{failureScope, this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnit", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnit", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnit", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        RecoverableUnitImpl recoverableUnitImpl = null;
        this._controlLock.getSharedLock(1);
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            long l = this._recUnitIdTable.nextId(this);
            recoverableUnitImpl = new RecoverableUnitImpl(this, l, failureScope, this._logHandle, this._storageMode, this._controlLock);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "MultiScopeRecoveryLog '" + this._logName + "' created a new RecoverableUnit with id '" + l + "'");
            }
        }
        try {
            this._controlLock.releaseSharedLock(1);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.createRecoverableUnit", "1070", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnit", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.createRecoverableUnit", "1076", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createRecoverableUnit", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRecoverableUnit", recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecoverableUnit(long l) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoverableUnit", new Object[]{new Long(l), this});
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        this._controlLock.getSharedLock(2);
        RecoverableUnitImpl recoverableUnitImpl = null;
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            recoverableUnitImpl = this.removeRecoverableUnitMapEntries(l);
        }
        if (recoverableUnitImpl == null) {
            try {
                this._controlLock.releaseSharedLock(2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", "1165", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", "InvalidRecoverableUnitException");
            }
            throw new InvalidRecoverableUnitException(null);
        }
        try {
            recoverableUnitImpl.remove();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", "1182", this);
            this.markFailed(internalLogException);
            try {
                this._controlLock.releaseSharedLock(2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", "1195", this);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", internalLogException);
            }
            throw internalLogException;
        }
        try {
            this._controlLock.releaseSharedLock(2);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", "1212", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removeRecoverableUnit", "1218", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removeRecoverableUnit", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoverableUnit");
        }
    }

    public synchronized LogCursor recoverableUnits(FailureScope failureScope) throws LogClosedException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverableUnits", new Object[]{failureScope, this});
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoverableUnits", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        ArrayList<RecoverableUnitImpl> arrayList = new ArrayList<RecoverableUnitImpl>();
        Iterator iterator = this._recoverableUnits.values().iterator();
        while (iterator.hasNext()) {
            object = (RecoverableUnitImpl)iterator.next();
            if (!this._bypassContainmentCheck && !((RecoverableUnitImpl)object).failureScope().isContainedBy(failureScope)) continue;
            arrayList.add((RecoverableUnitImpl)object);
        }
        object = new LogCursorImpl(this._controlLock, arrayList, true, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoverableUnits", object);
        }
        return object;
    }

    public LogProperties logProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logProperties", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logProperties", this._fileLogProperties);
        }
        return this._fileLogProperties;
    }

    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypoint", this);
        }
        if (this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", "LogIncompatibleException");
            }
            throw new LogIncompatibleException();
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", "LogClosedException");
            }
            throw new LogClosedException(null);
        }
        boolean bl = false;
        try {
            bl = this._controlLock.attemptExclusiveLock();
        }
        catch (HoldingExclusiveLockException holdingExclusiveLockException) {
            FFDCFilter.processException((Throwable)holdingExclusiveLockException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1353", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The keypoint operation has triggered a keypoint operation.");
            }
            this.markFailed(holdingExclusiveLockException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", "InternalLogException");
            }
            throw new InternalLogException(holdingExclusiveLockException);
        }
        if (bl) {
            int n;
            try {
                this._logHandle.keypointStarting();
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1373", this);
                this.markFailed(internalLogException);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1384", this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "keypoint", internalLogException);
                }
                throw internalLogException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1392", this);
                this.markFailed(throwable);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException(throwable2, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1403", this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "keypoint", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            if (tc.isDebugEnabled()) {
                n = this._logHandle.getFreeSpace();
                Tr.debug(tc, "Recovery log contains " + this._totalDataSize + " payload bytes");
                Tr.debug(tc, "Target keypoint file has " + n + " available free bytes");
                Tr.debug(tc, "Resize trigger constant is " + TOTAL_DATA_RESIZE_TRIGGER);
                Tr.debug(tc, "Resize trigger value is " + (float)n * TOTAL_DATA_RESIZE_TRIGGER + " bytes");
            }
            if ((float)this._totalDataSize > (float)this._logHandle.getFreeSpace() * TOTAL_DATA_RESIZE_TRIGGER) {
                try {
                    n = this._logHandle.logFileHeader().length();
                }
                catch (InternalLogException internalLogException) {
                    if (tc.isEventEnabled()) {
                        Tr.debug(tc, "Could not get log file header length", internalLogException);
                    }
                    FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", "1780", this);
                    this.markFailed(internalLogException);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", "1791", this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "keypoint");
                    }
                    throw internalLogException;
                }
                catch (LogIncompatibleException logIncompatibleException) {
                    FFDCFilter.processException((Throwable)logIncompatibleException, "com.ibm.ws.recoverylog.spi.RecoveryLogImpl.keypoint", "1575", this);
                    this.markFailed(logIncompatibleException);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "keypoint");
                    }
                    throw new InternalLogException(logIncompatibleException);
                }
                int n2 = Math.min((int)((float)this._totalDataSize * TOTAL_DATA_RESIZE_MULTIPLIER), this._maxLogFileSize * 1024 - n);
                if (n2 < this._totalDataSize) {
                    LogFullException logFullException = new LogFullException(null);
                    this.markFailed(logFullException);
                    try {
                        this._controlLock.releaseExclusiveLock();
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1446", this);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "keypoint", "LogFullException");
                    }
                    throw logFullException;
                }
                this._logHandle.resizeLog(n2);
            }
            try {
                Iterator iterator = this._recoverableUnits.values().iterator();
                while (iterator.hasNext()) {
                    RecoverableUnitImpl recoverableUnitImpl = (RecoverableUnitImpl)iterator.next();
                    recoverableUnitImpl.writeSections(true);
                }
                this._logHandle.keypoint();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1478", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception caught performing keypoint", throwable);
                }
                this.markFailed(throwable);
                try {
                    this._controlLock.releaseExclusiveLock();
                }
                catch (Throwable throwable3) {
                    FFDCFilter.processException(throwable3, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1491", this);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "keypoint", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            if (!this._logWarningIssued && this._totalDataSize > (this._maxLogFileSize * 1024 - this._totalDataSize) * 3) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Logfile is filling up, issuing warning.", this._logName);
                }
                this._logWarningIssued = true;
                try {
                    this._recoveryAgent.logFileWarning(this._logName, this._totalDataSize, this._maxLogFileSize * 1024);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1511", this);
                }
            }
            try {
                this._controlLock.releaseExclusiveLock();
            }
            catch (NoExclusiveLockException noExclusiveLockException) {
                FFDCFilter.processException((Throwable)noExclusiveLockException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1506", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "keypoint", "InternalLogException");
                }
                throw new InternalLogException(noExclusiveLockException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.keypoint", "1512", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "keypoint", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
        }
        if (this.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "keypoint", this);
            }
            throw new InternalLogException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypoint");
        }
    }

    public void removing(Object object) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removing", new Object[]{object, this});
        }
        if (this.failed() || this.incompatible()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removing", this);
            }
            throw new InternalLogException(null);
        }
        try {
            ((RecoverableUnitImpl)object).remove();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removing", "1573", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removing", internalLogException);
            }
            throw internalLogException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog.removing", "1581", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An unexpected error occured whilst removing a RecoverableUnit");
            }
            this.markFailed(exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "removing", "InternalLogException");
            }
            throw new InternalLogException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void payloadAdded(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadAdded", new Object[]{this, new Integer(n), new Integer(n2)});
        }
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            this._unwrittenDataSize += n;
            this._totalDataSize += n2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadAdded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadWritten", new Object[]{this, new Integer(n)});
        }
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            this._unwrittenDataSize -= n;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadWritten");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadDeleted", new Object[]{this, new Integer(n), new Integer(n2)});
        }
        MultiScopeRecoveryLog multiScopeRecoveryLog = this;
        synchronized (multiScopeRecoveryLog) {
            this._totalDataSize -= n;
            this._unwrittenDataSize -= n2;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadDeleted");
        }
    }

    protected boolean failed() {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug(tc, "failed: RecoveryLog has been marked as failed. [" + this + "]");
        }
        return this._failed;
    }

    protected boolean incompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug(tc, "incompatible: RecoveryLog has been marked as incompatible. [" + this + "]");
        }
        return this._incompatible;
    }

    protected synchronized void markFailed(Throwable throwable) {
        this.markFailed(throwable, true);
    }

    protected synchronized void markFailed(Throwable throwable, boolean bl) {
        if (tc.isDebugEnabled() && this._failed) {
            Tr.debug(tc, "markFailed: RecoveryLog has been marked as failed. [" + this + "]");
        }
        if (!this._failed && bl) {
            Object[] objectArray = new Object[]{new Integer(this._logIdentifier), this._clientName};
            Tr.audit(tc, "CWRLS0008_RECOVERY_LOG_FAILED", objectArray);
            Tr.info(tc, "CWRLS0009_RECOVERY_LOG_FAILED_DETAIL", throwable);
        }
        this._failed = true;
    }

    protected synchronized void markIncompatible() {
        if (tc.isDebugEnabled() && this._incompatible) {
            Tr.debug(tc, "markIncompatible: RecoveryLog has been marked as incompatible. [" + this + "]");
        }
        this._incompatible = true;
    }

    protected void addRecoverableUnit(RecoverableUnit recoverableUnit, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRecoverableUnit", new Object[]{recoverableUnit, new Boolean(bl), this});
        }
        long l = recoverableUnit.identity();
        this._recoverableUnits.put(new Long(l), recoverableUnit);
        if (bl) {
            this._recUnitIdTable.reserveId(l, recoverableUnit);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRecoverableUnit");
        }
    }

    protected RecoverableUnitImpl removeRecoverableUnitMapEntries(long l) {
        RecoverableUnitImpl recoverableUnitImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoverableUnitMapEntries", new Object[]{new Long(l), this});
        }
        if ((recoverableUnitImpl = (RecoverableUnitImpl)this._recoverableUnits.remove(new Long(l))) != null) {
            this._recUnitIdTable.removeId(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoverableUnitMapEntries", recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    protected RecoverableUnitImpl getRecoverableUnit(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoverableUnit", new Object[]{new Long(l), this});
        }
        RecoverableUnitImpl recoverableUnitImpl = null;
        if (!this.incompatible() && !this.failed()) {
            recoverableUnitImpl = (RecoverableUnitImpl)this._recoverableUnits.get(new Long(l));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoverableUnit", recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    String serverName() {
        return this._serverName;
    }

    String clientName() {
        return this._clientName;
    }

    public int clientVersion() {
        return this._clientVersion;
    }

    public String logName() {
        return this._logName;
    }

    public int logIdentifier() {
        return this._logIdentifier;
    }

    public String toString() {
        return this._traceId;
    }
}

