/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class RLSAccessFile
extends RandomAccessFile {
    private static final TraceComponent tc = Tr.register(RLSAccessFile.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static HashMap _accessFiles = new HashMap();
    private int _useCount;
    private File _file;

    RLSAccessFile(File file, String string) throws FileNotFoundException {
        super(file, string);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RLSAccessFile", new Object[]{file, string});
        }
        this._useCount = 1;
        this._file = file;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RLSAccessFile", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", new Object[]{this, this._file});
        }
        Class clazz = RLSAccessFile.class;
        synchronized (clazz) {
            --this._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "remaining file use count", new Integer(this._useCount));
            }
            if (tc.isDebugEnabled() && this._useCount <= 0) {
                Tr.debug(tc, "call stack", new Exception("Dummy traceback"));
            }
            if (this._useCount == 0) {
                super.close();
                _accessFiles.remove(this._file);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    static synchronized RLSAccessFile getRLSAccessFile(File file) throws FileNotFoundException {
        RLSAccessFile rLSAccessFile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRLSAccessFile", file);
        }
        if ((rLSAccessFile = (RLSAccessFile)_accessFiles.get(file)) == null) {
            rLSAccessFile = new RLSAccessFile(file, "rw");
            _accessFiles.put(file, rLSAccessFile);
        } else {
            ++rLSAccessFile._useCount;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "total file use count", new Integer(rLSAccessFile._useCount));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRLSAccessFile", rLSAccessFile);
        }
        return rLSAccessFile;
    }
}

