/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSController;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSSuspendTokenImpl;
import com.ibm.ws.recoverylog.spi.RLSSuspendTokenManager;
import com.ibm.ws.recoverylog.spi.RLSTimeoutRangeException;

public class RLSControllerImpl
implements RLSController {
    private static final TraceComponent tc = Tr.register(RLSControllerImpl.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    static Object SUSPEND_LOCK = new Object();
    private static RLSSuspendTokenManager _tokenManager = RLSSuspendTokenManager.getInstance();
    private static boolean _isSuspended;

    RLSControllerImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RLSControllerImpl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RLSControllerImpl", this);
        }
    }

    public void resume(RLSSuspendToken rLSSuspendToken) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", rLSSuspendToken);
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", "java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSControllerImpl.resumeRLS(rLSSuspendToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public void resume(byte[] byArray) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", Util.toHexString(byArray));
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", "java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSSuspendTokenImpl rLSSuspendTokenImpl = new RLSSuspendTokenImpl(byArray);
        RLSControllerImpl.resumeRLS(rLSSuspendTokenImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public RLSSuspendToken suspend(int n) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", new Integer(n));
        }
        if (Configuration.isZOS()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Operation not supported on ZOS - throwing UnsupportedOperationException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume", "java.lang.UnsupportedOperationException");
            }
            throw new UnsupportedOperationException();
        }
        RLSSuspendToken rLSSuspendToken = RLSControllerImpl.suspendRLS(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend");
        }
        return rLSSuspendToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RLSSuspendToken suspendRLS(int n) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspendRLS", new Integer(n));
        }
        if (n < 0 || n > 1000000000) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Timeout value is out of range - throwing RLSTimeoutRangeException", new Integer(n));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend", "RLSTimeoutRangeException");
            }
            throw new RLSTimeoutRangeException();
        }
        RLSSuspendToken rLSSuspendToken = null;
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            if (!Configuration._isSnapshotSafe) {
                Tr.warning(tc, "CWRLS0020_SNAPSHOT_SAFE");
            }
            rLSSuspendToken = _tokenManager.registerSuspend(n);
            Tr.info(tc, "CWRLS0001_SUSPEND_RLS", rLSSuspendToken);
            _isSuspended = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspendRLS", rLSSuspendToken);
        }
        return rLSSuspendToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resumeRLS(RLSSuspendToken rLSSuspendToken) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resumeRLS", rLSSuspendToken);
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            try {
                _tokenManager.registerResume(rLSSuspendToken);
            }
            catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
                FFDCFilter.processException(rLSInvalidSuspendTokenException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", "120");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow RLSInvalidSuspendTokenException - attempt to resume an invalid token", rLSSuspendToken);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "resumeRLS", rLSInvalidSuspendTokenException);
                }
                throw rLSInvalidSuspendTokenException;
            }
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "There are no outstanding suspends - resuming recovery log service");
                }
                Tr.info(tc, "CWRLS0002_RESUME_RLS", rLSSuspendToken);
                _isSuspended = false;
                SUSPEND_LOCK.notifyAll();
            } else {
                Tr.info(tc, "CWRLS0021_RESUME_ATTEMPT_RLS", rLSSuspendToken);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "There are still outstanding suspensions - recovery log service remains suspended");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resumeRLS");
        }
    }

    static boolean isSuspended() {
        return _isSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyTimeout");
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Resuming recovery log service following a suspension timeout");
                }
                _isSuspended = false;
                Tr.info(tc, "CWRLS0023_RESUME_RLS");
                SUSPEND_LOCK.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyTimeout");
        }
    }
}

