/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryHandler;
import com.ibm.ws.recoverylog.spi.ScalableFailureScope;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.ws390.recoverylog.spi.ControllerFailureScope;
import com.ibm.ws390.recoverylog.spi.ControllerRecoveryDirectorImpl;
import com.ibm.wsspi.hamanager.AsynchOperationComplete;
import com.ibm.wsspi.hamanager.GroupMemberId;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAGroupCallback;
import java.util.HashMap;
import java.util.Map;

public class RLSHAGroupCallback
implements HAGroupCallback {
    private static final TraceComponent tc = Tr.register(RLSHAGroupCallback.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private RecoveryDirector _recoveryDirector;
    private static boolean _localRecoveryFailed = false;
    private HashMap _currentRecoveryHandlers;
    private static Object _freeze = new Object();
    private static RLSHAMessageAlarm _msgAlarm;

    public RLSHAGroupCallback() {
        block5: {
            this._currentRecoveryHandlers = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RLSHAGroupCallback");
            }
            try {
                this._recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
            }
            catch (InternalLogException internalLogException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "No director", internalLogException);
            }
        }
        this._currentRecoveryHandlers = new HashMap();
        if (!Configuration.isZOS()) {
            _msgAlarm = new RLSHAMessageAlarm(60);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RLSHAGroupCallback");
        }
    }

    public void memberMayActivate(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "memberMayActivate", groupName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "memberMayActivate");
        }
    }

    public void memberMayActivateCancelled(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "memberMayActivateCancelled", groupName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "memberMayActivateCancelled");
        }
    }

    public void memberIsActivated(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        block28: {
            boolean bl;
            block29: {
                boolean bl2;
                FailureScope failureScope;
                block27: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "memberIsActivated", new Object[]{groupName, asynchOperationComplete, object});
                    }
                    failureScope = this.failureScopeFromGroupName(groupName);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "RLSHA: ACTIVATE recovery for failure scope " + failureScope);
                    }
                    bl = false;
                    bl2 = true;
                    try {
                        if (failureScope != null) {
                            if (failureScope.equals(Configuration.localFailureScope())) {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "RLSHA: This is a recovery request for the LOCAL server");
                                }
                                bl = true;
                                if (_msgAlarm != null) {
                                    _msgAlarm.resetAlarm();
                                }
                            } else {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "RLSHA: This is a recovery request for a PEER server");
                                }
                                bl = false;
                            }
                        } else {
                            bl2 = false;
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "RLSHA: Recovery ACTIVATION has failed as the failure scope can't be resolved from the group name");
                            }
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberIsActivated", "141", this);
                        bl2 = false;
                        if (!tc.isEventEnabled()) break block27;
                        Tr.event(tc, "An unexpected exception occured when registering failure to process recovery activation. The exception was " + exception);
                    }
                }
                if (bl2) {
                    try {
                        RecoveryHandler recoveryHandler = new RecoveryHandler(this, failureScope, bl);
                        this.addRecoveryHandler(failureScope, recoveryHandler);
                        if (Configuration.isZOS()) {
                            recoveryHandler.run();
                        } else {
                            recoveryHandler.start();
                        }
                    }
                    catch (Throwable throwable) {
                        bl2 = false;
                    }
                }
                if (bl2) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "RLSHA: Registering memberIsActivated success for failure scope " + failureScope);
                    }
                    try {
                        asynchOperationComplete.success(object, null);
                    }
                    catch (Exception exception) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "An unexpected error occured when registering success for " + failureScope);
                        }
                        break block28;
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: Registering memberIsActivated failure for failre scope " + failureScope);
                }
                try {
                    asynchOperationComplete.failed(object, "An unexpeced error occured whilst driving recovery processing", null);
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) break block29;
                    Tr.event(tc, "An unexpected error occured when registering failure for " + failureScope);
                }
            }
            if (bl) {
                RLSHAGroupCallback.localRecoveryFailed();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "memberIsActivated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberDeactivate(GroupName groupName, AsynchOperationComplete asynchOperationComplete, Object object) {
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "memberDeactivate", new Object[]{groupName, asynchOperationComplete, object});
            }
            boolean bl = false;
            FailureScope failureScope = this.failureScopeFromGroupName(groupName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RLSHA: TERMINATE recovery for failure scope " + failureScope);
            }
            if (failureScope == null) {
                bl = true;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to proceed with recovery termination request as failure scope is null");
                }
            } else if (failureScope.equals(Configuration.localFailureScope())) {
                bl = true;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to proceed with recovery termination request as failure scope is LOCAL failure scope");
                }
                Tr.error(tc, "CWRLS0018_RECOVERY_PROCESSING_FAILED", failureScope.serverName());
            } else {
                RecoveryHandler recoveryHandler = this.removeRecoveryHandler(failureScope);
                if (recoveryHandler != null) {
                    recoveryHandler.interrupt();
                }
                try {
                    if (Configuration.isZOS()) {
                        ((ControllerRecoveryDirectorImpl)this._recoveryDirector).driveTermination(failureScope);
                    } else {
                        ((RecoveryDirectorImpl)this._recoveryDirector).directTermination(failureScope);
                    }
                }
                catch (TerminationFailedException terminationFailedException) {
                    FFDCFilter.processException((Throwable)terminationFailedException, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberDeactivate", "206", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "An unexpected exception occured when terminating recovery processing. The exception was " + terminationFailedException);
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberDeactivate", "218", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "An unexpected exception occured when terminating recovery processing. The exception was " + exception);
                    }
                    bl = true;
                }
                finally {
                    if (recoveryHandler != null) {
                        recoveryHandler.clearLock();
                    }
                }
            }
            try {
                if (!bl) {
                    asynchOperationComplete.success(object, null);
                } else {
                    asynchOperationComplete.failed(object, "Unable to terminate recovery processing", null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberDeactivate", "235", this);
                if (!tc.isEventEnabled()) break block27;
                Tr.event(tc, "An unexpected exception occured when registering sucessfull processing of recovery termination. The exception was " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "memberDeactivate");
        }
    }

    public void membershipChanged(GroupName groupName, GroupMemberId[] groupMemberIdArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "membershipChanged", new Object[]{groupName, groupMemberIdArray});
        }
        if (groupMemberIdArray != null && tc.isDebugEnabled()) {
            for (int i = 0; i < groupMemberIdArray.length; ++i) {
                String string = groupMemberIdArray[i].getServerName();
                Map map = groupMemberIdArray[i].getMemberProperties();
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "Server '" + string + "' is a member of group " + groupName);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "membershipChanged");
        }
    }

    public boolean isAlive(GroupName groupName) {
        FailureScope failureScope;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlive", groupName);
        }
        boolean bl = true;
        if (_localRecoveryFailed && (failureScope = this.failureScopeFromGroupName(groupName)) != null && this._recoveryDirector.currentFailureScope().equals(failureScope)) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlive", new Boolean(bl));
        }
        return bl;
    }

    public void onMessage(GroupMemberId groupMemberId, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "onMessage", new Object[]{groupMemberId, byArray});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "onMessage");
        }
    }

    public static void localRecoveryFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "localRecoveryFailed");
        }
        if (!_localRecoveryFailed) {
            Tr.warning(tc, "CWRLS0029_LOCAL_RECOVERY_FAILED");
            _localRecoveryFailed = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "localRecoveryFailed");
        }
    }

    FailureScope failureScopeFromGroupName(GroupName groupName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "failureScopeFromGroupName", groupName);
        }
        FailureScope failureScope = null;
        Map map = groupName.getGroupProperties();
        if (map != null) {
            String string = (String)map.get("GN_PS");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "HA group preferred server is " + string);
            }
            if (string != null) {
                if (Configuration.isZOS()) {
                    String string2 = (String)map.get("SFS_UUID");
                    if (string2 != null) {
                        if (string2.equals(Configuration.uuid())) {
                            failureScope = Configuration.localFailureScope();
                        } else {
                            String string3 = (String)map.get("SVR_SHORT");
                            long l = System.currentTimeMillis();
                            failureScope = new ControllerFailureScope(string2, l, string, string3);
                        }
                    } else if (tc.isEventEnabled()) {
                        Tr.event(tc, "The zOS group name contained no uuid, cannot create FailureScope", groupName);
                    }
                } else {
                    failureScope = new FileFailureScope(string);
                }
            }
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "The group name contains no map properties");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "failureScopeFromGroupName", failureScope);
        }
        return failureScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoveryHandler(FailureScope failureScope, RecoveryHandler recoveryHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRecoveryHandler", new Object[]{failureScope, recoveryHandler});
        }
        HashMap hashMap = this._currentRecoveryHandlers;
        synchronized (hashMap) {
            if (failureScope instanceof ScalableFailureScope) {
                this._currentRecoveryHandlers.put(failureScope.serverName(), recoveryHandler);
            } else {
                this._currentRecoveryHandlers.put(failureScope, recoveryHandler);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRecoveryHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryHandler removeRecoveryHandler(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoveryHandler", failureScope);
        }
        RecoveryHandler recoveryHandler = null;
        HashMap hashMap = this._currentRecoveryHandlers;
        synchronized (hashMap) {
            recoveryHandler = failureScope instanceof ScalableFailureScope ? (RecoveryHandler)this._currentRecoveryHandlers.remove(failureScope.serverName()) : (RecoveryHandler)this._currentRecoveryHandlers.remove(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoveryHandler", recoveryHandler);
        }
        return recoveryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RecoveryHandler getRecoveryHandler(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryHandler", failureScope);
        }
        RecoveryHandler recoveryHandler = null;
        HashMap hashMap = this._currentRecoveryHandlers;
        synchronized (hashMap) {
            recoveryHandler = failureScope instanceof ScalableFailureScope ? (RecoveryHandler)this._currentRecoveryHandlers.get(failureScope.serverName()) : (RecoveryHandler)this._currentRecoveryHandlers.get(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryHandler", recoveryHandler);
        }
        return recoveryHandler;
    }

    public static void terminateServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminateServer");
        }
        RLSHAGroupCallback.localRecoveryFailed();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminateServer");
        }
    }

    static class RLSHAMessageAlarm
    implements AlarmListener {
        private Alarm _alarm;
        private final long _duration;

        RLSHAMessageAlarm(int n) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RLSHAMessageAlarm", new Integer(n));
            }
            this._duration = (long)n * 1000L;
            this._alarm = AlarmManager.createNonDeferrable(this._duration, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RLSHAMessageAlarm", this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "alarm", this);
            }
            RLSHAMessageAlarm rLSHAMessageAlarm = this;
            synchronized (rLSHAMessageAlarm) {
                if (this._alarm != null) {
                    Tr.warning(tc, "CWRLS0030_WAITING_FOR_HAM_ACTIVATE");
                    this._alarm = AlarmManager.createNonDeferrable(this._duration, this);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alarm");
            }
        }

        synchronized void resetAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resetAlarm", this);
            }
            this._alarm = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resetAlarm");
            }
        }
    }
}

