/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.recoverylog.spi.RLSControllerImpl;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSSuspendTokenImpl;
import java.util.HashMap;

class RLSSuspendTokenManager
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(RLSSuspendTokenManager.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static RLSSuspendTokenManager _instance = new RLSSuspendTokenManager();
    private HashMap _tokenMap;

    private RLSSuspendTokenManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RLSSuspendTokenManager");
        }
        this._tokenMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RLSSuspendTokenManager", this);
        }
    }

    static RLSSuspendTokenManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", _instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RLSSuspendToken registerSuspend(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSuspend", new Integer(n));
        }
        RLSSuspendTokenImpl rLSSuspendTokenImpl = new RLSSuspendTokenImpl();
        Alarm alarm = null;
        if (n > 0) {
            alarm = AlarmManager.createNonDeferrable((long)n * 1000L, this, rLSSuspendTokenImpl);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Alarm has been created for this suspend call", alarm);
            }
        }
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            this._tokenMap.put(rLSSuspendTokenImpl, alarm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSuspend", rLSSuspendTokenImpl);
        }
        return rLSSuspendTokenImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        RLSSuspendTokenImpl rLSSuspendTokenImpl = (RLSSuspendTokenImpl)object;
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (this._tokenMap.containsKey(rLSSuspendTokenImpl)) {
                this._tokenMap.remove(rLSSuspendTokenImpl);
                Tr.info(tc, "CWRLS0022_RLS_SUSPEND_TIMEOUT", rLSSuspendTokenImpl);
            }
        }
        RLSControllerImpl.notifyTimeout();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerResume(RLSSuspendToken rLSSuspendToken) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerResume", rLSSuspendToken);
        }
        if (rLSSuspendToken != null && this._tokenMap.containsKey(rLSSuspendToken)) {
            RLSSuspendTokenImpl rLSSuspendTokenImpl = (RLSSuspendTokenImpl)rLSSuspendToken;
            HashMap hashMap = this._tokenMap;
            synchronized (hashMap) {
                Alarm alarm = (Alarm)this._tokenMap.remove(rLSSuspendTokenImpl);
                if (alarm != null) {
                    alarm.cancel();
                }
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Throw RLSInvalidSuspendTokenException - suspend token is not recognised");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "registerResume", "RLSInvalidSuspendTokenException");
            }
            throw new RLSInvalidSuspendTokenException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerResume");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isResumable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResumable");
        }
        boolean bl = true;
        HashMap hashMap = this._tokenMap;
        synchronized (hashMap) {
            if (!this._tokenMap.isEmpty()) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResumable", new Boolean(bl));
        }
        return bl;
    }
}

