/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.util.Stack;

public class RLSUtils {
    private static final TraceComponent tc = Tr.register(RLSUtils.class, "Transaction", null);
    private static final String _digits = "0123456789abcdef";
    public static final int MAX_DISPLAY_BYTES = 32;
    protected static final int BOOLEAN_SIZE = 1;
    protected static final int SHORT_SIZE = 2;
    protected static final int INT_SIZE = 4;
    protected static final int LONG_SIZE = 8;
    protected static final String UNC_HEADER = new String(File.separator + File.separator);
    private static Object _directoryCreationLock = new Object();

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return RLSUtils.toHexString(byArray, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n) {
        StringBuffer stringBuffer = null;
        boolean bl = false;
        if (byArray != null) {
            if (n > byArray.length) {
                n = byArray.length;
            } else if (n < byArray.length) {
                bl = true;
            }
            stringBuffer = new StringBuffer(n * 2);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(_digits.charAt(byArray[i] >> 4 & 0xF));
                stringBuffer.append(_digits.charAt(byArray[i] & 0xF));
            }
            if (bl) {
                stringBuffer.append("... (" + n + "/" + byArray.length + ")");
            } else {
                stringBuffer.append("(" + n + ")");
            }
        } else {
            stringBuffer = new StringBuffer("null");
        }
        return stringBuffer.toString();
    }

    public static String FQHAMCompatibleServerName(String string, String string2, String string3) {
        return string + "\\" + string2 + "\\" + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDirectoryTree(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDirectoryTree", string);
        }
        boolean bl = true;
        Object object = _directoryCreationLock;
        synchronized (object) {
            File file = new File(string);
            if (!file.exists()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Creating directory tree", string);
                }
                Stack<File> stack = new Stack<File>();
                while (file != null) {
                    stack.push(file);
                    file = file.getParentFile();
                }
                while (!stack.empty() && bl) {
                    file = (File)stack.pop();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking path to " + file.getAbsolutePath());
                    }
                    if (!file.exists()) {
                        boolean bl2;
                        if (file.getAbsolutePath().equals(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Ignoring " + file.getAbsolutePath() + " - is " + UNC_HEADER);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Creating path to " + file.getAbsolutePath());
                        }
                        if (bl2 = file.mkdirs()) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Created path to " + file.getAbsolutePath());
                            continue;
                        }
                        if (file.getAbsolutePath().startsWith(UNC_HEADER)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Ignoring " + file.getAbsolutePath() + " - starts with " + UNC_HEADER);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not create path to " + file.getAbsolutePath());
                        }
                        if (!file.exists()) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Unable to create directory tree");
                            }
                            bl = false;
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Path to " + file.getAbsolutePath() + " already exists");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Path to " + file.getAbsolutePath() + " already exists");
                }
            }
            if (bl && !file.exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not create path to " + file.getAbsolutePath());
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDirectoryTree", new Boolean(bl));
        }
        return bl;
    }
}

