/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.recoverylog.spi.LogRecord;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ReadableLogRecord
extends LogRecord {
    private static final TraceComponent tc = Tr.register(ReadableLogRecord.class, "Transaction", null);

    private ReadableLogRecord(ByteBuffer byteBuffer, int n) {
        super(byteBuffer, n);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ReadableLogRecord", new Object[]{byteBuffer, new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ReadableLogRecord", this);
        }
    }

    protected static ReadableLogRecord read(ByteBuffer byteBuffer, long l, ByteBuffer byteBuffer2) {
        byte[] byArray;
        ReadableLogRecord readableLogRecord;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "read", new Object[]{byteBuffer, new Long(l)});
            }
            readableLogRecord = null;
            byArray = new byte[RECORD_MAGIC_NUMBER.length];
            try {
                byteBuffer.get(byArray);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "Could not read magic number", bufferUnderflowException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Magic number = " + Util.toHexString(byArray));
        }
        int n = 0;
        if (Arrays.equals(byArray, RECORD_MAGIC_NUMBER)) {
            long l2 = byteBuffer.getLong();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Record sequence number = " + l2);
            }
            if (l2 == l) {
                n = byteBuffer.getInt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Record contains " + n + " bytes of data");
                }
                int n2 = byteBuffer.position();
                byteBuffer.position(n2 + n);
                long l3 = byteBuffer.getLong();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Tail sequence number = " + l3);
                }
                if (l3 == l) {
                    byteBuffer.position(n2);
                    readableLogRecord = new ReadableLogRecord(byteBuffer, byteBuffer2.position());
                    byteBuffer2.position(byteBuffer2.position() + HEADER_SIZE + n);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "read", readableLogRecord);
        }
        return readableLogRecord;
    }
}

