/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.RecoveryLog;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeFactory;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScopeFactory;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RLSHAGroupCallback;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.StreamLogProperties;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ApplicationServer;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.recoverylog.spi.ControllerFailureScope;
import com.ibm.ws390.recoverylog.spi.ControllerFailureScopeFactory;
import com.ibm.ws390.recoverylog.spi.ControllerRecoveryDirectorImpl;
import com.ibm.ws390.recoverylog.spi.NativeConfiguration;
import com.ibm.ws390.recoverylog.spi.RecoveryLogCompressionAlarm;
import com.ibm.ws390.recoverylog.spi.ServantFailureScope;
import com.ibm.ws390.recoverylog.spi.ServantFailureScopeFactory;
import com.ibm.ws390.recoverylog.spi.ServantRecoveryDirectorImpl;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.hamanager.GroupManager;
import com.ibm.wsspi.hamanager.GroupName;
import com.ibm.wsspi.hamanager.HAGroup;
import com.ibm.wsspi.hamanager.HAGroupLeftException;
import com.ibm.wsspi.hamanager.corestack.CoreStack;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class RecLogServiceImpl
extends ComponentImpl
implements PropertyChangeListener {
    private static TraceComponent tc = Tr.register(RecLogServiceImpl.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static RecLogServiceImpl _rls;
    private static boolean _isZOS;
    private static final String RLS_GROUP_KEY = "type";
    private static final String RLS_GROUP_NAME = "WAS_TRANSACTIONS";
    private Exception _initializationException = null;
    private static GroupManager _groupManager;
    private static Repository _repository;
    private static RLSHAGroupCallback _rlsHAGroupCallback;
    private static HashMap _recoveryLogConfiguration;
    private static HashMap _serverShortNameMap;
    public static boolean _haEnabled;
    private static boolean _enabledPeerRecovery;
    private static boolean _recoveryOnlyMode;
    private static String _homeServerName;
    private static final String CELL_XML = "cell.xml";
    private static final String NODE_XML = "node.xml";
    private static final String SERVER_XML = "server.xml";
    private static final String CLUSTER_XML = "cluster.xml";
    private static final String SERVERINDEX_XML = "serverindex.xml";
    private static HashMap _haGroups;

    public void initialize(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{object, this});
        }
        _rls = this;
        try {
            _isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
            _recoveryLogConfiguration = new HashMap();
            _serverShortNameMap = new HashMap();
            _haGroups = new HashMap();
            _repository = (Repository)this.getService(Repository.class);
            Server server2 = (Server)this.getService(Server.class);
            ClusterMemberService clusterMemberService = (ClusterMemberService)this.getService(ClusterMemberService.class);
            Configuration.clusterMemberService(clusterMemberService);
            String string = server2.getCellName();
            String string2 = server2.getClusterName();
            String string3 = server2.getNodeName();
            String string4 = server2.getName();
            String string5 = this.expandVariable("${USER_INSTALL_ROOT}");
            Configuration.cellName(string);
            Configuration.clusterName(string2);
            Configuration.nodeName(string3);
            Configuration.serverName(string4);
            Configuration.serverShortName(server2.getShortName());
            Configuration.uuid(this.getServerUUID());
            Configuration.WASInstallDirectory(string5);
            Configuration.localFailureScope(new FileFailureScope());
            Configuration.isZOS(_isZOS);
            _recoveryOnlyMode = server2.getServerMode() == 1;
            this.releaseService(server2);
            this.scanRecoveryLogConfig();
            if (_recoveryOnlyMode && _haEnabled) {
                Tr.warning(tc, "CWRLS0025_RECOVER_MODE_NOT_COMPATIBLE");
                throw new Exception("Recovery mode startup is not compatible with High Availability enablement");
            }
            ApplicationServer applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
            if (applicationServer != null) {
                applicationServer.addPropertyChangeListener("state", this);
                this.releaseService(applicationServer);
            } else if (!_isZOS) {
                Tr.warning(tc, "CWRLS0029_LOCAL_RECOVERY_FAILED");
                throw new Exception("Unable to locate the ApplicationServer service.");
            }
            FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.FILE_FAILURE_SCOPE_ID, FileFailureScope.class, new FileFailureScopeFactory());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.initialize", "86", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An exception occured during initilaization. This will be reported during start processing. Exception was " + exception);
            }
            this._initializationException = exception;
        }
        if (_isZOS) {
            Configuration.useFileLocking(false);
            this.zOSInitialize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    private void zOSInitialize() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "zOSInitialize");
            }
            FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.CONTROLLER_FAILURE_SCOPE_ID, ControllerFailureScope.class, (FailureScopeFactory)new ControllerFailureScopeFactory());
            FailureScopeManager.registerFailureScopeFactory(FailureScopeFactory.SERVANT_FAILURE_SCOPE_ID, ServantFailureScope.class, (FailureScopeFactory)new ServantFailureScopeFactory());
            try {
                String string = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt(string);
                if (n == 64) {
                    System.loadLibrary("bbgglog");
                } else {
                    System.loadLibrary("bboglog");
                }
                if (PlatformHelperFactory.getPlatformHelper().isControlJvm()) {
                    string = System.getProperty("com.ibm.vm.bitmode");
                    n = Integer.parseInt(string);
                    if (n == 64) {
                        System.loadLibrary("bbgtots");
                    } else {
                        System.loadLibrary("bbotots");
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                FFDCFilter.processException((Throwable)unsatisfiedLinkError, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.zOSInitialize", "158", this);
                if (!tc.isEventEnabled()) break block9;
                Tr.event(tc, "Failed to load one or more libraries", unsatisfiedLinkError);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zOSInitialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "propertyChange", new Object[]{propertyChangeEvent, propertyChangeEvent != null ? propertyChangeEvent.getNewValue() : ""});
        }
        ApplicationServer applicationServer = null;
        try {
            applicationServer = (ApplicationServer)this.getService(ApplicationServer.class);
            if (propertyChangeEvent.getSource() == applicationServer && propertyChangeEvent.getNewValue().equals("STARTING")) {
                this.checkHASupport();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.propertyChange", "450", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An exception occured. This will be reported during start processing. Exception was " + exception);
            }
            this._initializationException = exception;
        }
        finally {
            if (applicationServer != null) {
                this.releaseService(applicationServer);
            }
            if (bl) {
                Tr.exit(tc, "propertyChange");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHASupport() throws Exception {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "checkHASupport");
        }
        try {
            CoreStack coreStack;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: Resolving CoreStack service");
            }
            if ((coreStack = (CoreStack)this.getService(CoreStack.class)) != null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: CoreStack service resolved");
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: Resolving GroupManager");
                }
                if (!PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                    _groupManager = coreStack.getGroupManager();
                }
                if (_groupManager != null) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "RLSHA: GroupManager resolved");
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: GroupManager is not available");
                }
                this.releaseService(coreStack);
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: CoreStack service is not available.");
            }
            if (_groupManager == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: No GroupManager is available. Unable to support peer recovery processing");
                }
                _haEnabled = false;
            }
            Configuration.HAEnabled(_haEnabled);
        }
        finally {
            if (bl) {
                Tr.exit(tc, "checkHASupport");
            }
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RLSHA: Recovery Log Service is starting");
        }
        if (this._initializationException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start", "RuntimeError");
            }
            throw new RuntimeError(this._initializationException);
        }
        if (_isZOS) {
            try {
                this.zOSStart();
            }
            catch (RuntimeError runtimeError) {
                FFDCFilter.processException((Throwable)runtimeError, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", "238", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", runtimeError);
                }
                throw runtimeError;
            }
        }
        if (tc.isEventEnabled()) {
            if (_haEnabled) {
                Tr.event(tc, "RLSHA: PEER RECOVERY IS ENABLED");
            } else {
                Tr.event(tc, "RLSHA: PEER RECOVERY IS DISABLED");
            }
        }
        if (Configuration.clusterName() != null && _groupManager != null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: Using HA framework for recovery arbitration");
            }
            _homeServerName = _groupManager.getServerName();
            RecLogServiceImpl.registerWithHAManager(_homeServerName, Configuration.serverShortName(), Configuration.uuid());
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: Using local-only recovery logic");
            }
            try {
                RecoveryDirector recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
                if (!_isZOS) {
                    ((RecoveryDirectorImpl)recoveryDirector).driveLocalRecovery();
                } else if (recoveryDirector instanceof ControllerRecoveryDirectorImpl && NativeConfiguration.instance().serverHasSRs()) {
                    ((ControllerRecoveryDirectorImpl)recoveryDirector).driveRecovery(null);
                } else if (recoveryDirector instanceof ServantRecoveryDirectorImpl && !PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
                    ((ServantRecoveryDirectorImpl)recoveryDirector).directLocalRecovery();
                }
            }
            catch (RecoveryFailedException recoveryFailedException) {
                FFDCFilter.processException((Throwable)recoveryFailedException, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", "421", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Local recovery failed. Throwing RuntimeError");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", "RuntimeError");
                }
                throw new RuntimeError("Unable to complete local recovery processing", recoveryFailedException);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.start", "478", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Local recovery not attempted. Throwing RuntimeError", internalLogException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "start", "RuntimeError");
                }
                throw new RuntimeError("Unable to complete local recovery processing", internalLogException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void zOSStart() throws RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "zOSStart", this);
        }
        RecoveryDirector recoveryDirector = null;
        try {
            recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
            if (NativeConfiguration.instance().serverHasSRs() && recoveryDirector instanceof ControllerRecoveryDirectorImpl) {
                this.checkHASupport();
                ControllerRecoveryDirectorImpl controllerRecoveryDirectorImpl = ControllerRecoveryDirectorImpl.instance();
                controllerRecoveryDirectorImpl.initialize();
                Integer n = this.getCompressionAlarmInterval();
                RecoveryLogCompressionAlarm recoveryLogCompressionAlarm = new RecoveryLogCompressionAlarm(n);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.zOSStart", "281", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "zOSStart", "RuntimeError");
            }
            throw new RuntimeError(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "zOSStart");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private String getServerUUID() throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerUUID");
        }
        String string = null;
        try {
            Resource resource = _repository.getConfigRoot().getResource(4, SERVER_XML);
            com.ibm.websphere.models.config.process.Server server2 = (com.ibm.websphere.models.config.process.Server)resource.getContents().get(0);
            if (server2 != null) {
                string = server2.getUniqueId();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.getServerUUID", "617", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getServerUUID", "ConfigurationError");
            }
            throw new ConfigurationError("Caught exception while obtaining Resource object", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerUUID", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scanRecoveryLogConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scanRecoveryLogConfig");
        }
        if (_repository != null) {
            String string;
            ServerEntry serverEntry;
            int n;
            Resource resource;
            Object object;
            String string2 = _repository.getCellName();
            String string3 = Configuration.clusterName();
            ConfigRoot configRoot = _repository.getConfigRoot();
            String string4 = configRoot.getValue(3);
            Tr.debug(tc, "Preserving current NODE identity '" + string4 + "'");
            try {
                object = null;
                resource = configRoot.list(3, null);
                if (resource != null) {
                    for (int i = 0; i < ((String[])resource).length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Processing WAS node '" + resource[i] + "'");
                        }
                        configRoot.setValue(3, resource[i]);
                        object = configRoot.getResource(3, SERVERINDEX_XML);
                        EList eList = ((ServerIndex)object.getContents().get(0)).getServerEntries();
                        for (n = 0; n < eList.size(); ++n) {
                            serverEntry = (ServerEntry)eList.get(n);
                            string = RLSUtils.FQHAMCompatibleServerName(string2, resource[i], serverEntry.getServerName());
                            RecoveryLog recoveryLog = serverEntry.getRecoveryLog();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Processiong WAS server " + string);
                            }
                            if (recoveryLog != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "transactionLogDirectory =" + recoveryLog.getTransactionLogDirectory());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "CompensationLogDirectory =" + recoveryLog.getCompensationLogDirectory());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "CompensationLogFileSize =" + recoveryLog.getCompensationLogFileSize());
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "No recovery log configuration available");
                            }
                            _recoveryLogConfiguration.put(string, recoveryLog);
                            if (!_isZOS) continue;
                            String string5 = serverEntry.getServerShortName();
                            _serverShortNameMap.put(string, string5);
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WebSphere nodes available");
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.scanRecoveryLogConfig", "659", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WebSphere configuration available");
                }
            }
            finally {
                Tr.debug(tc, "Restoring previous NODE identity '" + string4 + "'");
                configRoot.setValue(3, string4);
            }
            _haEnabled = false;
            object = null;
            try {
                resource = null;
                String[] stringArray = configRoot.list(2, null);
                if (stringArray != null) {
                    object = configRoot.getValue(2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Preserved current cluster setting of " + (String)object);
                    }
                    n = 0;
                    for (int i = 0; i < stringArray.length && n == 0; ++i) {
                        configRoot.setValue(2, stringArray[i]);
                        resource = configRoot.getResource(2, CLUSTER_XML);
                        serverEntry = (ServerCluster)resource.getContents().get(0);
                        string = serverEntry.getName();
                        if (string.equals(string3)) {
                            n = 1;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking cluster configuration for cluster " + string);
                            }
                            if (_haEnabled = serverEntry.isSetEnableHA() ? serverEntry.isEnableHA() : false) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "RLSHA: HA support is ENABLED");
                                continue;
                            }
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "RLSHA: HA support is DISABLED");
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Ignoring cluster configuration for cluster " + string);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.enablePeerRecovery", "857");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected error occured whilst retrieving the cluster configuration. Disabling HA support");
                }
                _haEnabled = false;
            }
            finally {
                configRoot.setValue(2, (String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scanRecoveryLogConfig");
        }
    }

    public static String getServerShortName(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerShortName", failureScope);
        }
        String string = null;
        if (_isZOS) {
            String string2 = failureScope.serverName();
            string = (String)_serverShortNameMap.get(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerShortName", string);
        }
        return string;
    }

    public static synchronized RecoveryLog getRecoveryLogConfig(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryLogConfig", failureScope);
        }
        String string = failureScope.serverName();
        RecoveryLog recoveryLog = (RecoveryLog)_recoveryLogConfiguration.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryLogConfig", recoveryLog);
        }
        return recoveryLog;
    }

    public static void registerWithHAManager(String string, String string2, String string3) {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerWithHAManager", new Object[]{string, string2, string3});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RLSHA: register with HA Manager for server " + string);
            }
            if (_rlsHAGroupCallback == null) {
                _rlsHAGroupCallback = new RLSHAGroupCallback();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap hashMap2 = new HashMap();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: join group where type = WAS_TRANSACTIONS");
            }
            hashMap.put(RLS_GROUP_KEY, RLS_GROUP_NAME);
            hashMap.put("IBM_hc", Configuration.clusterName());
            hashMap.put("GN_PS", string);
            if (string2 != null) {
                hashMap.put("SVR_SHORT", string2);
            }
            if (string3 != null) {
                hashMap.put("SFS_UUID", string3);
            }
            try {
                GroupName groupName = _groupManager.createGroupName(hashMap);
                HAGroup hAGroup = _groupManager.joinGroup(groupName, hashMap2, _rlsHAGroupCallback);
                _haGroups.put(string, hAGroup);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.registerWithHAManager", "803");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to connect to HA framework.");
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, exception.toString(), exception);
                }
                if (!tc.isEventEnabled()) break block11;
                Tr.event(tc, "" + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWithHAManager");
        }
    }

    private String expandDirectory(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandDirectory", string);
        }
        String string2 = null;
        if (string != null && (string2 = this.expandVariable(string)) != null) {
            File file = new File(string2);
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandDirectory", string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePeerRecovery() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "enablePeerRecovery");
        }
        if (_haEnabled) {
            if (!_enabledPeerRecovery) {
                _enabledPeerRecovery = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RLSHA: HA interactions are enabled. Enabling peer recovery");
                }
                String string = Configuration.cellName();
                String string2 = Configuration.clusterName();
                ConfigRoot configRoot = _repository.getConfigRoot();
                Resource resource = null;
                String[] stringArray = configRoot.list(2, null);
                if (stringArray != null) {
                    HashMap<ServerEntry, String> hashMap = new HashMap<ServerEntry, String>();
                    HashMap<ServerEntry, String> hashMap2 = new HashMap<ServerEntry, String>();
                    String string3 = configRoot.getValue(2);
                    try {
                        for (int i = 0; i < stringArray.length; ++i) {
                            configRoot.setValue(2, stringArray[i]);
                            try {
                                resource = configRoot.getResource(2, CLUSTER_XML);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.enablePeerRecovery", "857");
                            }
                            Iterator iterator = resource.getContents().iterator();
                            while (iterator.hasNext()) {
                                ServerCluster serverCluster = (ServerCluster)iterator.next();
                                String string4 = serverCluster.getName();
                                if (string4.equals(string2)) {
                                    Tr.debug(tc, "Processing HAManager connections for cluster " + string4);
                                    Iterator iterator2 = serverCluster.getMembers().iterator();
                                    while (iterator2.hasNext()) {
                                        String string5;
                                        RecoveryLog recoveryLog;
                                        Object object;
                                        ClusterMember clusterMember = (ClusterMember)iterator2.next();
                                        String string6 = clusterMember.getMemberName();
                                        String string7 = clusterMember.getNodeName();
                                        String string8 = RLSUtils.FQHAMCompatibleServerName(string, string7, string6);
                                        String string9 = null;
                                        String string10 = null;
                                        try {
                                            resource = configRoot.getResource(0, "nodes/" + string7 + "/serverindex.xml");
                                        }
                                        catch (Throwable throwable) {
                                            if (tc.isEventEnabled()) {
                                                Tr.event(tc, "Could not get resource object for serverindex.xml", string7);
                                            }
                                            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecLogServiceImpl.enablePeerRecovery", "1048");
                                        }
                                        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                                        EList eList = serverIndex.getServerEntries();
                                        for (int j = 0; j < eList.size(); ++j) {
                                            object = (ServerEntry)eList.get(j);
                                            if (!object.getServerName().equals(string6)) continue;
                                            string9 = object.getServerUniqueId();
                                            string10 = object.getServerShortName();
                                        }
                                        if (!string8.equals(_homeServerName)) {
                                            RecLogServiceImpl.registerWithHAManager(string8, string10, string9);
                                        }
                                        if ((recoveryLog = (RecoveryLog)_recoveryLogConfiguration.get(string8)) == null) continue;
                                        object = _rls.expandDirectory(recoveryLog.getTransactionLogDirectory());
                                        if (object != null && (string5 = hashMap.put((ServerEntry)object, string8)) != null) {
                                            Tr.warning(tc, "CWRLS0027_COMMON_TRANLOG_DIRS", new Object[]{object, string5, string8});
                                        }
                                        if ((object = _rls.expandDirectory(recoveryLog.getCompensationLogDirectory())) == null || (string5 = hashMap2.put((ServerEntry)object, string8)) == null) continue;
                                        Tr.warning(tc, "CWRLS0028_COMMON_COMPLOG_DIRS", new Object[]{object, string5, string8});
                                    }
                                    continue;
                                }
                                Tr.debug(tc, "Ignoring HAManager connections for cluster " + string4);
                            }
                        }
                    }
                    finally {
                        configRoot.setValue(2, string3);
                    }
                    hashMap = null;
                    hashMap2 = null;
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RLSHA: HA interactions are disabled. Not enabling peer recovery");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "enablePeerRecovery");
        }
    }

    static void deactivateGroup(FailureScope failureScope, int n) {
        GroupName groupName;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "deactivateGroup", new Object[]{failureScope, new Integer(n)});
            }
            HAGroup hAGroup = null;
            groupName = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Preparing to leaving HA group");
                }
                hAGroup = (HAGroup)_haGroups.remove(failureScope.serverName());
                groupName = hAGroup.getGroupName();
                hAGroup.leave();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Left HA group");
                }
            }
            catch (HAGroupLeftException hAGroupLeftException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberIsActivated", "132");
                if (!tc.isEventEnabled()) break block13;
                Tr.event(tc, "An unexpected exception occured when leaving the HA group. The exception was " + exception);
            }
        }
        if (n > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sleeping for " + n + " seconds to allow another member to activate before re-joining");
            }
            try {
                Thread.sleep(1000 * n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Sleeping complete");
            }
        }
        String string = failureScope.serverName();
        String string2 = null;
        String string3 = null;
        if (groupName != null) {
            Map map = groupName.getGroupProperties();
            string2 = (String)map.get("SFS_UUID");
            string3 = (String)map.get("SVR_SHORT");
        }
        RecLogServiceImpl.registerWithHAManager(string, string3, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deactivateGroup");
        }
    }

    static void leaveGroup(FailureScope failureScope) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "leaveGroup", failureScope);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Preparing to leaving HA group");
                }
                HAGroup hAGroup = (HAGroup)_haGroups.remove(failureScope);
                hAGroup.leave();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Left HA group");
                }
            }
            catch (HAGroupLeftException hAGroupLeftException) {
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback.memberIsActivated", "1167");
                if (!tc.isEventEnabled()) break block7;
                Tr.event(tc, "An unexpected exception occured when leaving the HA group. The exception was " + exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaveGroup");
        }
    }

    static boolean isHardwareQuorumEnforced(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHardwareQuorumEnforced", failureScope);
        }
        boolean bl = false;
        HAGroup hAGroup = (HAGroup)_haGroups.get(failureScope);
        if (hAGroup != null) {
            try {
                bl = hAGroup.isHardwareQuorumEnforced();
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected exception occured when leaving checking for hardware quorum. The exception was " + exception);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHardwareQuorumEnforced", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Integer getCompressionAlarmInterval() {
        block22: {
            block20: {
                block21: {
                    if (RecLogServiceImpl.tc.isEntryEnabled()) {
                        Tr.entry(RecLogServiceImpl.tc, "getCompressionAlarmInterval");
                    }
                    var1_1 = null;
                    var2_2 = null;
                    var3_3 = AdminServiceFactory.getAdminService().getProcessType();
                    if (!var3_3.equals("DeploymentManager")) break block20;
                    var2_2 = new Integer(0);
                    if (RecLogServiceImpl.tc.isEntryEnabled()) {
                        Tr.exit(RecLogServiceImpl.tc, "getCompressionAlarmInterval", var2_2);
                    }
                    var4_5 = var2_2;
                    if (var1_1 == null) break block21;
                    this.releaseService(var1_1);
                }
                return var4_5;
            }
            try {
                var4_6 = null;
                var1_1 = (Repository)this.getService(Repository.class);
                var5_7 = (com.ibm.websphere.models.config.process.Server)var1_1.getConfigRoot().getResource(4, "server.xml").getContents().get(0);
                var6_8 = var5_7.getComponents();
                var7_9 = null;
                var8_10 = var6_8.iterator();
                while (var8_10 != null && var8_10.hasNext()) {
                    var9_11 /* !! */  = var8_10.next();
                    if (RecLogServiceImpl.tc.isDebugEnabled()) {
                        Tr.debug(RecLogServiceImpl.tc, "Parsing component", var9_11 /* !! */ );
                    }
                    if (var9_11 /* !! */  == null || !(var9_11 /* !! */  instanceof com.ibm.websphere.models.config.applicationserver.ApplicationServer)) continue;
                    var7_9 = (com.ibm.websphere.models.config.applicationserver.ApplicationServer)var9_11 /* !! */ ;
                }
                if (var7_9 != null) {
                    var6_8 = var7_9.getServices();
                    var8_10 = var6_8.iterator();
                    while (var4_6 == null && var8_10 != null && var8_10.hasNext()) {
                        var9_11 /* !! */  = var8_10.next();
                        if (RecLogServiceImpl.tc.isDebugEnabled()) {
                            Tr.debug(RecLogServiceImpl.tc, "Parsing appserver service", var9_11 /* !! */ );
                        }
                        if (var9_11 /* !! */  == null || !(var9_11 /* !! */  instanceof TransactionService)) continue;
                        var4_6 = (TransactionService)var9_11 /* !! */ ;
                    }
                }
                if (var4_6 != null && (var9_11 /* !! */  = var4_6.getProperties()) != null) {
                    var8_10 = var9_11 /* !! */ .iterator();
                    while (var2_2 == null && var8_10 != null && var8_10.hasNext()) {
                        var10_12 = var8_10.next();
                        if (RecLogServiceImpl.tc.isDebugEnabled()) {
                            Tr.debug(RecLogServiceImpl.tc, "Parsing property", var10_12);
                        }
                        if (var10_12 == null || !(var10_12 instanceof Property) || !StreamLogProperties.COMPRESS_INTERVAL_NAME.equalsIgnoreCase((var11_13 = (Property)var10_12).getName())) continue;
                        var2_2 = Integer.valueOf(var11_13.getValue());
                    }
                }
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var3_4) {
                try {
                    if (RecLogServiceImpl.tc.isEventEnabled()) {
                        Tr.event(RecLogServiceImpl.tc, "Unable to get compression alarm interval", var3_4);
                    }
                    break block22;
                }
                catch (Throwable var12_14) {
                    throw var12_14;
                }
                finally {
                    if (var1_1 != null) {
                        this.releaseService(var1_1);
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                this.releaseService(var1_1);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (RecLogServiceImpl.tc.isEntryEnabled()) {
            Tr.exit(RecLogServiceImpl.tc, "getCompressionAlarmInterval", var2_2);
        }
        return var2_2;
    }
}

