/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitSectionException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class RecoverableUnitImpl
implements RecoverableUnit {
    private static final TraceComponent tc = Tr.register(RecoverableUnitImpl.class, "Transaction", null);
    protected static short RECORDTYPENORMAL = 1;
    protected static short RECORDTYPEDELETED = (short)2;
    private static int END_OF_SECTIONS = -1;
    private static final int RECORD_HEADER_SIZE = 18;
    private static final int REMOVAL_HEADER_SIZE = 14;
    private static final int TOTAL_HEADER_SIZE = 42;
    private static final int LOCK_REQUEST_ID_RUI_CREATESECTION = 8;
    private static final int LOCK_REQUEST_ID_RUI_WRITESECTIONS = 9;
    private static final int LOCK_REQUEST_ID_RUI_WRITESECTION = 10;
    private static final int LOCK_REQUEST_ID_RUI_FORCESECTIONS = 11;
    private long _identity = 0L;
    private HashMap _recoverableUnitSections = null;
    private boolean _storedOnDisk = false;
    private LogHandle _logHandle = null;
    private Lock _controlLock = null;
    private int _storageMode = 1;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private MultiScopeRecoveryLog _recLog = null;
    private byte[] _deflatedFailureScope = null;
    private FailureScope _failureScope = null;
    private int _recordHeaderSize;
    private int _removalHeaderSize;
    private int _totalHeaderSize;
    private String _serverName = null;
    private String _clientName = null;
    private int _clientVersion = 0;
    private String _logName = null;
    private int _logIdentifier = 0;
    private String _traceId;

    private RecoverableUnitImpl(MultiScopeRecoveryLog multiScopeRecoveryLog, long l, FailureScope failureScope, LogHandle logHandle, int n, Lock lock, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoverableUnitImpl", new Object[]{multiScopeRecoveryLog, new Long(l), failureScope, logHandle, new Integer(n), lock, new Boolean(bl)});
        }
        this._deflatedFailureScope = FailureScopeManager.toByteArray(failureScope);
        this._failureScope = failureScope;
        this._identity = l;
        this._logHandle = logHandle;
        this._controlLock = lock;
        this._recLog = multiScopeRecoveryLog;
        this._storageMode = n;
        this._recordHeaderSize = 18 + this._deflatedFailureScope.length;
        this._removalHeaderSize = 14 + this._deflatedFailureScope.length;
        this._totalHeaderSize = 42 + this._deflatedFailureScope.length;
        this._recoverableUnitSections = new HashMap();
        this._recLog.addRecoverableUnit(this, bl);
        this._serverName = multiScopeRecoveryLog.serverName();
        this._clientName = multiScopeRecoveryLog.clientName();
        this._clientVersion = multiScopeRecoveryLog.clientVersion();
        this._logName = multiScopeRecoveryLog.logName();
        this._logIdentifier = multiScopeRecoveryLog.logIdentifier();
        this._traceId = "RecoverableUnitImpl:serverName=" + this._serverName + ":" + "clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "logName=" + this._logName + ":" + "logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoverableUnitImpl", this);
        }
    }

    RecoverableUnitImpl(MultiScopeRecoveryLog multiScopeRecoveryLog, long l, FailureScope failureScope, LogHandle logHandle, int n, Lock lock) {
        this(multiScopeRecoveryLog, l, failureScope, logHandle, n, lock, false);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoverableUnitImpl", new Object[]{multiScopeRecoveryLog, new Long(l), failureScope, logHandle, new Integer(n), lock});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoverableUnitImpl", this);
        }
    }

    RecoverableUnitImpl(MultiScopeRecoveryLog multiScopeRecoveryLog, long l, FailureScope failureScope, LogHandle logHandle, int n, Lock lock, ReadableLogRecord readableLogRecord) throws InternalLogException, LogCorruptedException {
        this(multiScopeRecoveryLog, l, failureScope, logHandle, n, lock, true);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoverableUnitImpl", new Object[]{multiScopeRecoveryLog, new Long(l), failureScope, logHandle, new Integer(n), lock, readableLogRecord});
        }
        try {
            this.recover(readableLogRecord);
        }
        catch (LogCorruptedException logCorruptedException) {
            FFDCFilter.processException((Throwable)logCorruptedException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.RecoverableUnitImpl", "290", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RecoverableUnitImpl", logCorruptedException);
            }
            throw logCorruptedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.RecoverableUnitImpl", "296", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "RecoverableUnitImpl", internalLogException);
            }
            throw internalLogException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoverableUnitImpl", this);
        }
    }

    public RecoverableUnitSection createSection(int n, boolean bl) throws RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSection", new Object[]{this, new Integer(n), new Boolean(bl)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSection", this);
            }
            throw new InternalLogException(null);
        }
        Integer n2 = new Integer(n);
        RecoverableUnitSectionImpl recoverableUnitSectionImpl = null;
        this._controlLock.getSharedLock(8);
        if (!this._recoverableUnitSections.containsKey(n2)) {
            recoverableUnitSectionImpl = new RecoverableUnitSectionImpl(this._recLog, this, this._identity, n, this._controlLock, this._logHandle, this._storageMode, bl);
            this._recoverableUnitSections.put(n2, recoverableUnitSectionImpl);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoverableUnitImpl '" + this._identity + "' created a new RecoverableUnitSection with identity '" + n + "'");
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoverableUnitImpl '" + this._identity + "' was unable to create a RecoverableUnitSection with id '" + n + "' as it already exists");
            }
            try {
                this._controlLock.releaseSharedLock(8);
            }
            catch (NoSharedLockException noSharedLockException) {
                FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", "212", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSection", "InternalLogException");
                }
                throw new InternalLogException(noSharedLockException);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", "218", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createSection", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSection", "RecoverableUnitSectionExistsException");
            }
            throw new RecoverableUnitSectionExistsException(null);
        }
        try {
            this._controlLock.releaseSharedLock(8);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", "232", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createSection", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSection", recoverableUnitSectionImpl);
        }
        return recoverableUnitSectionImpl;
    }

    public void removeSection(int n) throws InvalidRecoverableUnitSectionException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeSection", new Object[]{this, new Integer(n)});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeSection", "UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    public RecoverableUnitSection lookupSection(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupSection", new Object[]{this, new Integer(n)});
        }
        RecoverableUnitSectionImpl recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this._recoverableUnitSections.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupSection", recoverableUnitSectionImpl);
        }
        return recoverableUnitSectionImpl;
    }

    public void writeSections() throws InternalLogException {
        this.writeSections(false);
    }

    /*
     * Unable to fully structure code
     */
    void writeSections(boolean var1_1) throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry(RecoverableUnitImpl.tc, "writeSections", new Object[]{this, new Boolean(var1_1)});
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(9);
        if (this._unwrittenDataSize > 0 || var1_1 && this._totalDataSize > 0) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug(RecoverableUnitImpl.tc, "Writing recoverable unit '" + this._identity + "'");
                }
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug(RecoverableUnitImpl.tc, "Unwritten data size = " + this._unwrittenDataSize + " total data size = " + this._totalDataSize);
                }
                var2_2 = this._recordHeaderSize;
                var2_2 = var1_1 ? (var2_2 += this._totalDataSize) : (var2_2 += this._unwrittenDataSize);
                var3_7 = this._logHandle.getWriteableLogRecord(var2_2);
                if (var3_7 == null) ** GOTO lbl80
                this.writeRecordHeader(var3_7, RecoverableUnitImpl.RECORDTYPENORMAL);
                var4_11 = this._recoverableUnitSections.values().iterator();
                while (var4_11.hasNext()) {
                    var5_12 = (RecoverableUnitSectionImpl)var4_11.next();
                    var5_12.format(var1_1, var3_7);
                }
                var3_7.putInt(RecoverableUnitImpl.END_OF_SECTIONS);
                var3_7.close();
                this._storedOnDisk = true;
                this._logHandle.writeLogRecord(var3_7);
            }
            catch (IOException var2_3) {
                FFDCFilter.processException((Throwable)var2_3, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "383", this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event(RecoverableUnitImpl.tc, "An unexpected error IO occurred whilst formatting the recovery log buffer", var2_3);
                }
                this._recLog.markFailed(var2_3);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable var3_8) {
                    FFDCFilter.processException(var3_8, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "392", this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
                    }
                    throw new InternalLogException(var3_8);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
                }
                throw new InternalLogException(var2_3);
            }
            catch (InternalLogException var2_4) {
                FFDCFilter.processException((Throwable)var2_4, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "587", this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event(RecoverableUnitImpl.tc, "An InternalLogException exception occured whilst formatting the recovery log buffer", var2_4);
                }
                this._recLog.markFailed(var2_4);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable var3_9) {
                    FFDCFilter.processException(var3_9, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "392", this);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit(RecoverableUnitImpl.tc, "writeSections", var2_4);
                }
                throw var2_4;
            }
            catch (Throwable var2_5) {
                FFDCFilter.processException(var2_5, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "402", this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event(RecoverableUnitImpl.tc, "An unexpected error occurred whilst formatting the recovery log buffer", var2_5);
                }
                this._recLog.markFailed(var2_5);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable var3_10) {
                    FFDCFilter.processException(var3_10, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "411", this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
                    }
                    throw new InternalLogException(var3_10);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
                }
                throw new InternalLogException(var2_5);
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug(RecoverableUnitImpl.tc, "RecoverableUnitImpl has no RecoverableUnitSections that need to be added to the disk record");
        }
lbl80:
        // 5 sources

        try {
            this._controlLock.releaseSharedLock(9);
        }
        catch (NoSharedLockException var2_6) {
            FFDCFilter.processException((Throwable)var2_6, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", "474", this);
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit(RecoverableUnitImpl.tc, "writeSections", "InternalLogException");
            }
            throw new InternalLogException(var2_6);
        }
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit(RecoverableUnitImpl.tc, "writeSections");
        }
    }

    void writeSection(RecoverableUnitSectionImpl recoverableUnitSectionImpl, int n) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeSection", new Object[]{this, recoverableUnitSectionImpl, new Integer(n)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeSection", this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeSection", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(10);
        try {
            int n2;
            WriteableLogRecord writeableLogRecord;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing recoverable unit '" + recoverableUnitSectionImpl.identity() + "'");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unwritten data size = " + n);
            }
            if ((writeableLogRecord = this._logHandle.getWriteableLogRecord(n2 = this._recordHeaderSize + this._unwrittenDataSize)) != null) {
                this.writeRecordHeader(writeableLogRecord, RECORDTYPENORMAL);
                recoverableUnitSectionImpl.format(false, writeableLogRecord);
                writeableLogRecord.putInt(END_OF_SECTIONS);
                writeableLogRecord.close();
                this._storedOnDisk = true;
                this._logHandle.writeLogRecord(writeableLogRecord);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", "755", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An unexpected error IO occurred whilst formatting the recovery log buffer", iOException);
            }
            this._recLog.markFailed(iOException);
            try {
                this._controlLock.releaseSharedLock(10);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", "766", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeSection", "InternalLogException");
                }
                throw new InternalLogException(throwable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeSection", "InternalLogException");
            }
            throw new InternalLogException(iOException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", "776", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An unexpected error occurred whilst formatting the recovery log buffer", throwable);
            }
            this._recLog.markFailed(throwable);
            try {
                this._controlLock.releaseSharedLock(10);
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", "787", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeSection", "InternalLogException");
                }
                throw new InternalLogException(throwable2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeSection", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        try {
            this._controlLock.releaseSharedLock(10);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", "802", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "writeSection", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeSection");
        }
    }

    public void forceSections() throws InternalLogException {
        this.forceSections(false);
    }

    void forceSections(boolean bl) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forceSections", new Object[]{this, new Boolean(bl)});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forceSections", this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.writeSections(bl);
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", "531", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forceSections", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", "537", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forceSections", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        this._controlLock.getSharedLock(11);
        try {
            this._logHandle.force();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", "550", this);
            this._recLog.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forceSections", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", "556", this);
            this._recLog.markFailed(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "forceSections", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        finally {
            try {
                this._controlLock.releaseSharedLock(11);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", "568", this);
                throw new InternalLogException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forceSections");
        }
    }

    public LogCursor sections() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sections", this);
        }
        Collection collection = this._recoverableUnitSections.values();
        LogCursorImpl logCursorImpl = new LogCursorImpl(null, collection, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sections", logCursorImpl);
        }
        return logCursorImpl;
    }

    public long identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "identity", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "identity", new Long(this._identity));
        }
        return this._identity;
    }

    private void recover(ReadableLogRecord readableLogRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{this, readableLogRecord});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", this);
            }
            throw new InternalLogException(null);
        }
        try {
            short s = readableLogRecord.getShort();
            if (s == RECORDTYPEDELETED) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is a DELETION record. Deleting RecoverableUnit from map");
                }
                this._recLog.removeRecoverableUnitMapEntries(this._identity);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "This is a NORMAL record. Decoding contents");
                }
                int n = readableLogRecord.getInt();
                while (n != END_OF_SECTIONS) {
                    RecoverableUnitSectionImpl recoverableUnitSectionImpl;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Recovering RecoverableUnitSection '" + n + "'");
                    }
                    readableLogRecord.getShort();
                    boolean bl = readableLogRecord.getBoolean();
                    if (tc.isDebugEnabled()) {
                        if (bl) {
                            Tr.debug(tc, "RecoverableUnitSection can hold only a single data item");
                        } else {
                            Tr.debug(tc, "RecoverableUnitSection can hold multiple data items");
                        }
                    }
                    if ((recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this._recoverableUnitSections.get(new Integer(n))) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "RecoverableUnitSection " + n + " has not been encountered before. Creating.");
                        }
                        try {
                            recoverableUnitSectionImpl = (RecoverableUnitSectionImpl)this.createSection(n, bl);
                        }
                        catch (RecoverableUnitSectionExistsException recoverableUnitSectionExistsException) {
                            FFDCFilter.processException((Throwable)recoverableUnitSectionExistsException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "713", this);
                        }
                        catch (InternalLogException internalLogException) {
                            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "717", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "An unexpected exception occured when attempting to create a new RecoverableUnitSection");
                            }
                            throw internalLogException;
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "RecoverableUnitSection " + n + " has been encountered before.");
                    }
                    recoverableUnitSectionImpl.recover(readableLogRecord);
                    this._storedOnDisk = true;
                    n = readableLogRecord.getInt();
                }
            }
        }
        catch (LogCorruptedException logCorruptedException) {
            FFDCFilter.processException((Throwable)logCorruptedException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "740", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A LogCorruptedException exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed(logCorruptedException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", logCorruptedException);
            }
            throw logCorruptedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "747", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An InternalLogException exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", internalLogException);
            }
            throw internalLogException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "753", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An exception occured reconstructng a RecoverableUnitImpl");
            }
            this._recLog.markFailed(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover");
        }
    }

    /*
     * Unable to fully structure code
     */
    void remove() throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry(RecoverableUnitImpl.tc, "remove", this);
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit(RecoverableUnitImpl.tc, "remove", this);
            }
            throw new InternalLogException(null);
        }
        if (this._storedOnDisk) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug(RecoverableUnitImpl.tc, "Creating deletion record for recoverable unit '" + this._identity + "'");
                }
                if ((var1_1 = this._logHandle.getWriteableLogRecord(this._removalHeaderSize)) == null) ** GOTO lbl26
                this.writeRecordHeader(var1_1, RecoverableUnitImpl.RECORDTYPEDELETED);
                var1_1.close();
                this._logHandle.writeLogRecord(var1_1);
            }
            catch (Throwable var1_2) {
                FFDCFilter.processException(var1_2, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.remove", "801", this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event(RecoverableUnitImpl.tc, "An unexpected error occurred whilst formatting the recovery log buffer");
                }
                this._recLog.markFailed(var1_2);
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit(RecoverableUnitImpl.tc, "remove", "InternalLogException");
                }
                throw new InternalLogException(var1_2);
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug(RecoverableUnitImpl.tc, "Not writing deletion record because RecoverableUnit '" + this._identity + "' is not on disk");
        }
lbl26:
        // 5 sources

        if (this._unwrittenDataSize > 0) {
            this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize + this._totalHeaderSize);
        } else {
            this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize);
        }
        if (RecoverableUnitImpl.tc.isEventEnabled()) {
            Tr.event(RecoverableUnitImpl.tc, "Remove completed for recoverable unit " + this._identity + ". Clear internal state");
        }
        this._recoverableUnitSections.clear();
        this._totalDataSize = 0;
        this._unwrittenDataSize = 0;
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit(RecoverableUnitImpl.tc, "remove");
        }
    }

    protected void payloadAdded(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadAdded", new Object[]{this, new Integer(n), new Integer(n2)});
        }
        int n3 = n;
        int n4 = n2;
        if (this._unwrittenDataSize == 0) {
            n3 += this._totalHeaderSize;
        }
        if (this._totalDataSize == 0) {
            n4 += this._totalHeaderSize;
        }
        this._unwrittenDataSize += n;
        this._totalDataSize += n2;
        this._recLog.payloadAdded(n3, n4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadAdded");
        }
    }

    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadWritten", new Object[]{this, new Integer(n)});
        }
        this._unwrittenDataSize -= n;
        if (this._unwrittenDataSize == 0) {
            this._recLog.payloadWritten(n + this._totalHeaderSize);
        } else {
            this._recLog.payloadWritten(n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadWritten");
        }
    }

    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadDeleted", new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._totalDataSize -= n;
        this._unwrittenDataSize -= n2;
        if (this._unwrittenDataSize == 0 && n2 != 0) {
            n2 += this._totalHeaderSize;
        }
        if (this._totalDataSize == 0) {
            n += this._totalHeaderSize;
        }
        this._recLog.payloadDeleted(n, n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadDeleted");
        }
    }

    protected static void recover(MultiScopeRecoveryLog multiScopeRecoveryLog, ReadableLogRecord readableLogRecord, LogHandle logHandle, int n, Lock lock) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{multiScopeRecoveryLog, readableLogRecord, logHandle, new Integer(n), lock});
        }
        int n2 = readableLogRecord.getInt();
        byte[] byArray = new byte[n2];
        readableLogRecord.get(byArray);
        try {
            FailureScope failureScope = FailureScopeManager.toFailureScope(byArray);
            long l = readableLogRecord.getLong();
            RecoverableUnitImpl recoverableUnitImpl = multiScopeRecoveryLog.getRecoverableUnit(l);
            if (recoverableUnitImpl == null) {
                recoverableUnitImpl = new RecoverableUnitImpl(multiScopeRecoveryLog, l, failureScope, logHandle, n, lock, readableLogRecord);
            } else {
                recoverableUnitImpl.recover(readableLogRecord);
            }
        }
        catch (LogCorruptedException logCorruptedException) {
            FFDCFilter.processException(logCorruptedException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "1604");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", logCorruptedException);
            }
            throw logCorruptedException;
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException(internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "1608");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", internalLogException);
            }
            throw internalLogException;
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", "1612");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unexpected exception caught", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "InternalLogException");
            }
            throw new InternalLogException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover");
        }
    }

    private void writeRecordHeader(WriteableLogRecord writeableLogRecord, short s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeRecordHeader", new Object[]{writeableLogRecord, new Short(s), this});
        }
        writeableLogRecord.putInt(this._deflatedFailureScope.length);
        writeableLogRecord.put(this._deflatedFailureScope);
        writeableLogRecord.putLong(this._identity);
        writeableLogRecord.putShort(s);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeRecordHeader");
        }
    }

    protected FailureScope failureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "failureScope", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "failureScope", this._failureScope);
        }
        return this._failureScope;
    }

    public String toString() {
        return this._traceId;
    }
}

