/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DataItem;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.SingleDataItem;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.ArrayList;

public class RecoverableUnitSectionImpl
implements RecoverableUnitSection {
    private static final TraceComponent tc = Tr.register(RecoverableUnitSectionImpl.class, "Transaction", null);
    private static final int INITIAL_DATA_CAPACITY = 10;
    protected static short RECORDTYPENORMAL = 1;
    protected static short RECORDTYPEDELETED = (short)2;
    private static final int HEADER_SIZE = 11;
    private static final int LOCK_REQUEST_ID_RUSI_ADDDATA = 3;
    private static final int LOCK_REQUEST_ID_RUSI_WRITE = 4;
    private static final int LOCK_REQUEST_ID_RUSI_FORCE = 5;
    private static final int LOCK_REQUEST_ID_RUSI_FORMAT = 6;
    private static final int LOCK_REQUEST_ID_RUSI_DATA = 7;
    private int _identity = 0;
    private ArrayList _unwrittenData = null;
    private ArrayList _writtenData = null;
    private boolean _singleData = false;
    private DataItem _lastDataItem = null;
    private Lock _controlLock = null;
    private LogHandle _logHandle = null;
    private long _recoverableUnitIdentity = 0L;
    private int _unwrittenDataSize = 0;
    private int _totalDataSize = 0;
    private MultiScopeRecoveryLog _recLog = null;
    private RecoverableUnitImpl _recUnit = null;
    private int _storageMode = 1;
    private String _serverName = null;
    private String _clientName = null;
    private int _clientVersion = 0;
    private String _logName = null;
    private int _logIdentifier = 0;
    private String _traceId;

    RecoverableUnitSectionImpl(MultiScopeRecoveryLog multiScopeRecoveryLog, RecoverableUnitImpl recoverableUnitImpl, long l, int n, Lock lock, LogHandle logHandle, int n2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoverableUnitSectionImpl", new Object[]{multiScopeRecoveryLog, recoverableUnitImpl, new Long(l), new Integer(n), lock, logHandle, new Integer(n2), new Boolean(bl)});
        }
        this._recLog = multiScopeRecoveryLog;
        this._recoverableUnitIdentity = l;
        this._identity = n;
        this._controlLock = lock;
        this._logHandle = logHandle;
        this._singleData = bl;
        this._recUnit = recoverableUnitImpl;
        this._storageMode = n2;
        this._unwrittenData = new ArrayList(10);
        this._writtenData = new ArrayList(10);
        this._serverName = multiScopeRecoveryLog.serverName();
        this._clientName = multiScopeRecoveryLog.clientName();
        this._clientVersion = multiScopeRecoveryLog.clientVersion();
        this._logName = multiScopeRecoveryLog.logName();
        this._logIdentifier = multiScopeRecoveryLog.logIdentifier();
        this._traceId = "RecoverableUnitSectionImpl:serverName=" + this._serverName + ":" + "clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "logName=" + this._logName + ":" + "logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoverableUnitSectionImpl", this);
        }
    }

    public void addData(byte[] byArray) throws InternalLogException {
        DataItem dataItem;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addData", new Object[]{RLSUtils.toHexString(byArray, 32), this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addData", this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(3);
        if (this._singleData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Section can hold only a single data item.");
            }
            if (this._writtenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is existing WRITTEN data. Updating data wrapper.");
                }
                dataItem = (SingleDataItem)this._writtenData.get(0);
                ((SingleDataItem)dataItem).setData(byArray);
                this._writtenData.clear();
                this._unwrittenData.add(0, dataItem);
                this._lastDataItem = dataItem;
            } else if (this._unwrittenData.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is existing UNWRITTEN data. Updating data wrapper.");
                }
                dataItem = (SingleDataItem)this._unwrittenData.get(0);
                ((SingleDataItem)dataItem).setData(byArray);
                this._lastDataItem = dataItem;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no existing data. Creating data wrapper");
                }
                dataItem = new SingleDataItem(this._storageMode, byArray, this);
                this._unwrittenData.add(0, dataItem);
                this._lastDataItem = dataItem;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Section holds multiple data items");
            }
            dataItem = new DataItem(this._storageMode, byArray, this);
            this._unwrittenData.add(dataItem);
            this._lastDataItem = dataItem;
        }
        try {
            this._controlLock.releaseSharedLock(3);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.addData", "382", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addData", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addData");
        }
    }

    public void write() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "write", this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(4);
        if (this._unwrittenDataSize > 0) {
            try {
                this._recUnit.writeSection(this, this._unwrittenDataSize + 11);
            }
            catch (InternalLogException internalLogException) {
                FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", "437", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "write", internalLogException);
                }
                throw internalLogException;
            }
        }
        try {
            this._controlLock.releaseSharedLock(4);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.write", "449", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "write", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "write");
        }
    }

    public void force() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "force", this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", this);
            }
            throw new InternalLogException(null);
        }
        try {
            this.write();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", "509", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", internalLogException);
            }
            throw internalLogException;
        }
        this._controlLock.getSharedLock(5);
        try {
            this._logHandle.force();
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", "522", this);
            this._recLog.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "force", internalLogException);
            }
            throw internalLogException;
        }
        finally {
            try {
                this._controlLock.releaseSharedLock(5);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.force", "535", this);
                throw new InternalLogException(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "force");
        }
    }

    void format(boolean bl, WriteableLogRecord writeableLogRecord) throws IOException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "format", new Object[]{new Boolean(bl), writeableLogRecord, this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "format", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(6);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this._writtenData != null) {
            n2 = this._writtenData.size();
        }
        if (this._unwrittenData != null) {
            n3 = this._unwrittenData.size();
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Section has '" + n3 + "' unwritten data items and '" + n2 + "' written data items to write");
            }
            n = n3 + n2;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Section has '" + n3 + "' unwritten data items and '0' written data items to write");
            }
            n = n3;
        }
        if (n > 0) {
            int n4;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing section identity '" + this._identity + "'");
            }
            writeableLogRecord.putInt(this._identity);
            writeableLogRecord.putShort(RECORDTYPENORMAL);
            writeableLogRecord.putBoolean(this._singleData);
            writeableLogRecord.putInt(n);
            if (bl) {
                for (n4 = 0; n4 < n2; ++n4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Writing written data item '" + n4 + "'");
                    }
                    ((DataItem)this._writtenData.get(n4)).write(writeableLogRecord);
                }
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Writing unwritten data item '" + n4 + "'");
                }
                DataItem dataItem = (DataItem)this._unwrittenData.get(n4);
                dataItem.write(writeableLogRecord);
                this._writtenData.add(dataItem);
            }
            if (n3 > 0) {
                this._unwrittenData.clear();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RecoverableUnitSectionImpl '" + this._identity + "' has no data to format");
        }
        try {
            this._controlLock.releaseSharedLock(6);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.format", "670", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "format", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "format");
        }
    }

    public LogCursor data() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "data", this);
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "data", this);
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(7);
        if (tc.isEventEnabled()) {
            int n = 0;
            int n2 = 0;
            if (this._writtenData != null) {
                n = this._writtenData.size();
            }
            if (this._unwrittenData != null) {
                n2 = this._unwrittenData.size();
            }
            Tr.event(tc, "#writtenDataBlocks = " + n + " #unwrittenDataBlocks = " + n2);
        }
        LogCursorImpl logCursorImpl = null;
        logCursorImpl = this._singleData ? (this._writtenData.size() > 0 ? new LogCursorImpl(null, ((DataItem)this._writtenData.get(0)).getData()) : new LogCursorImpl(null, ((DataItem)this._unwrittenData.get(0)).getData())) : new LogCursorImpl(null, this._writtenData, this._unwrittenData, false, null);
        try {
            this._controlLock.releaseSharedLock(7);
        }
        catch (NoSharedLockException noSharedLockException) {
            FFDCFilter.processException((Throwable)noSharedLockException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.data", "766", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "data", "InternalLogException");
            }
            throw new InternalLogException(noSharedLockException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "data", new Integer(logCursorImpl.initialSize()));
        }
        return logCursorImpl;
    }

    public int identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "identity", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "identity", new Integer(this._identity));
        }
        return this._identity;
    }

    void recover(ReadableLogRecord readableLogRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recover", new Object[]{readableLogRecord, this});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "InternalLogException");
            }
            throw new InternalLogException(null);
        }
        try {
            int n = readableLogRecord.getInt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Recovering '" + n + "' data items");
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Recovering data item '" + i + "'");
                }
                DataItem dataItem = null;
                if (this._singleData) {
                    if (this._writtenData.size() > 0) {
                        dataItem = (DataItem)this._writtenData.get(0);
                    }
                    if (dataItem == null) {
                        dataItem = new SingleDataItem(this._storageMode, readableLogRecord, this);
                        this._writtenData.add(dataItem);
                    } else {
                        ((SingleDataItem)dataItem).setData(readableLogRecord);
                        this._writtenData.set(0, dataItem);
                    }
                } else {
                    dataItem = new DataItem(this._storageMode, readableLogRecord, this);
                    this._writtenData.add(dataItem);
                }
                this._lastDataItem = dataItem;
            }
        }
        catch (InternalLogException internalLogException) {
            FFDCFilter.processException((Throwable)internalLogException, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", "876", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An InternalLogException occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed(internalLogException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "LogCorruptedException");
            }
            throw new LogCorruptedException(internalLogException);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl.recover", "884", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An exception occured reconstructng a RecoverableUnitSectionImpl");
            }
            this._recLog.markFailed(throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recover", "InternalLogException");
            }
            throw new InternalLogException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recover");
        }
    }

    public byte[] lastData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lastData", this);
        }
        byte[] byArray = null;
        if (this._lastDataItem != null) {
            byArray = this._lastDataItem.getData();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lastData", RLSUtils.toHexString(byArray, 32));
        }
        return byArray;
    }

    protected void payloadAdded(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadAdded", new Object[]{this, new Integer(n)});
        }
        int n2 = n;
        int n3 = n;
        if (this._unwrittenDataSize == 0) {
            n2 += 11;
        }
        if (this._totalDataSize == 0) {
            n3 += 11;
        }
        this._unwrittenDataSize += n;
        this._totalDataSize += n;
        this._recUnit.payloadAdded(n2, n3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadAdded");
        }
    }

    protected void payloadWritten(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadWritten", new Object[]{this, new Integer(n)});
        }
        this._unwrittenDataSize -= n;
        if (this._unwrittenDataSize == 0) {
            this._recUnit.payloadWritten(n + 11);
        } else {
            this._recUnit.payloadWritten(n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadWritten");
        }
    }

    protected void payloadDeleted(int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "payloadDeleted", new Object[]{this, new Integer(n), new Integer(n2)});
        }
        this._totalDataSize -= n;
        this._unwrittenDataSize -= n2;
        if (this._unwrittenDataSize == 0 && n2 != 0) {
            n2 += 11;
        }
        if (this._totalDataSize == 0) {
            n += 11;
        }
        this._recUnit.payloadDeleted(n, n2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "payloadDeleted");
        }
    }

    public String toString() {
        return this._traceId;
    }
}

