/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class RecoveryDirectorFactory {
    private static final TraceComponent tc = Tr.register(RecoveryDirectorFactory.class, "Transaction", null);
    private static RecoveryDirector _recoveryDirector = null;

    private RecoveryDirectorFactory() {
    }

    public static RecoveryDirector recoveryDirector() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryDirector");
        }
        if (_recoveryDirector == null) {
            String string = null;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            string = platformHelper.isControlJvm() ? new String("com.ibm.ws390.recoverylog.spi.ControllerRecoveryDirectorImpl") : (platformHelper.isServantJvm() ? new String("com.ibm.ws390.recoverylog.spi.ServantRecoveryDirectorImpl") : new String("com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using RecoveryDirector class " + string);
            }
            final String string2 = string;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block4: {
                            if (tc.isEntryEnabled()) {
                                Tr.entry(tc, "run", this);
                            }
                            try {
                                Class<?> clazz = Class.forName(string2);
                                Method method2 = clazz.getMethod("instance", null);
                                _recoveryDirector = (RecoveryDirector)method2.invoke(null, null);
                            }
                            catch (Throwable throwable) {
                                FFDCFilter.processException(throwable, "com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory.run", "123", this);
                                _recoveryDirector = null;
                                if (!tc.isEventEnabled()) break block4;
                                Tr.event(tc, "Error encountered accessing singleton RecoveryDirector: ", throwable);
                            }
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "run");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException(privilegedActionException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory.recoveryDirector", "134");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Error encountered accessing singleton RecoveryDirector: ", privilegedActionException);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "recoveryDirector");
                }
                throw new InternalLogException(privilegedActionException);
            }
        }
        if (_recoveryDirector == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "recoveryDirector");
            }
            throw new InternalLogException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryDirector", _recoveryDirector);
        }
        return _recoveryDirector;
    }
}

