/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.serverindex.RecoveryLog;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.ConflictingCredentialsException;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidStateException;
import com.ibm.ws.recoverylog.spi.RLSHAGroupCallback;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryEventListener;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogCallBack;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl;
import com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import com.ibm.ws.wsaddressing.HAResource;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.NoClusterDefinedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class RecoveryDirectorImpl
implements RecoveryDirector,
HAResource {
    private static final TraceComponent tc = Tr.register(RecoveryDirectorImpl.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    public static final int CALLBACK_RECOVERYSTARTED = 1;
    public static final int CALLBACK_RECOVERYCOMPLETE = 2;
    public static final int CALLBACK_TERMINATIONSTARTED = 3;
    public static final int CALLBACK_TERMINATIONCOMPLETE = 4;
    public static final int CALLBACK_RECOVERYFAILED = 5;
    private static final String CLUSTER_KEY = "RLS_CLUSTER_KEY";
    private static RecoveryDirectorImpl _instance = null;
    private TreeMap _registeredRecoveryAgents = null;
    private HashMap _outstandingInitializationRecords = null;
    private HashMap _outstandingRecoveryRecords = null;
    private HashMap _outstandingTerminationRecords = null;
    private boolean _registrationAllowed = true;
    private FailureScope _currentFailureScope = null;
    private HashSet _registeredCallbacks = new HashSet();
    ClusterService _clusterService = null;
    private HashMap _clusterIdentities = null;
    private RecoveryEventListener _eventListeners = null;
    private HashSet _initFailedFailureScopes = null;

    private RecoveryDirectorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryDirectorImpl");
        }
        this._registeredRecoveryAgents = new TreeMap();
        this._outstandingInitializationRecords = new HashMap();
        this._outstandingRecoveryRecords = new HashMap();
        this._clusterIdentities = new HashMap();
        this._outstandingTerminationRecords = new HashMap();
        this._initFailedFailureScopes = new HashSet();
        this._clusterService = ClusterServiceFactory.getClusterService();
        this._eventListeners = RegisteredRecoveryEventListeners.instance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryDirectorImpl", this);
        }
    }

    public static synchronized RecoveryDirector instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instance");
        }
        if (_instance == null) {
            _instance = new RecoveryDirectorImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instance", _instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecoveryLogManager registerService(RecoveryAgent recoveryAgent, int n) throws ConflictingCredentialsException, InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerService", new Object[]{recoveryAgent, new Integer(n), this});
        }
        RecoveryLogManagerImpl recoveryLogManagerImpl = null;
        TreeMap treeMap = this._registeredRecoveryAgents;
        synchronized (treeMap) {
            ArrayList arrayList;
            Serializable serializable;
            if (!this._registrationAllowed) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Client service registration attempted after recovery processing has been driven");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerService", "InvalidStateException");
                }
                throw new InvalidStateException(null);
            }
            int n2 = recoveryAgent.clientIdentifier();
            String string = recoveryAgent.clientName();
            Collection collection = this._registeredRecoveryAgents.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                serializable = (ArrayList)iterator.next();
                arrayList = serializable.iterator();
                while (arrayList.hasNext()) {
                    RecoveryAgent recoveryAgent2 = (RecoveryAgent)arrayList.next();
                    if (recoveryAgent2.clientIdentifier() != n2 && !recoveryAgent2.clientName().equals(string)) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Client service registration attempted with non-unique identity or name");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "registerService", "ConflictingCredentialsException");
                    }
                    throw new ConflictingCredentialsException(null);
                }
            }
            serializable = new Integer(n);
            arrayList = (ArrayList)this._registeredRecoveryAgents.get(serializable);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this._registeredRecoveryAgents.put(serializable, arrayList);
            }
            arrayList.add(recoveryAgent);
            recoveryLogManagerImpl = new RecoveryLogManagerImpl(recoveryAgent);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "New service '" + string + "' (" + n2 + ") registered with RecoveryDirectorImpl");
            }
            if (n2 == 1) {
                Configuration.txRecoveryAgent(recoveryAgent);
                Configuration.setSnapshotSafe(recoveryAgent.isSnapshotSafe());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerService", recoveryLogManagerImpl);
        }
        return recoveryLogManagerImpl;
    }

    public void serialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialRecoveryComplete", new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(bl = this.removeInitializationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serialRecoveryComplete", "InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        this._eventListeners.clientRecoveryComplete(failureScope, recoveryAgent.clientIdentifier());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialRecoveryComplete");
        }
    }

    public void terminationComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminationComplete", new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(bl = this.removeTerminationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The supplied FailureScope was not recognized as an outstaning termination request for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "terminationComplete", "InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminationComplete");
        }
    }

    public synchronized FailureScope currentFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "currentFailureScope", this);
        }
        if (this._currentFailureScope == null) {
            this._currentFailureScope = new FileFailureScope();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "currentFailureScope", this._currentFailureScope);
        }
        return this._currentFailureScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directInitialization(FailureScope failureScope) throws RecoveryFailedException {
        RecoveryAgent recoveryAgent;
        Iterator iterator;
        ArrayList arrayList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "directInitialization", new Object[]{failureScope, this});
        }
        FailureScope failureScope2 = Configuration.localFailureScope();
        Object object = this._registeredRecoveryAgents;
        synchronized (object) {
            this._registrationAllowed = false;
        }
        if (failureScope2.equals(failureScope)) {
            Tr.info(tc, "CWRLS0010_PERFORM_LOCAL_RECOVERY", failureScope.serverName());
        } else {
            Tr.info(tc, "CWRLS0011_PERFORM_PEER_RECOVERY", failureScope.serverName());
        }
        object = this._registeredRecoveryAgents.values();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            arrayList = (ArrayList)iterator2.next();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                recoveryAgent = (RecoveryAgent)iterator.next();
                recoveryAgent.prepareForRecovery(failureScope);
                this.addInitializationRecord(recoveryAgent, failureScope);
                this.addRecoveryRecord(recoveryAgent, failureScope);
            }
        }
        if (Configuration.HAEnabled()) {
            this.joinCluster(failureScope);
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(1, failureScope);
        }
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            arrayList = (ArrayList)iterator2.next();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                recoveryAgent = (RecoveryAgent)iterator.next();
                try {
                    this._eventListeners.clientRecoveryInitiated(failureScope, recoveryAgent.clientIdentifier());
                    recoveryAgent.initiateRecovery(failureScope);
                }
                catch (RecoveryFailedException recoveryFailedException) {
                    FFDCFilter.processException((Throwable)recoveryFailedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directInitialization", "410", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "directInitialization", recoveryFailedException);
                    }
                    throw recoveryFailedException;
                }
                HashMap hashMap = this._outstandingInitializationRecords;
                synchronized (hashMap) {
                    while (this.initializationOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingInitializationRecords.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directInitialization", "432", this);
                        }
                    }
                }
            }
        }
        if (failureScope2.equals(failureScope)) {
            Tr.info(tc, "CWRLS0012_DIRECT_LOCAL_RECOVERY", failureScope.serverName());
        } else {
            Tr.info(tc, "CWRLS0013_DIRECT_PEER_RECOVERY", failureScope.serverName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "directInitialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directTermination(FailureScope failureScope) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "directTermination", new Object[]{failureScope, this});
        }
        Tr.info(tc, "CWRLS0014_HALT_PEER_RECOVERY", failureScope.serverName());
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(3, failureScope);
        }
        if (Configuration.HAEnabled()) {
            this.leaveCluster(failureScope);
        }
        Collection collection = this._registeredRecoveryAgents.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList = (ArrayList)iterator.next();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                RecoveryAgent recoveryAgent = (RecoveryAgent)iterator2.next();
                this.addTerminationRecord(recoveryAgent, failureScope);
                try {
                    recoveryAgent.terminateRecovery(failureScope);
                }
                catch (TerminationFailedException terminationFailedException) {
                    FFDCFilter.processException((Throwable)terminationFailedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", "540", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "directTermination", terminationFailedException);
                    }
                    throw terminationFailedException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", "576", this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "directTermination", exception);
                    }
                    throw new TerminationFailedException(exception);
                }
                HashMap hashMap = this._outstandingTerminationRecords;
                synchronized (hashMap) {
                    while (this.terminationOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingTerminationRecords.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", "549", this);
                        }
                    }
                }
            }
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(4, failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "directTermination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInitializationRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> hashSet = (HashSet<FailureScope>)this._outstandingInitializationRecords.get(recoveryAgent);
            if (hashSet == null) {
                hashSet = new HashSet<FailureScope>();
                this._outstandingInitializationRecords.put(recoveryAgent, hashSet);
            }
            hashSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInitializationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTerminationRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> hashSet = (HashSet<FailureScope>)this._outstandingTerminationRecords.get(recoveryAgent);
            if (hashSet == null) {
                hashSet = new HashSet<FailureScope>();
                this._outstandingTerminationRecords.put(recoveryAgent, hashSet);
            }
            hashSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTerminationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeInitializationRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingInitializationRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.remove(failureScope);
            }
            this._outstandingInitializationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeInitializationRecord", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTerminationRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingTerminationRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.remove(failureScope);
            }
            this._outstandingTerminationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTerminationRecord", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializationOutstanding", new Object[]{recoveryAgent, failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingInitializationRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializationOutstanding", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean terminationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "terminationOutstanding", new Object[]{recoveryAgent, failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingTerminationRecords.get(recoveryAgent);
            if (hashSet != null) {
                bl = hashSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "terminationOutstanding", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void driveLocalRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "driveLocalRecovery", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RLSHA: configuring for local only recovery");
        }
        RecoveryDirectorImpl recoveryDirectorImpl = this;
        synchronized (recoveryDirectorImpl) {
            if (this._currentFailureScope == null) {
                this._currentFailureScope = new FileFailureScope();
            }
        }
        try {
            this.directInitialization(this._currentFailureScope);
        }
        catch (RecoveryFailedException recoveryFailedException) {
            FFDCFilter.processException((Throwable)recoveryFailedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.driveLocalRecovery", "620", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "driveLocalRecovery", recoveryFailedException);
            }
            throw recoveryFailedException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveLocalRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRecoveryRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> hashSet = (HashSet<RecoveryAgent>)this._outstandingRecoveryRecords.get(failureScope);
            if (hashSet == null) {
                hashSet = new HashSet<RecoveryAgent>();
                this._outstandingRecoveryRecords.put(failureScope, hashSet);
            }
            hashSet.add(recoveryAgent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRecoveryRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoveryRecord", new Object[]{recoveryAgent, failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingRecoveryRecords.get(failureScope);
            if (hashSet != null) {
                bl = hashSet.remove(recoveryAgent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoveryRecord", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoveryOutstanding(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryOutstanding", new Object[]{failureScope, this});
        }
        boolean bl = false;
        HashMap hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet hashSet = (HashSet)this._outstandingRecoveryRecords.get(failureScope);
            if (hashSet != null && hashSet.size() > 0) {
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryOutstanding", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialRecoveryComplete", new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(bl = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialRecoveryComplete", "InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            boolean bl2 = false;
            HashSet hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                bl2 = this._initFailedFailureScopes.remove(failureScope);
            }
            if (!bl2) {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(2, failureScope);
                }
                if (failureScope.equals(Configuration.localFailureScope()) && Configuration.HAEnabled()) {
                    RecLogServiceImpl.enablePeerRecovery();
                }
            } else {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(5, failureScope);
                }
                if (Configuration.localFailureScope().equals(failureScope)) {
                    RLSHAGroupCallback.localRecoveryFailed();
                } else {
                    block18: {
                        try {
                            this.directTermination(failureScope);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.initialRecoveryComplete", "1399", this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "initialRecoveryComplete", "An unexpected excetion occured whilst terminating recovery processing");
                        }
                    }
                    RecLogServiceImpl.deactivateGroup(failureScope, 60);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialRecoveryComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialRecoveryFailed(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialRecoveryFailed", new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(bl = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialRecoveryFailed", "InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            if (this._registeredCallbacks != null) {
                this.driveCallBacks(5, failureScope);
            }
            HashSet hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.remove(failureScope);
            }
            if (Configuration.localFailureScope().equals(failureScope)) {
                RLSHAGroupCallback.localRecoveryFailed();
            } else {
                try {
                    this.directTermination(failureScope);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RecLogServiceImpl.deactivateGroup(failureScope, 60);
            }
        } else {
            HashSet hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.add(failureScope);
            }
            int n = recoveryAgent.clientIdentifier();
            Collection collection = this._registeredRecoveryAgents.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList = (ArrayList)iterator.next();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    RecoveryAgent recoveryAgent2 = (RecoveryAgent)iterator2.next();
                    if (recoveryAgent2.clientIdentifier() == n) continue;
                    recoveryAgent2.agentReportedFailure(n, failureScope);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialRecoveryFailed");
        }
    }

    public synchronized void addCallBack(RecoveryLogCallBack recoveryLogCallBack) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCallBack", recoveryLogCallBack);
        }
        if (this._registeredCallbacks == null) {
            this._registeredCallbacks = new HashSet();
        }
        this._registeredCallbacks.add(recoveryLogCallBack);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCallBack");
        }
    }

    private void driveCallBacks(int n, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            switch (n) {
                case 1: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{"CALLBACK_RECOVERYSTARTED", failureScope});
                    break;
                }
                case 2: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{"CALLBACK_RECOVERYCOMPLETE", failureScope});
                    break;
                }
                case 3: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{"CALLBACK_TERMINATIONSTARTED", failureScope});
                    break;
                }
                case 4: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{"CALLBACK_TERMINATIONCOMPLETE", failureScope});
                    break;
                }
                case 5: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{"CALLBACK_RECOVERYFAILED", failureScope});
                    break;
                }
                default: {
                    Tr.entry(tc, "driveCallBacks", new Object[]{new Integer(n), failureScope});
                }
            }
        }
        if (this._registeredCallbacks != null) {
            Iterator iterator = this._registeredCallbacks.iterator();
            while (iterator.hasNext()) {
                RecoveryLogCallBack recoveryLogCallBack = (RecoveryLogCallBack)iterator.next();
                switch (n) {
                    case 1: {
                        recoveryLogCallBack.recoveryStarted(failureScope);
                        break;
                    }
                    case 2: 
                    case 5: {
                        recoveryLogCallBack.recoveryCompleted(failureScope);
                        break;
                    }
                    case 3: {
                        recoveryLogCallBack.terminateStarted(failureScope);
                        break;
                    }
                    case 4: {
                        recoveryLogCallBack.terminateCompleted(failureScope);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveCallBacks");
        }
    }

    public RecoveryLog getRecoveryLogConfiguration(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryLogConfiguration", failureScope);
        }
        RecoveryLog recoveryLog = RecLogServiceImpl.getRecoveryLogConfig(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryLogConfiguration", recoveryLog);
        }
        return recoveryLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinCluster(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "joinCluster", failureScope);
        }
        boolean bl = true;
        String string = failureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RLSHA: joining cluster RLS_CLUSTER_KEY = " + string);
        }
        HashMap hashMap = this._clusterIdentities;
        synchronized (hashMap) {
            Identity identity = (Identity)this._clusterIdentities.get(failureScope);
            if (identity == null) {
                identity = this.buildClusterIdentity(string);
                this._clusterIdentities.put(failureScope, identity);
            }
            try {
                Configuration.clusterMemberService().joinCluster(identity);
            }
            catch (NoClusterDefinedException noClusterDefinedException) {
                FFDCFilter.processException((Throwable)noClusterDefinedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.joinCluster", "1294", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "The cluster definition was not recognized when joining the dynamic cluser", noClusterDefinedException);
                }
                bl = false;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.joinCluster", "1300", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "An unexpected error occured when joining the dynamic cluser", exception);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "joinCluster", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean leaveCluster(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "leaveCluster", failureScope);
        }
        boolean bl = true;
        String string = failureScope.serverName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RLSHA: leaving cluster RLS_CLUSTER_KEY = " + string);
        }
        HashMap hashMap = this._clusterIdentities;
        synchronized (hashMap) {
            Identity identity = (Identity)this._clusterIdentities.get(failureScope);
            if (identity != null) {
                try {
                    Configuration.clusterMemberService().disjoinCluster(identity);
                }
                catch (NoClusterDefinedException noClusterDefinedException) {
                    FFDCFilter.processException((Throwable)noClusterDefinedException, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.leaveCluster", "1338", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "The cluster definition was not recognized when leaving the dynamic cluser", noClusterDefinedException);
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.leaveCluster", "1344", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "An unexpected error occured when leaving the dynamic cluser", exception);
                    }
                    bl = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "leaveCluster", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity clusterIdentity(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterIdentity", failureScope);
        }
        Identity identity = null;
        if (Configuration.HAEnabled()) {
            HashMap hashMap = this._clusterIdentities;
            synchronized (hashMap) {
                identity = (Identity)this._clusterIdentities.get(failureScope);
                if (identity == null) {
                    identity = this.buildClusterIdentity(failureScope.serverName());
                    this._clusterIdentities.put(failureScope, identity);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterIdentity", identity);
        }
        return identity;
    }

    private Identity buildClusterIdentity(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildClusterIdentity", string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CLUSTER_KEY, string);
        Identity identity = this._clusterService.getIdentity(hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildClusterIdentity", identity);
        }
        return identity;
    }

    public String getNonNullCurrentFailureScopeIDString() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonNullCurrentFailureScopeIDString");
        }
        String string = this._clusterService.identityToString(this.buildClusterIdentity(this.currentFailureScope().serverName()));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonNullCurrentFailureScopeIDString", string);
        }
        return string;
    }

    public void registerRecoveryEventListener(RecoveryEventListener recoveryEventListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerRecoveryEventListener", recoveryEventListener);
        }
        RegisteredRecoveryEventListeners.instance().add(recoveryEventListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerRecoveryEventListener");
        }
    }

    public boolean isHAEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHAEnabled");
        }
        boolean bl = Configuration.HAEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHAEnabled", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identity getAffinityKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAffinityKey");
        }
        Identity identity = null;
        if (Configuration.HAEnabled()) {
            HashMap hashMap = this._clusterIdentities;
            synchronized (hashMap) {
                identity = (Identity)this._clusterIdentities.get(this._currentFailureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAffinityKey", identity);
        }
        return identity;
    }
}

