/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.CoordinationLock;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.RLSHAGroupCallback;
import com.ibm.ws.recoverylog.spi.RecLogServiceImpl;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws390.recoverylog.spi.ControllerRecoveryDirectorImpl;
import java.io.File;

public class RecoveryHandler
extends Thread {
    private static final TraceComponent tc = Tr.register(RecoveryHandler.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private RecoveryDirector _recoveryDirector;
    private boolean _localRecoveryRequest;
    private FailureScope _failureScope;
    private CoordinationLock _fileLock;
    private RLSHAGroupCallback _rlsHAGroupCallback;
    private boolean _complete;

    public RecoveryHandler(RLSHAGroupCallback rLSHAGroupCallback, FailureScope failureScope, boolean bl) {
        block4: {
            this._recoveryDirector = null;
            this._localRecoveryRequest = false;
            this._failureScope = null;
            this._fileLock = null;
            this._rlsHAGroupCallback = null;
            this._complete = false;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RecoveryHandler", new Object[]{rLSHAGroupCallback, failureScope, new Boolean(bl)});
            }
            try {
                this._recoveryDirector = RecoveryDirectorFactory.recoveryDirector();
            }
            catch (InternalLogException internalLogException) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "No director", internalLogException);
            }
        }
        this._failureScope = failureScope;
        this._localRecoveryRequest = bl;
        this._rlsHAGroupCallback = rLSHAGroupCallback;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryHandler");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block41: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run", this._failureScope);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RLSHA: STARTING RecoveryHandler for failure scope " + this._failureScope);
            }
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = false;
            String[] stringArray = null;
            RecoveryAgent recoveryAgent = Configuration.txRecoveryAgent();
            try {
                if (!this._localRecoveryRequest && recoveryAgent != null && (stringArray = recoveryAgent.logDirectories(this._failureScope)) != null && !((File)(object = new File(stringArray[0]))).exists()) {
                    bl3 = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No log directory found for peer recovery -- nothing to recover");
                    }
                }
                if (bl3) break block41;
                if (Configuration.useFileLocking() && Configuration.HAEnabled() && !RecLogServiceImpl.isHardwareQuorumEnforced(this._failureScope)) {
                    if (recoveryAgent != null) {
                        if (recoveryAgent.disableFileLocking()) {
                            Tr.info(tc, "CWRLS0015_DISABLE_FILE_LOCKING");
                        } else {
                            stringArray = recoveryAgent.logDirectories(this._failureScope);
                            if (stringArray != null) {
                                object = stringArray[0] + File.separator + "tranlog";
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Lock coordination directory is " + (String)object);
                                }
                                this._fileLock = new CoordinationLock((String)object);
                                int n = this._fileLock.lock();
                                if (n == 2) {
                                    Tr.error(tc, "CWRLS0016_RECOVERY_PROCESSING_FAILED", this._failureScope.serverName());
                                    bl = false;
                                } else if (n == 4) {
                                    Tr.info(tc, "CWRLS0017_RECOVERY_PROCESSING_INTERRUPTED", this._failureScope.serverName());
                                    bl = false;
                                    bl2 = true;
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "The file was locked sucessfully");
                                }
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Attempt to obtain a file lock failed: No Log Directory Information provided by the Transaction Service");
                                }
                                bl = false;
                            }
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Attempt to obtain a file lock failed: No Transaction Service RecoveryAgent available.");
                        }
                        bl = false;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "File locking is disabled");
                }
                if (bl) {
                    try {
                        if (Configuration.isZOS()) {
                            ((ControllerRecoveryDirectorImpl)this._recoveryDirector).driveRecovery(this._failureScope, null);
                            break block41;
                        }
                        ((RecoveryDirectorImpl)this._recoveryDirector).directInitialization(this._failureScope);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryHandler.memberIsActivated", "150", this);
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Failed recovery initilaization for failure scope " + this._failureScope + " with " + exception);
                        }
                        if (this._localRecoveryRequest) {
                            RLSHAGroupCallback.localRecoveryFailed();
                        }
                        break block41;
                    }
                }
                if (!bl2) {
                    if (this._localRecoveryRequest) {
                        RLSHAGroupCallback.localRecoveryFailed();
                    } else {
                        RecLogServiceImpl.deactivateGroup(this._failureScope, 60);
                    }
                }
            }
            finally {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "RLSHA: RecoveryHandler has completed for failure scope." + this._failureScope);
                }
                object = this;
                synchronized (object) {
                    this._complete = true;
                    this.notifyAll();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interrupt");
        }
        RecoveryHandler recoveryHandler = this;
        synchronized (recoveryHandler) {
            if (!this._complete) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RLSHA: INTERRRUPT recovery handler for failure scope " + this._failureScope);
                }
                if (this._fileLock != null) {
                    this._fileLock.interrupt();
                }
                while (!this._complete) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Waiting for recovery handler to complete..");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.recoverylog.spi.RLSHAGroupCallback", "373", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Thread thread was interrupted unexpectedly during wait. Retesting condition");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interrupt");
        }
    }

    public void clearLock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearLock");
        }
        if (this._fileLock != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RLSHA: release file lock");
            }
            this._fileLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearLock");
        }
    }
}

