/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitImpl;

public class RecoveryLogImpl
implements DistributedRecoveryLog {
    private static final TraceComponent tc = Tr.register(RecoveryLogImpl.class, "Transaction", null);
    private MultiScopeRecoveryLog _recoveryLog;
    private FailureScope _failureScope;

    public RecoveryLogImpl(MultiScopeRecoveryLog multiScopeRecoveryLog, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryLogImpl", new Object[]{multiScopeRecoveryLog, failureScope});
        }
        this._recoveryLog = multiScopeRecoveryLog;
        this._failureScope = failureScope;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryLogImpl", this);
        }
    }

    public void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openLog", this);
        }
        this._recoveryLog.openLog();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openLog");
        }
    }

    public void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", this);
        }
        this._recoveryLog.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLog");
        }
    }

    public void closeLog(byte[] byArray) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLog", new Object[]{byArray, this});
        }
        this._recoveryLog.closeLog(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLog");
        }
    }

    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "closeLogImmediate", this);
        }
        this._recoveryLog.closeLogImmediate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "closeLogImmediate");
        }
    }

    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete", this);
        }
        this._recoveryLog.recoveryComplete();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    public void recoveryComplete(byte[] byArray) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoveryComplete", new Object[]{byArray, this});
        }
        this._recoveryLog.recoveryComplete(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoveryComplete");
        }
    }

    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "keypoint", this);
        }
        this._recoveryLog.keypoint();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "keypoint");
        }
    }

    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serviceData", this);
        }
        byte[] byArray = this._recoveryLog.serviceData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serviceData", RLSUtils.toHexString(byArray, 32));
        }
        return byArray;
    }

    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRecoverableUnit", this);
        }
        RecoverableUnit recoverableUnit = this._recoveryLog.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRecoverableUnit", recoverableUnit);
        }
        return recoverableUnit;
    }

    public void removeRecoverableUnit(long l) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRecoverableUnit", new Object[]{new Long(l), this});
        }
        this._recoveryLog.removeRecoverableUnit(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRecoverableUnit");
        }
    }

    public RecoverableUnit lookupRecoverableUnit(long l) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "lookupRecoverableUnit", new Object[]{new Long(l), this});
        }
        RecoverableUnitImpl recoverableUnitImpl = this._recoveryLog.getRecoverableUnit(l);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "lookupRecoverableUnit", recoverableUnitImpl);
        }
        return recoverableUnitImpl;
    }

    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recoverableUnits", this);
        }
        LogCursor logCursor = this._recoveryLog.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recoverableUnits", logCursor);
        }
        return logCursor;
    }

    public LogProperties logProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logProperties", this);
        }
        LogProperties logProperties = this._recoveryLog.logProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logProperties", logProperties);
        }
        return logProperties;
    }

    public String toString() {
        return "" + this._recoveryLog + " [" + this._failureScope + "]";
    }
}

