/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileLogProperties;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLogImpl;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.StreamLogProperties;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class RecoveryLogManagerImpl
implements RecoveryLogManager {
    private static final TraceComponent tc = Tr.register(RecoveryLogManagerImpl.class, "Transaction", null);
    private String _clientName = null;
    private int _clientIdentity = 0;
    private int _clientVersion = 0;
    private static String _fileSeparator = null;
    private RecoveryAgent _recoveryAgent = null;
    private HashMap _recoveryLogs = null;
    private HashMap _multiScopeRecoveryLogs = null;
    private String _traceId;

    RecoveryLogManagerImpl(RecoveryAgent recoveryAgent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryLogManagerImpl", recoveryAgent);
        }
        this._recoveryAgent = recoveryAgent;
        this._clientName = this._recoveryAgent.clientName();
        this._clientVersion = this._recoveryAgent.clientVersion();
        this._clientIdentity = this._recoveryAgent.clientIdentifier();
        this._recoveryLogs = new HashMap();
        this._multiScopeRecoveryLogs = new HashMap();
        this._traceId = "RecoveryLogManagerImpl:clientName=" + this._clientName + ":" + "clientVersion=" + this._clientVersion + ":" + "clientIdentity=" + this._clientIdentity + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryLogManagerImpl", this);
        }
    }

    public synchronized RecoveryLog getRecoveryLog(FailureScope failureScope, LogProperties logProperties) throws InvalidLogPropertiesException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryLog", new Object[]{failureScope, logProperties, this});
        }
        if (logProperties instanceof StreamLogProperties) {
            object = AdminHelper.getPlatformHelper();
            if (!object.isZOS()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to create stream based recovery log on non-ZOS platform");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRecoveryLog");
                }
                throw new InvalidLogPropertiesException();
            }
        } else if (!(logProperties instanceof FileLogProperties)) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to create non-file based recovery log");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getRecoveryLog");
            }
            throw new InvalidLogPropertiesException();
        }
        object = new Integer(logProperties.logIdentifier());
        RecoveryLog recoveryLog = null;
        HashMap<FailureScope, RecoveryLog> hashMap = (HashMap<FailureScope, RecoveryLog>)this._recoveryLogs.get(object);
        if (hashMap != null) {
            recoveryLog = (RecoveryLog)hashMap.get(failureScope);
        } else {
            hashMap = new HashMap<FailureScope, RecoveryLog>();
            this._recoveryLogs.put(object, hashMap);
        }
        if (recoveryLog == null) {
            if (logProperties instanceof FileLogProperties) {
                MultiScopeRecoveryLog multiScopeRecoveryLog = null;
                HashMap<String, MultiScopeRecoveryLog> hashMap2 = null;
                String string = failureScope.serverName();
                FileLogProperties fileLogProperties = (FileLogProperties)logProperties;
                int n = fileLogProperties.logType();
                if (n == 0) {
                    hashMap2 = (HashMap<String, MultiScopeRecoveryLog>)this._multiScopeRecoveryLogs.get(object);
                    if (hashMap2 != null) {
                        multiScopeRecoveryLog = (MultiScopeRecoveryLog)hashMap2.get(string);
                    } else {
                        hashMap2 = new HashMap<String, MultiScopeRecoveryLog>();
                        this._multiScopeRecoveryLogs.put(object, hashMap2);
                    }
                }
                if (multiScopeRecoveryLog == null) {
                    multiScopeRecoveryLog = new MultiScopeRecoveryLog(fileLogProperties, this._recoveryAgent, failureScope);
                    if (n == 0) {
                        hashMap2.put(string, multiScopeRecoveryLog);
                    }
                }
                recoveryLog = new RecoveryLogImpl(multiScopeRecoveryLog, failureScope);
            } else {
                try {
                    Constructor<?> constructor = Class.forName("com.ibm.ws390.recoverylog.spi.IXGRecoveryLogImpl").getConstructor(FailureScope.class, StreamLogProperties.class, RecoveryAgent.class);
                    recoveryLog = (RecoveryLog)constructor.newInstance(failureScope, (StreamLogProperties)logProperties, this._recoveryAgent);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl.getRecoveryLog", "278", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception caught initializing stream-based log", exception);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getRecoveryLog", "InvalidLogPropertiesException");
                    }
                    throw new InvalidLogPropertiesException(exception);
                }
            }
            hashMap.put(failureScope, recoveryLog);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryLog", recoveryLog);
        }
        return recoveryLog;
    }

    public String toString() {
        return this._traceId;
    }
}

