/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.RLSController;
import com.ibm.ws.recoverylog.spi.RLSControllerFactory;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSTimeoutRangeException;
import com.ibm.ws.recoverylog.spi.RecoveryLogServiceException;

public class RecoveryLogService {
    private static final TraceComponent tc = Tr.register(RecoveryLogService.class, "Transaction", "com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static RLSController _rlsController;

    private RecoveryLogService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RecoveryLogService");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RecoveryLogService", this);
        }
    }

    public static RLSSuspendToken suspend(int n) throws RLSTimeoutRangeException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend", new Integer(n));
        }
        RLSSuspendToken rLSSuspendToken = null;
        try {
            rLSSuspendToken = RecoveryLogService.getRLSController().suspend(n);
        }
        catch (RLSTimeoutRangeException rLSTimeoutRangeException) {
            FFDCFilter.processException(rLSTimeoutRangeException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", "53");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow RLSTimeoutRangeException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend");
            }
            throw rLSTimeoutRangeException;
        }
        catch (RecoveryLogServiceException recoveryLogServiceException) {
            FFDCFilter.processException(recoveryLogServiceException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", "63");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoveryLogServiceException caught trying to suspend RLS - rethrowing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "suspend");
            }
            throw recoveryLogServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend", rLSSuspendToken);
        }
        return rLSSuspendToken;
    }

    public static void resume(RLSSuspendToken rLSSuspendToken) throws RLSInvalidSuspendTokenException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", rLSSuspendToken);
        }
        try {
            RecoveryLogService.getRLSController().resume(rLSSuspendToken);
        }
        catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
            FFDCFilter.processException(rLSInvalidSuspendTokenException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", "81");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow RLSInvalidSuspendTokenException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw rLSInvalidSuspendTokenException;
        }
        catch (RecoveryLogServiceException recoveryLogServiceException) {
            FFDCFilter.processException(recoveryLogServiceException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", "91");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoveryLogServiceException caught trying to resume RLS - rethrowing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw recoveryLogServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    public static void resume(byte[] byArray) throws RLSInvalidSuspendTokenException, RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume", Util.toHexString(byArray));
        }
        try {
            RecoveryLogService.getRLSController().resume(byArray);
        }
        catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
            FFDCFilter.processException(rLSInvalidSuspendTokenException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", "81");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Rethrow RLSInvalidSuspendTokenException");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw rLSInvalidSuspendTokenException;
        }
        catch (RecoveryLogServiceException recoveryLogServiceException) {
            FFDCFilter.processException(recoveryLogServiceException, "com.ibm.ws.recoverylog.spi.RecoveryLogService.suspend", "91");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoveryLogServiceException caught trying to resume RLS - rethrowing");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "resume");
            }
            throw recoveryLogServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    private static RLSController getRLSController() throws RecoveryLogServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRLSController");
        }
        RLSController rLSController = null;
        if (_rlsController == null) {
            try {
                rLSController = RLSControllerFactory.getRLSController();
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.recoverylog.spi.RecoveryLogService.getRLSController", "115");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Rethrow as RecoveryLogServiceException");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getRLSController");
                }
                throw new RecoveryLogServiceException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRLSController", rLSController);
        }
        return rLSController;
    }
}

